program DirectoryUsage;
{ INFO Ŀ}
{ File    : DU.PAS                                                         }
{ Author  : Harald Thunem                                                  }
{ Purpose : Gives information about sub-directory sizes.                   }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses  Dos,
      Screen,
      NBorder,
      NCommon,
      Keyboard,
      Strings;

const MaxDirs    = 500;
      MainAttr   = White+BlueBG;
      TopAttr1   = Magenta+LightWhiteBG;
      TopAttr2   = White+CyanBG;
      BottomAttr1= LightMagenta+LightWhiteBG;
      BottomAttr2= Magenta+LightWhiteBG;
      GraphAttr  = Yellow;

type  PDirRec    = ^TDirRec;
      TDirRec    = record
                     Name: string;
                     Size: longint;
                   end;

var   DirList    : array[1..MaxDirs] of PDirRec;
      DirFile    : file of TDirRec;
      FileName   : string;
      DriveList  : array[1..26] of char;
      TotalDiskSpace,
      UsedDiskSpace,
      FreeDiskSpace,
      TotalDirSize,
      BiggestDir : longint;
      NumDrives,
      DriveNum,
      NumDirs    : word;
      Drive      : char;
      Path       : string;


procedure GetDrives;
var i,w: byte;
begin
  NumDrives := 1;
  Port[$70] := $14;
  w := Port[$71];
  w := w and $C0;
  DriveList[NumDrives] := 'A';
  if w=$40 then
  begin
    Inc(NumDrives);
    DriveList[NumDrives] := 'B';
  end;
  Write('Analyzing drives');
  for i := 3 to 26 do
  if DiskSize(i)>-1 then
  begin
    Write('.');
    Inc(NumDrives);
    DriveList[NumDrives] := Chr(i+64);
  end;
  WriteLn;
end;


procedure GetDirSize(Dir: string; var DirSize: longint);
var Tmp: longint;
    S: SearchRec;
begin
  DirSize := 0;
  Dir := Dir+'\';
  FindFirst(Dir+'*.*',AnyFile,S);
  while DosError=0 do
  if S.Attr and Directory = Directory then
  begin
    if (S.Name<>'.') and (S.Name<>'..') then
    begin
      GetDirSize(Dir+S.Name,Tmp);
      DirSize := DirSize + Tmp;
    end;
    FindNext(S);
  end
  else begin
    DirSize := DirSize + S.Size;
    FindNext(S);
  end;
end;


function ReadFile(Drive: char): boolean;
begin
  {$I-}
  Assign(DirFile,Drive+':\DUINFO.HT');
  Reset(DirFile);
  {$I+}
  BiggestDir := 0;
  TotalDirSize := 0;
  if IOResult=0 then
  begin
    NumDirs := 0;
    while not Eof(DirFile) do
    begin
      Inc(NumDirs);
      GetMem(DirList[NumDirs],SizeOf(TDirRec));
      Read(DirFile,DirList[NumDirs]^);
      with DirList[NumDirs]^ do
      begin
        if Size > BiggestDir then
          BiggestDir := Size;
        TotalDirSize := TotalDirSize + Size;
      end;
    end;
    Close(DirFile);
    ReadFile:=true;
  end
  else ReadFile:=false;
end;


procedure EraseList;
var i: word;
begin
  if NumDirs>0 then
  for i := 1 to NumDirs do
    FreeMem(DirList[i],SizeOf(TDirRec));
end;


procedure QuitProgram;
begin
  EraseList;
  ClrScr;
  SetCursor(CursorUnderline);
  SetBlink;
  OldBorder;
  Halt(1);
end;


function GetList(Drive: char; DriveNum: byte; ForceScan: boolean): boolean;
var S: SearchRec;
    Scr: pointer;
    i,
    Row,
    Col,
    Size: word;

  procedure SaveFile(Drive: char);
  var i: word;
  begin
    {$I-}
    Assign(DirFile,Drive+':\DUINFO.HT');
    Rewrite(DirFile);
    {$I+}
    if IOResult=0 then
      for i := 1 to NumDirs do
        Write(DirFile,DirList[i]^)
    else MessageBox('Error saving info to file !');
  end;

begin
  if DiskSize(DriveNum)<0 then
  repeat
    MessageBox('Insert diskette in Drive '+Drive);
  until (DiskSize(DriveNum)>-1) or (Key=Escape);
  if Key=Escape then
  begin
    Key := NullKey;
    GetList := false;
    if NumDirs=0 then QuitProgram;
    Exit;
  end;
  TotalDiskSpace := DiskSize(DriveNum);
  FreeDiskSpace := DiskFree(DriveNum);
  UsedDiskSpace := TotalDiskSpace-FreeDiskSpace;
  if not ForceScan then
  if ReadFile(Drive) then Exit;
  Size := 2*7*30;
  Row := (CRTRows div 2) - 3;
  Col := 25;
  GetMem(Scr,Size);
  StoreToMem(Row,Col,7,30,Scr^);
  NewBox(Row,Col,6,28,White+CyanBG,' ');
  AddShadow(Row,Col,6,28);
  WriteStr(Row+1,Col+4,SameAttr,'Analyzing directory-');
  WriteStr(Row+2,Col+4,SameAttr,'structure on drive '+Drive+':');

  NumDirs := 0;
  TotalDirSize := 0;
  BiggestDir := 0;
  FindFirst(Drive+':\*.*',AnyFile,S);
  while DosError=0 do
  if S.Attr and Directory = Directory then
  begin
    WriteStr(Row+4,Col+8,White+CyanBG,'          ');
    WriteC(Row+4,Col+12,SameAttr,S.Name);
    Inc(NumDirs);
    GetMem(DirList[NumDirs],SizeOf(TDirRec));
    DirList[NumDirs]^.Name := S.Name;
    with DirList[NumDirs]^do
    begin
      GetDirSize(Drive+':\'+Name,Size);
      if Size>BiggestDir then
        BiggestDir := Size;
      TotalDirSize := TotalDirSize + Size;
    end;
    FindNext(S);
  end
  else FindNext(S);
  SaveFile(Drive);
  StoreToScr(Row,Col,7,30,Scr^);
  FreeMem(Scr,Size);
  GetList := true;
end;


procedure SortList(ByName: boolean);
var SubSort,Sorted: boolean;
    Tmp: PDirRec;
    i: word;
begin
  repeat
    Sorted := true;
    for i := 1 to NumDirs-1 do
    begin
      if ByName then
        SubSort := (DirList[i]^.Name < DirList[i+1]^.Name)
      else SubSort := (DirList[i]^.Size >= DirList[i+1]^.Size);
      if not SubSort then
      begin
        Tmp := DirList[i];
        DirList[i] := DirList[i+1];
        DirList[i+1] := Tmp;
        Sorted := false;
      end;
    end;
  until Sorted;
end;


procedure Background;
var Attr: byte;
begin
  Explode(1,1,CRTRows,80,MainAttr,SingleBorder);
  NewBox(1,1,CRTRows,80,MainAttr,' ');
  Fill(1,1,1,80,TopAttr1,' ');
  WriteC(1,40,TopAttr1,'Directory Usage 2.0');
  Attr := (MainAttr and $0F) or (TopAttr2 and $F0);
  WriteStr(2,1,Attr,#184);
  WriteStr(2,80,Attr,#214);
  WriteStr(2,2,TopAttr2,' Directory      %  |                                             |    Size    ');
  Fill(CRTRows,1,1,80,BottomAttr1,' ');
  WriteStr(CRTRows,2,BottomAttr1,'F1');
  WriteEos(BottomAttr2,' - Help');
  WriteStr(CRTRows,70,BottomAttr1,'Esc');
  WriteEos(BottomAttr2,' - Quit');
end;


function SizeStr(Size: longint; L: byte): string;
var s: string;
begin
  s := StrL(Size);
  if Length(s)>3 then Insert('.',s,Length(s)-2);
  if Length(s)>7 then Insert('.',s,Length(s)-6);
  if L>11 then
  if Length(s)>11 then Insert('.',s,Length(s)-10);
  while Length(s)<L do
    s := ' ' + s;
  SizeStr := s;
end;


procedure ShowInfo;
var Scr: pointer;
    Row,
    Col,
    Size: word;
begin
  Size := 2*10*50;
  Row := (CRTRows div 2) - 3;
  Col := 15;
  GetMem(Scr,Size);
  StoreToMem(Row,Col,10,50,Scr^);
  NewBox(Row,Col,9,48,White+MagentaBG,' ');
  AddShadow(Row,Col,9,48);
  Fill(Row,Col,1,48,Magenta+LightWhiteBG,' ');
  WriteC(Row,38,SameAttr,'INFORMATION DRIVE '+Drive+':');
  WriteStr(Row+2,Col+3,SameAttr,'Total disk space     :');
  WriteStr(Row+2,Col+26,SameAttr,SizeStr(TotalDiskSpace,12)+' bytes');
  WriteStr(Row+3,Col+3,SameAttr,'Allocated disk space :');
  WriteStr(Row+3,Col+26,SameAttr,SizeStr(UsedDiskSpace,12)+' bytes');
  WriteStr(Row+4,Col+3,SameAttr,'Available disk space :');
  WriteStr(Row+4,Col+26,SameAttr,SizeStr(FreeDiskSpace,12)+' bytes');
  WriteStr(Row+6,Col+20,Blue+LightWhiteBG,#16+' OK '+#17);
  WriteStr(Row+6,Col+26,Black+MagentaBG,'');
  WriteStr(Row+7,Col+21,Black+MagentaBG,'');
  repeat
    InKey(Ch,Key);
  until Key in [Return,Escape];
  StoreToScr(Row,Col,10,50,Scr^);
  FreeMem(Scr,Size);
  Key := NullKey;
end;


procedure Help;
var Scr: pointer;
    Row,
    Col,
    Size: word;
begin
  Size := 2*18*60;
  Row := (CRTRows div 2) - 8;
  Col := 10;
  GetMem(Scr,Size);
  StoreToMem(Row,Col,18,60,Scr^);
  NewBox(Row,Col,17,58,White+LightBlackBG,' ');
  AddShadow(Row,Col,17,58);
  Fill(Row,Col,1,58,Magenta+LightWhiteBG,' ');
  WriteC(Row,38,SameAttr,'H E L P');
  WriteStr(Row+ 2,Col+3,LightCyan+LightBlackBG,'Directory Usage');
  WriteEos(SameAttr,' will show the amount of disk space');
  WriteStr(Row+ 3,Col+3,SameAttr,'allocated by the main sub-directories. The list of');
  WriteStr(Row+ 4,Col+3,SameAttr,'directories can be scrolled and sorted by name and');
  WriteStr(Row+ 5,Col+3,SameAttr,'size. The info will be saved to the file DUINFO.HT');
  WriteStr(Row+ 6,Col+3,SameAttr,'at the root directory for faster retrieval.');
  WriteStr(Row+ 8,Col+3,LightCyan+LightBlackBG,'Commands');
  WriteStr(Row+ 9,Col+3,Yellow+LightBlackBG,'F1');
  WriteEos(White+LightBlackBG,' - This help');
  WriteStr(Row+10,Col+3,Yellow+LightBlackBG,'F2');
  WriteEos(White+LightBlackBG,' - Re-scan drive');
  WriteStr(Row+11,Col+3,Yellow+LightBlackBG,#24+#25);
  WriteEos(White+LightBlackBG,' - Scroll up/down');
  WriteStr(Row+12,Col+3,Yellow+LightBlackBG,'Esc');
  WriteEos(White+LightBlackBG,'- Quit');
  WriteStr(Row+ 9,Col+33,Yellow+LightBlackBG,'Alt-N');
  WriteEos(White+LightBlackBG,' - Sort by name');
  WriteStr(Row+10,Col+33,Yellow+LightBlackBG,'Alt-S');
  WriteEos(White+LightBlackBG,' - Sort by size');
  WriteStr(Row+11,Col+33,Yellow+LightBlackBG,'Alt-I');
  WriteEos(White+LightBlackBG,' - Drive info');
  WriteStr(Row+12,Col+33,Yellow+LightBlackBG,'Alt-D');
  WriteEos(White+LightBlackBG,' - Change drive');

  WriteStr(Row+14,Col+25,Blue+LightWhiteBG,#16+' OK '+#17);
  WriteStr(Row+14,Col+31,Black+LightBlackBG,'');
  WriteStr(Row+15,Col+26,Black+LightBlackBG,'');
  repeat
    InKey(Ch,Key);
  until Key=Return;
  StoreToScr(Row,Col,18,60,Scr^);
  FreeMem(Scr,Size);
  Key := NullKey;
end;


procedure ChangeDrive(var DriveNum: word; var Drive: char);
var Scr: pointer;
    i,
    Current,
    Start,
    Row,
    Col,
    Rows,
    Cols,
    Size: word;
begin
  Cols := 11;
  Rows := 8;
  Size := 2*Rows*Cols;
  Row := (CRTRows div 2)-4;
  Col := 38-(Cols div 2);
  GetMem(Scr,Size);
  StoreToMem(Row,Col,Rows,Cols,Scr^);
  NewBox(Row,Col,Rows-1,Cols-2,White+LightBlackBG,' ');
  AddShadow(Row,Col,Rows-1,Cols-2);
  Fill(Row,Col,1,Cols-2,Magenta+LightWhiteBG,' ');
  WriteC(Row,Col+4,SameAttr,'Drive');
  for i := 1 to NumDrives do
  if i < 5 then
    WriteStr(Row+1+i,Col+4,SameAttr,DriveList[i]);
  Start := 1;
  while DriveNum>(Start+3) do
  begin
    Inc(Start);
    ScrollUp(Row+2,Col+2,Rows-4,Cols-6,White+LightBlackBG);
    WriteStr(Row+5,Col+4,SameAttr,DriveList[Start+3]);
  end;
  Current:=0;
  repeat
    Inc(Current)
  until DriveList[Current] = Drive;
  WriteStr(Row+2+Current-Start,Col+2,Blue+LightWhiteBG,'  '+DriveList[Current]+'  ');
  repeat
    Inkey(Ch,Key);
    WriteStr(Row+2+Current-Start,Col+2,White+LightBlackBG,'  '+DriveList[Current]+'  ');
    case Key of
      UpArrow  : if Current>1 then Dec(Current);
      DownArrow: if Current<NumDrives then Inc(Current);
    end;
    if Current<Start then
    begin
      ScrollDown(Row+2,Col+2,Rows-4,Cols-6,White+LightBlackBG);
      Dec(Start);
    end;
    if Current>(Start+3) then
    begin
      ScrollUp(Row+2,Col+2,Rows-4,Cols-6,White+LightBlackBG);
      Inc(Start);
    end;
    WriteStr(Row+2+Current-Start,Col+2,Blue+LightWhiteBG,'  '+DriveList[Current]+'  ');
  until Key in [Return,Escape];
  if Key=Return then
  begin
    Drive := DriveList[Current];
    DriveNum := Ord(Drive)-64;
  end;
  StoreToScr(Row,Col,Rows,Cols,Scr^);
  FreeMem(Scr,Size);
  Key := NullKey;
end;


procedure ScrollList;
var Start,
    OldDriveNum,
    Current: word;
    OldDrive: char;

  procedure WriteLine(Row: byte; DirNum: word);
  const MaxLine=45;
  var i,LineLength: byte;
      FractionSize: single;
  begin
    with DirList[DirNum]^do
    begin
      WriteStr(Row,3,MainAttr,Name);
      WriteStr(Row,68,MainAttr,SizeStr(Size,11));
      FractionSize := Size / TotalDirSize;
      WriteStr(Row,15,MainAttr,StrRFD(100*FractionSize,5,1));
      FractionSize := Size / BiggestDir;
    end;
    LineLength := Round(FractionSize * MaxLine);
    if LineLength=0 then Exit;
    Fill(Row,22,1,LineLength,GraphAttr,'');
    for i := 1 to LineLength do
    if (ReadAttr(Row+1,22+i)=MainAttr) or (ReadAttr(Row+1,22+i)=(MainAttr and $F0)) then
    begin
      if ReadChar(Row+1,22+i)='' then
        WriteStr(Row+1,22+i,MainAttr and $F0,'')
      else WriteStr(Row+1,22+i,MainAttr and $F0,'');
    end;
    if ReadAttr(Row,22+LineLength)=(MainAttr and $F0) then
      WriteStr(Row,22+LineLength,MainAttr and $F0,'')
    else WriteStr(Row,22+LineLength,MainAttr and $F0,'');
  end;

  procedure WritePage(Start: word);
  var i: word;
      FractionSize: single;
  begin
    Fill(3,3,CRTRows-3,76,MainAttr,' ');
    for i := 1 to CRTRows-3 do
    if Start+i-1<=NumDirs then
    with DirList[Start+i-1]^ do
      WriteLine(2+i,Start+i-1);
  end;

begin
  Start := 1;
  WritePage(Start);
  Key := NullKey;
  repeat
    InKey(Ch,Key);
    case Key of
      UpArrow  : if Start>1 then
                 begin
                   ScrollDown(3,2,CRTRows-3,78,MainAttr);
                   Dec(Start);
                   WriteLine(3,Start);
                 end;
      DownArrow: if Start<NumDirs then
                 begin
                   ScrollUp(3,2,CRTRows-3,78,MainAttr);
                   Inc(Start);
                   if (Start+CRTRows-5)<NumDirs then
                     WriteLine(CRTRows-1,Start+CRTRows-4);
                   if (Start+CRTRows-6)<NumDirs then
                     WriteLine(CRTRows-2,Start+CRTRows-5);
                 end;
      AltN     : begin
                   SortList(true);
                   Writepage(Start);
                 end;
      AltS     : begin
                   SortList(false);
                   Writepage(Start);
                 end;
      AltI     : ShowInfo;
      AltD     : begin
                   OldDriveNum := DriveNum;
                   OldDrive := Drive;
                   ChangeDrive(DriveNum,Drive);
                   if DriveNum<>OldDriveNum then
                   if GetList(Drive,DriveNum,false) then
                   begin
                     Start := 1;
                     SortList(true);
                     Writepage(Start);
                   end
                   else begin
                     Drive := OldDrive;
                     DriveNum := OldDriveNum;
                   end;
                 end;
      F1       : Help;
      F2       : if Confirm('Re-scan drive '+Drive,true) then
                 begin
                   EraseList;
                   if GetList(Drive,DriveNum,true) then
                     SortList(true);
                   Start := 1;
                   Writepage(Start);
                 end;
      Escape   : if Confirm('Quit program',true) then
                 Key:=Escape;
    end;
  until Key=Escape;
  Key := NullKey;
end;


procedure ShowOptions;
begin
  WriteLn('Program: Directory Usage 2.0');
  WriteLn('Author : Harald Thunem');
  WriteLn('Purpose: Gives a scrollable list of the usage of each main sub-directories.');
  WriteLn('Usage  : DU [Drive:]');
  WriteLn('         Ex:    DU c:');
  WriteLn('         When no parameter is given, the program uses');
  WriteLn('         the currently active drive.');
  WriteLn('Updated: July 4. 1992');
  Halt(1);
end;


begin
  WriteLn('Directory Usage 2.0                                          Written by H.Thunem');
  Drive := 'C';
  if ParamCount=0 then
  begin
    GetDir(0,Path);
    Drive := Path[1];
  end
  else begin
    Path := ParamStr(1);
    Path[1] := Upcase(Path[1]);
    if Path[1] in ['A'..'Z'] then
      Drive := Path[1]
    else ShowOptions;
  end;
  NumDirs := 0;
  DriveNum := Ord(Drive)-64;
  if TotalDiskSpace=-1 then
  begin
    WriteLn('Could not find drive ',Drive,'. Halting....');
    Halt(1);
  end;
  GetDrives;
  SetCursor(CursorOff);
  SetIntens;
  NewBorder;
  Background;
  if GetList(Drive,DriveNum,false) then
    SortList(true);
  ScrollList;
  QuitProgram;
end.