program DiskInfo;
{ INFO Ŀ}
{ File    : DI.PAS                                                         }
{ Author  : Harald Thunem                                                  }
{ Purpose : Gives relevant information about the harddisk.                 }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses Dos,
     Screen,
     Strings;


var  TotalSpace,
     UsedSpace,
     FreeSpace  : longint;
     Drive      : byte;
     DriveLetter: char;
     s          : string;


procedure GetInfo;
begin
  Write('Analyzing drive ',DriveLetter,'...');
  TotalSpace := DiskSize(Drive);
  FreeSpace := DiskFree(Drive);
  UsedSpace := TotalSpace-FreeSpace;
end;


procedure AddSmallShadow(Row,Col,Rows,Cols: byte);
var i,Attr: byte;
begin
  for i := 1 to Cols do
  begin
    Attr := ReadAttr(Row+Rows,Col+i) and $F0;
    WriteStr(Row+Rows,Col+i,Attr,'');
  end;
  for i := 1 to Rows-1 do
  begin
    Attr := ReadAttr(Row+i,Col+Cols) and $F0;
    WriteStr(Row+i,Col+Cols,Attr,'');
  end;
  Attr := ReadAttr(Row,Col+Cols) and $F0;
  WriteStr(Row,Col+Cols,Attr,'');
end;


procedure Background;
begin
  ClrScr;
  Explode(1,1,13,80,White+BlueBG,DoubleBorder);
  Fill(2,5,3,72,White+CyanBG,' ');
  Box(2,6,3,70,White+CyanBG,SingleBorder,' ');
  AddSmallShadow(2,5,3,72);
  WriteC(3,40,SameAttr,'Disk Information');
end;


function DotStr(l: longint): string;
var s: string;
    sl: byte;
begin
  s := StrL(l);
  sl := Length(s);
  if sl>3 then Insert(',',s,sl-2);
  sl := Length(s);
  if sl>7 then Insert(',',s,sl-6);
  sl := Length(s);
  if sl>11 then Insert(',',s,sl-10);
  DotStr := s;
end;


procedure WriteInfo;
const Max=72;
var   MBUsed,
      MBFree,
      FractionFree,
      FractionUsed : single;
      i,m          : byte;
      s            : string;
begin
  FractionFree := FreeSpace/TotalSpace;
  FractionUsed := UsedSpace/TotalSpace;
  WriteStr(6,5,Yellow+BlueBG,'Usage drive '+DriveLetter+':');
  m := Max;
  for i := 1 to m do
  begin
    WriteStr(7,4+i,Yellow,'');
    WriteStr(8,5+i,Blue+BlackBG,'');
    WriteStr(7,5+i,Blue+BlackBG,'');
    Delay(4);
  end;
  m := Round(Max*FractionUsed);
  for i := 1 to m do
  begin
    WriteStr(7,4+i,LightCyan+BlueBG,'');
    Delay(5);
  end;

  MBUsed := 1E-06*UsedSpace;
  WriteStr(9,5,LightCyan+BlueBG,'');
  AddSmallShadow(9,5,1,3);
  WriteStr(9,10,Yellow+BlueBG,'Used ('+StrRFD(MBUsed,5,1)+'MB)');

  MBFree := 1E-06*FreeSpace;
  WriteStr(11,5,Yellow,'');
  AddSmallShadow(11,5,1,3);
  WriteStr(11,10,Yellow+BlueBG,'Free ('+StrRFD(MBFree,5,1)+'MB)');

  s := DotStr(TotalSpace);
  WriteStr( 9,40-Length(s),White+BlueBG,s+' bytes total disk space');

  s := DotStr(UsedSpace);
  WriteStr(10,40-Length(s),White+BlueBG,s+' bytes currently allocated');
  WriteStr(10,69,LightCyan+BlueBG,'('+StrRFD(100*FractionUsed,5,1)+'%)');

  s := DotStr(FreeSpace);
  WriteStr(11,40-Length(s),White+BlueBG,s+' bytes available on disk');
  WriteStr(11,69,LightCyan+BlueBG,'('+StrRFD(100*FractionFree,5,1)+'%)');

  GoToRC(13,1);
end;



begin
  WriteLn('Disk Information 2.0                                         Written by H.Thunem');
  if ParamCount>1 then
  begin
    WriteLn('Example:  DU     {gives disk info on current drive}');
    WriteLn('          DU C:  {gives disk info on drive C      }');
    Halt(1);
  end;
  s := ParamStr(ParamCount);
  DriveLetter := Upcase(s[1]);
  Drive := Ord(DriveLetter)-64;
  GetInfo;
  if TotalSpace=-1 then
  begin
    WriteLn('Error reading Drive ',DriveLetter,'.  Halting program...');
    Halt(1);
  end;
  SetCursor(CursorOff);
  Background;
  WriteInfo;
  SetCursor(CursorUnderline);
end.
