unit Colors;
{Ŀ}
{ File    : COLORS.PAS                                                     }
{ Author  : Harald Thunem                                                  }
{ Purpose : VGA color palette routines                                     }
{ Updated : July 13 1992                                                   }
{}
interface

const CList    : array[0..15] of byte = ($00,$01,$02,$03,$04,$05,$14,$07,
                                         $38,$39,$3A,$3B,$3C,$3D,$3E,$3F);


type  TColor   = record
                   R,G,B : byte;
                 end;


var   ColorList: array[0..15] of TColor;


procedure GetTEXTPalette(PaletteReg: byte;  var ColorNum: byte);
procedure SetTEXTPalette(PaletteReg,ColorNum: byte);
procedure GetDACRegister(ColorNum: byte;  var RedValue,GreenValue,BlueValue: byte);
procedure SetDACRegister(ColorNum,RedValue,GreenValue,BlueValue: byte);
procedure GetColorList;
procedure SetColorList;
function ReadDACFile(Filename: string): boolean;
procedure WriteDACFile(Filename: string);

implementation


uses Dos;

var   Regs : registers;
      CFile: file of TColor;


procedure GetTEXTPalette(PaletteReg: byte;  var ColorNum: byte);
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $10;
  Regs.AL := $07;
  Regs.BL := PaletteReg;
  Intr($10,Regs);
  ColorNum := Regs.BH;
end;


procedure SetTEXTPalette(PaletteReg,ColorNum: byte);
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $10;
  Regs.AL := $00;
  Regs.BL := PaletteReg;
  Regs.BH := ColorNum;
  Intr($10,Regs);
end;


procedure GetDACRegister(ColorNum: byte;  var RedValue,GreenValue,BlueValue: byte);
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $10;
  Regs.AL := $15;
  Regs.BX := ColorNum;
  Intr($10,Regs);
  RedValue   := Regs.DH;
  GreenValue := Regs.CH;
  BlueValue  := Regs.CL;
end;


procedure SetDACRegister(ColorNum,RedValue,GreenValue,BlueValue: byte);
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $10;
  Regs.AL := $10;
  Regs.BX := ColorNum;
  Regs.DH := RedValue;
  Regs.CH := GreenValue;
  Regs.CL := BlueValue;
  Intr($10,Regs);
end;


procedure GetColorList;
var i: byte;
begin
  for i := 0 to 15 do
  with ColorList[i] do
    GetDACRegister(CList[i],R,G,B);
end;


procedure SetColorList;
var i: byte;
begin
  for i := 0 to 15 do
  with ColorList[i] do
    SetDACRegister(CList[i],R,G,B);
end;


function ReadDACFile(Filename: string): boolean;
var i: byte;
begin
  {$I-}
  Assign(CFile,Filename);
  ReSet(CFile);
  {$I+}
  if IOResult=0 then
  begin
    for i := 0 to 15 do
      Read(CFile,ColorList[i]);
    Close(CFile);
    ReadDACFile := true;
  end
  else ReadDACFile := false;
end;


procedure WriteDACFile(Filename: string);
var i: byte;
begin
  Assign(CFile,Filename);
  ReWrite(CFile);
  for i := 0 to 15 do
    Write(CFile,ColorList[i]);
  Close(CFile);
end;

end.