unit FEUnit;
{$O+,F+}
{Ŀ}
{                                                                 }
{   File    : FEUNIT.PAS                                          }
{   Author  : Harald Thunem                                       }
{   Purpose : Routines to use your own screen fonts               }
{   Updated : February 16 1992                                    }
{                                                                 }
{}


{}
interface
{}

uses  Dos;

const BytesPerChar = 16;

type  OneChar      = array[1..BytesPerChar] of byte;
      FontType     = array[0..255] of OneChar;

var   Regs         : registers;
      Font         : FontType;
      FontFile     : file of FontType;


procedure LoadOneChar(Number: byte;  var C: OneChar);
procedure LoadUserFont;
function ReadFontFile(FontFileName: string): boolean;


{}
implementation
{}


procedure LoadOneChar(Number: byte;  var C: OneChar);
begin
  Font[Number] := C;
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $11;
  Regs.AL := $00;
  Regs.BL := 0;
  Regs.BH := BytesPerChar;                   { bytes pr character            }
  Regs.ES := Seg(Font);                      { segment address of font table }
  Regs.BP := Ofs(Font)+BytesPerChar*Number;  { offset address of font table  }
  Regs.CX := 1;                              { number of characters to load  }
  Regs.DX := Number;                         { table character offset        }
  Intr($10,Regs);
end;


procedure LoadUserFont;
begin
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $11;
  Regs.AL := $00;
  Regs.BL := 0;
  Regs.BH := BytesPerChar;                   { bytes pr character            }
  Regs.ES := Seg(Font);                      { segment address of font table }
  Regs.BP := Ofs(Font);                      { offset address of font table  }
  Regs.CX := 255;                            { number of characters to load  }
  Regs.DX := 0;                              { table character offset        }
  Intr($10,Regs);
end;


function ReadFontFile(FontFileName: string): boolean;
begin
  {$I-}
  Assign(FontFile,FontFileName);
  ReSet(FontFile);
  {$I+}
  if IOResult=0 then
  begin
    Read(FontFile,Font);
    Close(FontFile);
    ReadFontFile := true;
  end
  else ReadFontFile := false;
end;

end.
