program MemoryInfo;
{ INFO Ŀ}
{ File    : MI.PAS                                                         }
{ Author  : Harald Thunem                                                  }
{ Purpose : Provide information about RAM, extended and expanded memory.   }
{ Updated : July 2 1992                                                    }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}
uses Dos,
     Screen,
     Keyboard,
     Strings;

var  Regs        : registers;
     TotalRAM,
     AvailRAM,
     TotalXMS,
     PagesInst,
     PagesAvail,
     TotalEXP,
     AvailEXP,
     SystemEXP,
     OtherEXP,
     i,NumHandles: word;
     EXTInfo,
     EXPInstalled: boolean;
     EXPVersion  : string;
     PList       : array[1..512] of record
                                      Handle,Pages: word;
                                    end;

procedure GetRAMInfo;
{Ŀ}
{  Get Random Access Memory information                                    }
{}
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Intr($12,Regs);
  TotalRAM := Regs.AX;                { Total RAM on system (usually 640 Kb) }
  AvailRAM := (MemAvail div 1000)+24; { Available RAM, 24 Kb used by program }
end;


procedure GetEXPInfo;
{Ŀ}
{  Get expanded memory information                                         }
{}
var v1,v2: byte;
begin
  { Check if installed expanded memory }
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $40;
  Intr($67,Regs);
  EXPInstalled := (Regs.AH = 0);

  if not EXPInstalled then
    Exit;

  { Check number of installed and available 16K pages }
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $42;
  Intr($67,Regs);
  PagesInst  := Regs.DX;
  PagesAvail := Regs.BX;
  TotalEXP   := 16*PagesInst;  { Total expanded in KBytes     }
  AvailEXP   := 16*PagesAvail; { Available expanded in KBytes }

  { Get LIM version number }
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $46;
  Intr($67,Regs);
  v1 := Regs.AL shr 4;
  v2 := Regs.AL and $0F;
  EXPVersion := StrL(v1)+'.'+StrL(v2);

  { Get number of pages occupied by each handle }
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $4D;
  Regs.ES := Seg(PList);
  Regs.DI := Ofs(PList);
  Intr($67,Regs);
  NumHandles := Regs.BX;
  SystemEXP := 16*PList[1].Pages;
  OtherEXP := 0;
  for i := 2 to NumHandles do
    OtherEXP := OtherEXP + 16*PList[i].Pages;
end;


procedure GetXMSInfo;
{Ŀ}
{  Get extended memory in KBytes                                           }
{}
var b1,b2: word;
begin
  Port[$70] := $30;
  b1 := Port[$71];
  Port[$70] := $31;
  b2 := Port[$71];
  TotalXMS := (b2 shl 8) + b1;
end;


procedure QuitProgram(b: byte);
begin
  SetCursor(CursorUnderline);
  case b of
    1: GotoRC(16,1);
    2: begin
         Fill(25,1,1,80,White+BlackBG,' ');
         GotoRC(24,1);
       end;
    3: GotoRC(15,1);
  end;
  Halt(0);
end;


procedure AddSmallShadow(Row,Col,Rows,Cols: byte);
var i,Attr: byte;
begin
  for i := 1 to Cols do
  begin
    Attr := ReadAttr(Row+Rows,Col+i) and $F0;
    WriteStr(Row+Rows,Col+i,Attr,'');
  end;
  for i := 1 to Rows-1 do
  begin
    Attr := ReadAttr(Row+i,Col+Cols) and $F0;
    WriteStr(Row+i,Col+Cols,Attr,'');
  end;
  Attr := ReadAttr(Row,Col+Cols) and $F0;
  WriteStr(Row,Col+Cols,Attr,'');
end;


procedure DrawInfo;
const Max=60;
var   MBUsed,
      MBFree,
      FractionFree,
      FractionUsed : single;
      Start,
      i,m          : byte;
      s            : string;

  procedure WritePList(Num,Row,Col,Attr: byte);
  begin
    with PList[Num] do
    s := ' '+StrLF(Handle,3)+'    '+StrLF(Pages,4)+'  '+StrLF(16*Pages,5)+' ';
    WriteStr(Row,Col,Attr,s);
  end;

begin
  ClrScr;
  SetCursor(CursorOff);
  if not EXTInfo then
    Explode(1,1,15,80,White+BlueBG,DoubleBorder)
    else if TotalEXP<=0 then
      Explode(1,1,16,80,White+BlueBG,DoubleBorder)
    else Explode(1,1,25,80,White+BlueBG,DoubleBorder);
  Fill(2,5,3,72,White+CyanBG,' ');
  Box(2,6,3,70,White+CyanBG,SingleBorder,' ');
  AddSmallShadow(2,5,3,72);
  WriteC(3,40,SameAttr,'Memory Information');

  WriteStr(6,5,White+GreenBG,' RAM      ');
  AddSmallShadow(6,5,1,10);
  FractionFree := AvailRAM / TotalRAM;
  FractionUsed := 1-FractionFree;
  m := Max;
  for i := 1 to m do
  begin
    WriteStr(6,16+i,Yellow,'');
    WriteStr(7,17+i,Blue+BlackBG,'');
    WriteStr(6,17+i,Blue+BlackBG,'');
    Delay(4);
  end;
  m := Round(Max*FractionUsed);
  for i := 1 to m do
  begin
    WriteStr(6,16+i,LightCyan+BlueBG,'');
    Delay(5);
  end;
  WriteStr(8,17,LightCyan+BlueBG,'');
  WriteEos(White+BlueBG,'  Used');
  AddSmallShadow(8,17,1,3);
  WriteStr(10,17,Yellow,'');
  WriteEos(White+BlueBG,'  Free');
  AddSmallShadow(10,17,1,3);
  Fill(8,40,3,37,White+GreenBG,' ');
  AddSmallShadow(8,40,3,37);
  WriteStr( 8,40,SameAttr,'    Total system RAM - '+StrLF(TotalRAM,3)+' Kbytes');
  WriteStr( 9,40,SameAttr,'  - Used RAM         - '+StrLF(TotalRAM-AvailRAM,3)+' Kbytes');
  WriteStr(10,40,SameAttr,'  = Available RAM    - '+StrLF(AvailRAM,3)+' Kbytes');

  if not EXTInfo then
  begin
    WriteStr(13,15,White+CyanBG,' MI /X   to get info about extended/expanded memory ');
    AddSmallShadow(13,15,1,52);
    QuitProgram(3);
  end;
  WriteStr(12,5,White+RedBG,' EXTENDED ');
  AddSmallShadow(12,5,1,10);
  if TotalXMS<=0 then
  begin
    WriteStr(12,17,White+RedBG,' Not available ');
    AddSmallShadow(12,17,1,15);
  end
  else begin
    s := ' '+StrL(TotalXMS)+' Kbytes (from CMOS) ';
    WriteStr(12,17,White+RedBG,s);
    AddSmallShadow(12,17,1,Length(s));
  end;

  WriteStr(14,5,White+MagentaBG,' EXPANDED ');
  AddSmallShadow(14,5,1,10);
  if TotalEXP<=0 then
  begin
    WriteStr(14,17,White+MagentaBG,' Not available ');
    AddSmallShadow(14,17,1,15);
    QuitProgram(1);
  end;
  FractionFree := AvailEXP / TotalEXP;
  FractionUsed := 1-FractionFree;
  m := Max;
  for i := 1 to m do
  begin
    WriteStr(14,16+i,Yellow,'');
    WriteStr(15,17+i,Blue+BlackBG,'');
    WriteStr(14,17+i,Blue+BlackBG,'');
    Delay(4);
  end;
  m := Round(Max*FractionUsed);
  for i := 1 to m do
  begin
    WriteStr(14,16+i,LightCyan+BlueBG,'');
    Delay(5);
  end;
  Fill(16,17,8,60,White+MagentaBG,' ');
  AddSmallShadow(16,17,8,60);
  WriteStr(17,19,SameAttr,'EMM Version : LIM '+EXPVersion);
  WriteStr(19,19,SameAttr,'Total EMS memory   :   '+StrLF(TotalEXP,4)+' Kb');
  WriteStr(20,19,SameAttr,'Reserved by system : - '+StrLF(SystemEXP,4)+' Kb');
  WriteStr(21,19,SameAttr,'Allocated          : - '+StrLF(OtherEXP,4)+' Kb');
  WriteStr(22,19,SameAttr,'Available          : = '+StrLF(AvailEXP,4)+' Kb');
  WriteStr(17,52,SameAttr,'Handle  Pages   Size');
  Fill(19,52,4,20,White+LightGrayBG,' ');
  m := NumHandles;
  if m > 4 then m := 4;
  for i := 1 to m do
    WritePList(i,18+i,52,White+LightGrayBG);
  i := 1;
  Start := 1;
  WritePList(i,19+i-Start,52,White+BlackBG);
  if NumHandles<=1 then
    QuitProgram(2)
  else WriteC(25,40,Black+CyanBG,' '+#24+#25+'-Up/Down   Esc-Quit ');
  repeat
    InKey(Ch,Key);
    WritePList(i,19+i-Start,52,White+LightGrayBG);
    case Key of
      UpArrow  : if i>1 then Dec(i);
      DownArrow: if i<NumHandles then Inc(i);
    end;
    if i<Start then
    begin
      ScrollDown(19,52,4,20,White+BlackBG);
      Dec(Start);
    end;
    if i>Start+3 then
    begin
      ScrollUp(19,52,4,20,White+BlackBG);
      Inc(Start);
    end;
    WritePList(i,19+i-Start,52,White+BlackBG);
  until Key=Escape;
  QuitProgram(2);
end;


begin
  EXTInfo := false;
  if ParamCount=1 then
    if (ParamStr(1)='/x') or (ParamStr(1)='/X') then
      EXTInfo:=true;
  GetRAMInfo;
  if EXTInfo then
  begin
    GetEXPInfo;
    GetXMSInfo;
  end;
  DrawInfo;
end.