#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <strings.h>
#include <time.h>
#include <sys/types.h>

#define MAJOR 1
#define MINOR 0

static char sccsid[] = "@(#) csnack.c 1.0	(vkw@cert.org) 02/11/95";

typedef struct foobar {
   char           password[14];
   char           plaintext[8];
   struct foobar *next;
} t_snackpot;

typedef struct bar {
   char password[14];
   struct bar *next;
} t_pass;

typedef struct foo {
   char       salt[2];
   t_pass     *passwords;
   struct foo *next;
} t_user;

FILE *pwfile;
FILE *wordfile;

void save_snack_pot();

t_user *head;
t_user *current;
t_snackpot *snack_head;

unsigned long count;
unsigned long salts;
unsigned long cracked;
unsigned long compared;
unsigned long seconds;
char current_word[10];
time_t start_time;
time_t current_time;

void add_to_tree(pw)
char *pw;
{
 t_user *tmp_ptr;
 t_pass *tmp_pass;
 t_pass *cpass;

   /* allocate space for this pw */
   tmp_pass = (t_pass *) malloc(sizeof(t_pass));
   if (tmp_pass == NULL) {
      printf("error: out of memory, try splitting up passwd file\n");
      exit(1);
   }
   tmp_pass->next = NULL;
   strncpy(tmp_pass->password,pw,13);

   current = head;
   while (current != NULL) {
      if (!strncmp(pw,current->salt,2)) {
         break;
      }
      current = current->next;
   }
   if (current == NULL) {
      tmp_ptr = (t_user *) malloc(sizeof(t_user));
      if (tmp_ptr == NULL) {
         printf("error: out of memory, try splitting up passwd file\n");
         exit(1);
      }
      tmp_ptr->salt[0] = pw[0];
      tmp_ptr->salt[1] = pw[1];
      tmp_ptr->salt[2] = 0;
      tmp_ptr->next = NULL;
      tmp_ptr->passwords = tmp_pass;
      salts++;

      /* now add it to the list */
      if (head == NULL) {
         head = tmp_ptr;
      } else {
         current = head;
         while (current->next != NULL)
            current = current->next;
         current->next = tmp_ptr;
      }

   } else {
      cpass = current->passwords;
      while (cpass->next != NULL) {
         cpass = cpass->next;
      }
      cpass->next = tmp_pass;
   }
}
void load_pwfile()
{
 struct passwd *pw;

   printf("Initializing session data...\n");
   head = NULL;
   current = head;
   count = 0;
   cracked = 0;
   compared = 0;
   seconds = 0;
   memset(current_word,0,9);

   pw = (struct passwd *) 1; /* just make it non-null */
   while (pw != NULL) {
      pw = fgetpwent(pwfile);
      if (pw == NULL)
         break;

      /* skip shadowed accounts */
      if (!strcmp(pw->pw_passwd,"*"))
         continue;

      count++;

      add_to_tree(pw->pw_passwd);
   }
   fclose(pwfile);
   printf("Loaded %lu total accounts with %lu different salts.\n",count,salts);
}
void free_pwfile()
{
 t_pass *tmp_pass,*tpass;
 t_user *tmp_ptr;

   current = head;
   while (current != NULL) {
      tmp_ptr = current;
      tpass = tmp_ptr->passwords;
      while (tpass != NULL) {
         tmp_pass = tpass;
         tpass = tpass->next;
         free(tmp_pass);
      }
      current = current->next;
      free(tmp_ptr);
   }
}

void do_quit()
{
   free_pwfile();
   printf("\nAborted.\n");
   fclose(wordfile);
   save_snack_pot();
   exit(0);
}

void print_status()
{
   signal(SIGINT,print_status);
   time(&current_time);
   seconds = current_time - start_time;
   printf("\nv: %lu c: %lu s: %lu c/s: %lu w: %s ",cracked,compared,seconds,
          compared/seconds,current_word);
   fflush(stdout);
}

int pw_compare(s1,s2)
char *s1;
char *s2;
{
 register k;

   /* we don't need to check strlen because encrypted passwords are */
   /* always 13 chars (2 salt + 11 encrypted)                       */
   for (k=2;k<=11;k++) {
      if (s1[k] != s2[k])
         return 0;
   }
   return 1;
}
void load_snack_pot()
{
FILE *snackpot;
t_snackpot *tmp_ptr;
char input[100];
char *tok;

   snackpot = fopen("snack.pot","r");
   if (snackpot == NULL) {
      snack_head = NULL;
      return;
   }

   while(!feof(snackpot)) {
      fgets(input,99,snackpot);
      if (feof(snackpot))
         break;
      input[strlen(input)-1] = 0;
      tok = strtok(input,":");
      tok = strtok(NULL,":");
      if (tok == NULL)
         break;

      tmp_ptr = (t_snackpot *) malloc(sizeof(t_snackpot));

      if (tmp_ptr == NULL) {
         printf("\nerror: memory error\n");
         do_quit();
      }
      strcpy(tmp_ptr->password,input);
      strcpy(tmp_ptr->plaintext,tok);
      tmp_ptr->next = snack_head;
      snack_head = tmp_ptr;
   }
   fclose(snackpot);
}
void save_snack_pot()
{
FILE *snackpot;
t_snackpot *tmp_ptr;

   snackpot = fopen("snack.pot","w");
   if (snackpot == NULL) {
      printf("error: cannot open output file 'snack.pot'\n");
      exit(1);
   }

   tmp_ptr = snack_head;
   while (tmp_ptr != NULL) {
      fprintf(snackpot,"%s:%s\n",tmp_ptr->password,tmp_ptr->plaintext);
      tmp_ptr = tmp_ptr->next;
   }

   fclose(snackpot);
}
void add_to_snack_pot(e,w)
char *e;
char *w;
{
t_snackpot *tmp_ptr;

   tmp_ptr = snack_head;
   while (tmp_ptr != NULL) {
      if (!strcmp(tmp_ptr->password,e))
         return;
      tmp_ptr = tmp_ptr->next;
   }
   tmp_ptr = (t_snackpot *) malloc(sizeof(t_snackpot));
   if (tmp_ptr == NULL) {
      printf("\nerror: memory error\n");
      do_quit();
   }
   strcpy(tmp_ptr->password,e);
   strcpy(tmp_ptr->plaintext,w);
   tmp_ptr->next = snack_head;
   snack_head = tmp_ptr;
   printf("%c",7);
   print_status();
}
void do_crack()
{
 char input[100];
 char salt[3];
 char *epw;
 t_pass *tpa;

   time(&start_time);

   while(!feof(wordfile)) {
      /* this is our tight loop - must be FAST */
      fgets(input,100,wordfile);

      if (feof(wordfile))
         break;

      input[strlen(input)-1] = 0; 

      if (input[0] == 0)
         break;

      strncpy(current_word,input,9);

      current = head;

      while (current != NULL) {
         epw = crypt(current_word,current->salt);
         tpa = current->passwords;

         do { /* at least one */
            if (pw_compare(tpa->password,epw)) {
               cracked++;
               add_to_snack_pot(tpa->password,current_word);
            }
            tpa = tpa->next;
         } while (tpa != NULL);
         compared++;
         current = current->next;
      }
   }
}

int main(argc,argv)
int argc;
char *argv[];
{
 char pwfile_text[100];
 char wordfile_text[100];

   signal(SIGINT,print_status);
   signal(SIGTERM,do_quit);
   signal(SIGQUIT,do_quit);
   signal(SIGHUP,do_quit);
   printf("Cracker Snack version %d.%d for Linux (80x86)\n",MAJOR,MINOR);
   printf("Portions Copyright (C) 1992 Eric Young [fcrypt()]\n");
   printf("Portions Copyright (C) 1993 The Jackel, Denmark [user interface]\n");
   printf("The rest was thrown together by TH3 V3LKr0 K0D3 WaRRi0R [BoW]\n");
   printf("\n");
   if (argc > 1) {
      strncpy(pwfile_text,argv[1],99);
   } else {
      printf("PWfiles:  ");
      fgets(pwfile_text,100,stdin);
      if (pwfile_text[strlen(pwfile_text)-1] == '\n')
         pwfile_text[strlen(pwfile_text)-1] = 0;
   }
   pwfile = fopen(pwfile_text,"r");
   if (pwfile == NULL) {
      printf("error: cannot open passwd file '%s'\n",pwfile_text);
      printf("usage: %s [passwd file] [dictionary file]\n",argv[0]);
      exit(1);
   }

   if (argc > 2) {
      strncpy(wordfile_text,argv[2],99);
   } else {
      printf("Wordfile:  ");
      fgets(wordfile_text,100,stdin);
      if (wordfile_text[strlen(wordfile_text)-1] == '\n')
         wordfile_text[strlen(wordfile_text)-1] = 0;
   }
   wordfile = fopen(wordfile_text,"r");
   if (wordfile == NULL) {
      printf("error: cannot open passwd file '%s'\n",wordfile_text);
      printf("usage: %s [passwd file] [dictionary file]\n",argv[0]);
      exit(1);
   }

   load_snack_pot();
   load_pwfile();

   printf("Cracking... (Hit any Ctrl-C for status, Ctrl-\\ to abort)\n\n");

   do_crack();
   print_status();
   free_pwfile();
   fclose(wordfile);
   save_snack_pot();
   printf("\n");
}
