








              Quarterdeck Technical Note

              Subject:  Patching QEMM-386 5.10, 5.11, 5.12, 5.13, 
              6.00, and 6.01 to resolve problems with programs 
              that make calls to the IBM SCSI interface from 
              inside Windows 3 enhanced mode. 

              Background:  Programs can use interrupt 4B to make 
              calls to the IBM SCSI interface.  QEMM-386 
              intercepts interrupt 4B to detect such calls to the 
              IBM SCSI interface, among other calls.  When an 
              interrupt 4B occurs and QEMM-386's interrupt handler 
              gets control, it puts the system into protected mode 
              in the process of detecting whether or not it should 
              act on the interrupt or pass it along.  

              When Windows 3 is running in enhanced mode, QEMM-386 
              cannot go into protected mode, as Windows 3 enhanced 
              mode is already in protected mode.  When a call to 
              the IBM SCSI interface occurs from inside Windows 3 
              enhanced mode, Windows passes the call along to QEMM-
              386's interrupt handler, which makes the attempt to 
              go into protected mode if High RAM exists.  Versions 
              5.10 though 6.01 of QEMM-386 do not properly handle 
              the failure to go into protected mode, and the 
              resulting confusion causes the IBM SCSI call to 
              fail.  The most likely symptom is an error message 
              from the software making the IBM SCSI call.
              
              (This problem does not occur with other protected 
              mode software running under QEMM-386, including 
              Windows 3 standard mode.  The Virtual Control 
              Program Interface (VCPI) normally allows QEMM-386 
              and other protected mode programs each to operate in 
              protected mode.  Windows 3 enhanced mode is the only 
              protected mode program whose presence forces QEMM-
              386 to remain in real mode.) 
              
              Users of versions of QEMM-386 after version 6.01 
              should not experience this problem.  In the 
              meantime, QEMM-386 can be patched to eliminate the 
              problem.  The only side effect of using this patch 
              is that QEMM-386 can then not be used reliably with 
              the NOWINDOWS3 (NW3) parameter, which removes QEMM-
              386's support for Windows 3.

              The following procedure is intended to prevent error 
              messages when programs running inside Windows 3 
              enhanced mode make calls to the IBM SCSI interface 
              when QEMM-386 is running. This procedure is for use 
              with QEMM-386 versions:

                      5.10 
                      5.11 
                      5.12
                      5.13
                      6.00
                      6.01

              ***************************************************
              
                Do NOT use this patch for QEMM-386 5.0 or 
              earlier, or on any version of QEMM-386 later than 
              6.01.  If you are in doubt, go to the directory 
              where the QEMM-386 files are located and check the 
              date on the QEMM386.SYS file by issuing the DOS 
              command:

                        DIR QEMM386.SYS

              If the date on the file is

                        5:10 am 
                        5:11 am 
                        5:12 am
                        5:13 am  
                        6.00 am
                        6.01 am

              then use the patch in this section. If there is no 
              QEMM386.SYS file in this directory, or if the date 
              on the file is later than 6:01 am, then you 
              probably have an earlier or later version of QEMM-
              386, and this patch is not appropriate.  

              *************************************************** 

                1) Make a copy of the QEMM386.SYS file in your 
              QEMM directory.  We are about to alter your current 
              copy of QEMM386.SYS; the copy you make will serve 
              as a backup in case this operation fails.

                    COPY C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                2) Go to the DOS directory on the hard disk and 
              type:

                  DEBUG C:\QEMM\QEMM386.SYS

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                Hit the Enter key; you should see the DEBUG 
              prompt, which is a hyphen.

                3) At the DEBUG prompt, type:

                  S 100 L FF00 0 74 3 B8        

                Hit the Enter key; DEBUG should return a segment 
              address and an offset:

                  xxxx:yyyy

                4) At the DEBUG prompt again, use the segment 
              address and offset that was just returned to give 
              the DEBUG command:

                  E xxxx:yyyy 0 EB
   
                The address that DEBUG returned in step 3 should 
              be used in place of the address xxxx:yyyy, which we 
              use as an example.  Hit the Enter key; the DEBUG 
              prompt should return in a moment.


                5) At the DEBUG prompt, type

                  W

                Hit the Enter key; DEBUG will announce that it is 
              writing a certain number of bytes, then it will 
              return the DEBUG prompt.

                6) At the DEBUG prompt, type

                  Q

                Hit the Enter key to exit DEBUG and return to 
              DOS.  

                7) To double-check your patch, type the following 
              from the DOS prompt in your DOS directory:

                  COMP C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

               (If your QEMM386.SYS is not located in the QEMM
              directory of the C: drive, change the path
              accordingly.)

                Hit the Enter key.  COMP should return:


                            C:QEMM386.SYS and C:QEMM386.OLD

                            Compare error at OFFSET xxxx
                            File 1 = EB

                            File 2 = 74

                            Eof mark not found

                            Compare more files (Y/N)?

                The value xxxx after OFFSET will vary from 
              version to version of QEMM 5.1 or 6.0, but the rest 
              of the message should be the same: it tells us that 
              there is exactly one byte difference between the 
              files, and the differing byte is EB in QEMM386.SYS 
              and 74 in QEMM386.OLD.  If COMP returns the message:

                            Files compare ok  

              ...then you probably failed to use DEBUG's W 
              command to save your change, or you have compared 
              the wrong files.  If COMP returns more than one 
              compare error, or if the bytes returned by the 
              compare error don't match those in the above 
              example, the procedure has failed.  In this case, 
              use the DOS command:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

              ... to restore the original file, and try again.


              If the patch was successful, you should now reboot 
              the system and test the patched version of QEMM-
              386.  
              

              --------------------------------------------------

                If the system fails after you perform this patch, 
              you can follow the instructions in the 
              "Installation" section of your QEMM-386 manual to 
              recover without resorting to a boot floppy.  After 
              your system is booted successfully, copy the backup 
              of QEMM-386 that you made back to its original 
              name with the following DOS command:

                  COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

                (If your QEMM386.SYS is not located in the QEMM 
              directory of the C: drive, change the path 
              accordingly.)

                You may then wish to try the above procedure 
              again, in case a mistake was made.

             * * *   E N D   O F   F I L E    * * *
