ID:DM Patching DESQview for use with machines with built in mice ports that
      cause a long delay in starting DESQview
Quarterdeck Technical Note #201
by Skip Lahti

April 19, 1991

Background
==========

DESQview makes a certain BIOS call to check for the presence of a port
mouse. Some machines that have built in mouse ports may take several
seconds to over one minute to respond.  The Acer 1100sx and the AST
Premium Exec 386-20sx are two machines that exhibit this problem. The
following patch will cause DESQview not to make this call and, thus, 
eliminate the delay.  Keep in mind that if you plan on attaching a mouse 
to this port in the future, the patched DESQview will not detect its 
presence, so you will have to restore the original unpatched version of 
DESQview to get the mouse to work properly.

The Patch
=========

Here are the steps to take to patch DV.EXE.  Make sure that the
directory containing DEBUG (usually the DOS directory) is in your DOS
path.

1) Go to the DESQview directory, typically C:\DV.  Make a copy of your
DV.EXE file:

C:\DV> COPY DV.EXE OLDDV.EXE

2) Rename your DV.EXE file so that DEBUG will load it into memory as is
(.EXE files are reordered when they are loaded):

C:\DV> REN DV.EXE X

3) Load the newly-renamed file into DEBUG:

C:\DV> DEBUG X

4) Do a register dump by typing the letter "r" and pressing the Enter 
key at DEBUG's hyphen prompt:

-r

5) DEBUG will return a rather cryptic (if you're not a programmer) list
of letters and numbers.

AX=0000  BX=0002  CX=0976  DX=0000  SP=FFEE  BP=0000  SI=0000  DI=0000
DS=2947  ES=2947  SS=2947  CS=2947  IP=0100   NV UP EI PL NZ NA PO NC
2947:0100 4D            DEC     BP

In this example, DEBUG returned 2947 in the DS register at the beginning
of the second line; the value that you see will almost certainly be
different, and the value that you see is the value that you should use.
From here on, to avoid confusion, we will refer to your value as xxxx.

6) Add 1000h to this value (DS+1000h).  Our example would result in 
3947.  We will refer to this result as yyyy.

7) We will now search for the part of DESQview that needs to be changed.  
At DEBUG's hyphen prompt, type the following line (substitute the value 
you calculated by adding 1000h to DS in step 6 above for yyyy).

-S yyyy:0 LFFFF B7 0 F9 CD 15

DEBUG will return a value, beginning with your value for yyyy, in the
following format.

yyyy:zzzz

8) We will now replace the appropriate bytes.  Use the value that DEBUG
returned in Step 7 for yyyy:zzzz as you type in the following line:

-E yyyy:zzzz B7 0 F9 90 90

9) Use DEBUG's Write command to write the file to disk.  At DEBUG's
hyphen prompt,

-w
Writing 20976 bytes

This number may vary depending on the version of DESQview that you are
using.

10)  Quit DEBUG by typing Q at DEBUG's hyphen prompt:

-Q

11) Rename the file that you have just patched to DV.EXE:

C:\DV> ren x dv.exe

This procedure will work for all versions of DESQview numbered 2.26 or 
later.  Remember that this procedure patches DESQview to no longer 
support the use of port mice.  If you later attach a port mouse to your 
computer, you must copy the original unpatched DESQview, saved under the 
name OLDDV.EXE in step 1 above, back to DV.EXE.

If you have any difficulties, please contact Quarterdeck Technical
Support via our FAX service at (213) 399-3802, or by voice at (213) 392-9701.

