Quarterdeck Technical Note
by Michael Bolton
Patching DESQview for Use with AST Machines with Port Mice
4 April 1991

Background
==========

AST's implementation of its port mouse is presently incompatible with
current released versions of DESQview.  The following patch will allow
DESQview to work with these machines, but will render the patched copy
of DESQview incompatible with other machines.  Versions of
DESQview from 2.33 and beyond already address this problem
and therefore don't need the patch.

The Patch
=========

Here are the steps to take to patch DV.EXE.  Make sure that the
directory containing DEBUG (usually the DOS directory) is in your DOS
path.

1) Go to the DESQview directory, typically C:\DV.  Make a copy of your
DV.EXE file:

C:\DV> COPY DV.EXE OLDDV.EXE

2) Rename your DV.EXE file so that DEBUG will load it into memory as is
(.EXE files are reordered when they are loaded):

C:\DV> REN DV.EXE X

3) Load the newly-renamed file into DEBUG:

C:\DV> DEBUG X

4) Do a register dump by typing the letter "r" at DEBUG's hyphen prompt:

-r

5) DEBUG will return a rather cryptic (if you're not a programmer) list
of letters and numbers.

AX=0000  BX=0002  CX=0976  DX=0000  SP=FFEE  BP=0000  SI=0000  DI=0000
DS=2947  ES=2947  SS=2947  CS=2947  IP=0100   NV UP EI PL NZ NA PO NC
2947:0100 4D            DEC     BP

In this example, DEBUG returned 2947 in the DS register at the beginning
of the second line; the value that you see will almost certainly be
different, and the value that you see is the value that you should use.
From here on, to avoid confusion, we will refer to your value as xxxx.

6) We will now search for the first part of DESQview that needs to be
changed.  At DEBUG's hyphen prompt, type the following line (substitute
the value you found in the DS register in step 5 above for xxxx).

-S xxxx:0 L FFFF 8E 1E E 4 88 1E 26 0

DEBUG will return a value, beginning with your value for xxxx, in the
following format.

xxxx:yyyy

7) We will now replace the appropriate bytes.  Use the value that DEBUG
returned in Step 6 for xxxx:yyyy as you type in the following line:

-E xxxx:yyyy 90 90 90 90 88 1E B4 4

8) We will now search for the second part of DESQview that needs to be
changed.  Take the first digit in your xxxx value, and add one to it.
We will call this new value nxxx.  In the example above, nxxx would be 3947.
At DEBUG's hyphen prompt, type the following line (substitute our new number
for nxxx).

-S nxxx:0 L FFFF B4 C1 CD 15

DEBUG will return a new value in this format:

nxxx:yyyy

Note that the value for yyyy returned in this step will be different
from the value returned in step 6.

9) We will now replace the appropriate bytes.  Use the value that DEBUG
returned in Step 8 for nxxx:yyyy as you type in the following line:

-E nxxx:yyyy 31 C0 8E C0

10) We will now search for the third part of DESQview that needs to be
changed.  At DEBUG's hyphen prompt, type the following line (substitute
our new number from step 8 for nxxx).

-S nxxx:0 L FFFF 26 C4 6 22 0

DEBUG will return a new value in the following format.  

nxxx:yyyy

Note that the value for yyyy will be different from any of the previous
steps.

11) We will now replace the appropriate bytes.  Use the value that DEBUG
returned in Step 10 for nxxx:yyyy as you type in the following line at
DEBUG's hyphen prompt:

-E nxxx:yyyy 26 C4 6 B5 4

12) Use DEBUG's Write command to write the file to disk.  At DEBUG's
hyphen prompt,

-w
Writing 20976 bytes

This number may vary depending on the version of DESQview that you are
using.

13)  Quit DEBUG by typing Q at DEBUG's hyphen prompt:

-Q

14) Rename the file that you have just patched to DV.EXE:

C:\DV> ren x dv.exe

These searches will work for all versions of DESQview numbered 2.26 or
later.  Note that this will patch DESQview to fully support the use of port
mice on the new AST 386 and 486 machines, but will also make it so that it 
WILL NO LONGER WORK on regular port mouse machines.

If you have any difficulties, please contact Quarterdeck Technical
Support via our FAX service at 399-3802, or by voice at 392-9701.
