






          Quarterdeck Technical Note

          Subject:  Patching QEMM-386 5.10, 5.11, 5.12 and 5.13 
          to withhold available Upper Memory Blocks from programs 
          running inside Microsoft Windows 3.0 enhanced mode.

          Background: QEMM versions 5.10 through 5.13 take 
          advantage of Microsoft Windows 3.0's VXD interface to 
          provide a copy of all available Upper Memory Blocks 
          (identified by the QEMM.COM and Manifest utilities as 
          High RAM) to each window running inside Windows 
          enhanced mode.  This seemed like a good idea at the 
          time: each window in Windows enhanced can load its own 
          set of programs into upper memory, either through the 
          XMS (Extended Memory Specification) or with QEMM-386's 
          LOADHI.COM program, when QEMM-386 is providing this 
          feature.  However, few programs avail themselves of 
          this opportunity.  Furthermore, the additional overhead 
          of providing a copy of all available UMB's for each 
          window places a memory strain on low-memory systems; 
          and, because Windows enhanced mode takes this overhead 
          out of conventional memory, the size of each window in 
          Windows enhanced mode shrinks, a high price for large 
          DOS applications to pay.  Finally, Quarterdeck observes 
          that Windows enhanced mode may begin to malfunction if 
          QEMM-386 provides it with enough data to manage on a 
          window-by-window basis. 

          Versions of QEMM-386 after version 5.13 will not 
          provide a copy of available UMB's to each window in 
          Windows enhanced mode.  In the meantime, QEMM-386 can 
          be patched to eliminate this feature.


          This procedure is for use with the following QEMM-386 
          versions: 

                  5.10                       
                  5.11                       
                  5.12                       
                  5.13                       
                 
          ***************************************************


               1) Make a copy of the QEMM386.SYS file in your 
          QEMM directory.  We are about to alter your current 
          copy of QEMM386.SYS; the copy you make will serve as a 
          backup in case this operation fails.

                 COPY C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

          (If your QEMM386.SYS is not located in the QEMM 
          directory of the C: drive, change the path 
          accordingly.)

               2) Go to the DOS directory on the hard disk and 
          type:

                 DEBUG C:\QEMM\QEMM386.SYS

          (If your QEMM386.SYS is not located in the QEMM 
          directory of the C: drive, change the path 
          accordingly.)

          Hit the Enter key; you should see the DEBUG prompt, 
          which is a hyphen.

              3) At the DEBUG prompt, type:

                     S 8000 L 2000 55 8B E9 BE

          Hit the Enter key; DEBUG should return a segment 
          address and an offset:

                      xxxx:yyyy

          4) At the DEBUG prompt again, use the segment address 
          and offset that was just returned to give the DEBUG 
          command:

                      E xxxx:yyyy EB 8

          The address that DEBUG returned in step 3 should be 
          used in place of the address xxxx:yyyy, which we use as 
          an example.  Hit the Enter key; the DEBUG prompt should 
          return in a moment.


          5) At the DEBUG prompt, type

                       W

          Hit the Enter key; DEBUG will announce that it is 
          writing a certain number of bytes, then it will return 
          the DEBUG prompt.


          6) At the DEBUG prompt, type

                       Q

          Hit the Enter key to exit DEBUG and return to DOS.

            7) To double-check your patch, type the following 
          from the DOS prompt in your DOS directory:

                     COMP C:\QEMM\QEMM386.SYS C:\QEMM\QEMM386.OLD

          (If your QEMM386.SYS is not located in the QEMM 
          directory of the C: drive, change the path 
          accordingly.)

          Hit the Enter key.  COMP should return:


          C:QEMM386.SYS and C:QEMM386.OLD

          Compare error at OFFSET x
          File 1 = EB

          File 2 = 55

          Compare error at OFFSET x
          File 1 = 08

          File 2 = 8B

          Eof mark not found

          Compare more files (Y/N) ?


          The value x after OFFSET will vary from version to 
          version of QEMM 5.1, but the rest of the message should 
          be the same: it tells us that there are exactly two 
          bytes difference between the files, and the differing 
          bytes are EB and 55 in QEMM386.SYS and 08 and 8B in 
          QEMM386.OLD.  If COMP returns the message:

          Files compare ok  

          ...then you probably failed to use DEBUG's W command to 
          save your change, or you have compared the wrong files.  
          If COMP returns more than two compare errors, or if the 
          bytes returned by the compare errors don't match those 
          in the above example, the procedure has failed. In this 
          case, use the DOS command:

              COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

          ... to restore the original file, and try again.


          If the patch was successful, you should now reboot the 
          system and test the patched version of QEMM-386.


          --------------------------------------------------

          If the system fails after you perform this patch, you 
          can follow the instructions in the "Installation" 
          section of your QEMM-386 manual to recover without 
          resorting to a boot floppy.  After your system is 
          booted successfully, copy the backup of QEMM-386 that 
          you made back to its original name with the following 
          DOS command:

               COPY C:\QEMM\QEMM386.OLD C:\QEMM\QEMM386.SYS

          (If your QEMM386.SYS is not located in the QEMM 
          directory of the C: drive, change the path 
          accordingly.)

          You may then wish to try the above procedure again, in 
          case a mistake was made.

                     * * *   E N D   O F   F I L E    * * *
