{ TARCHIV.EXE }

{ Andreas Schiffler, U of S, 1994 }

{ This is the main tape-archiver program, which handles the command-line }
{ parameters and calls the TapeArchiver object. }

{ Version history: }
{ ---------------- }
{ *** 1 May 1994                                                         }
{ 1.0B - original release of a beta-test version. Soon to be replaced by }
{        definite version 1.0 after all the bugs have been found.        }
{ *** 2 June 1994                                                        }
{ 1.1B - added erase flag, longer timeout in ASPI, InfoLog flag          }
{        Longflag for display, Fixed bug in Wildcard. Still testing.     }
{ *** 10 Dec 1994							 }
{ 1.2B - works fine up to now						 }

Program TArchiv;

Uses Dos, Arc, TapeArc, Toolbox;

{ ====================== M A I N ============================ }

Const
  Version = '1.2B';

Var
  { Archiver object }
  A       : PTapeArchiver;

  { Options }
  ErrLogfn,
  InfoLogfn : String;
  Wordy     : Boolean;
  Timeout   : Byte;
  TapeType  : String;
  DoTime    : Boolean;
  DoReset   : Boolean;
  DoErase   : Boolean;
  LongFlag  : Boolean;
  DoMem     : Boolean;

  { Local variables }
  LineStr : String[80];
  Count   : Byte;
  EPos    : Byte;
  Identifier,
  Value   : String;
  Result  : Integer;
  PCode   : String[1];

Begin
 { Title }
 LineStr[0]:=#80;
 FillChar(LineStr[1],80,196);
 Writeln (' TRCHI ',Version,' - tape archiver program - A. Schiffler, U of S, 1994');
 Write (LineStr);
 { Helptext }
 If ParamCount<3 Then Begin
  Writeln ('Usage    : tarchiv a|x|l <LUN:save-set> <wildcard>|@<filelist> [<options>]');
  Writeln ('           a  - to add files');
  Writeln ('           x  - to extract files');
  Writeln ('           l  - to list the directory');
  Writeln ('LUN      : Local Unit Number of SCSI device = 0,1, ... ,7');
  Writeln ('Saveset  : Saveset number to work with = 1,2, ...');
  Writeln ('Wildcard : DOS wildcard, e.g. *.DAT, 1994????.DAT, ...');
  Writeln ('Filelist : Filename of textfile containing filenames, one name per line');
  Writeln ('Options  : syntax is IDENTIFIER=VALUE, use is optional');
  Writeln ('           ERRLOG=<filename>  error-log textfile, default: screen');
  Writeln ('           INFOLOG=<filename> info/files-log textfile, default: screen');
  Writeln ('           WORDY=FALSE        suppresses informational text, default: TRUE');
  Writeln ('           TIMEDISP=FALSE     suppresses time in error-log, default: TRUE');
  Writeln ('           TIMEOUT=<number>   tape-timeout period in minutes, default: 15 min');
  Writeln ('           TAPE=<tapetype>    type of tape for size, default: P6-120');
  Writeln ('           RESET=TRUE         issue ASPI-reset at beginning, default: FALSE');
  Writeln ('           ERASE=TRUE         erase tape from <saveset> to <end>, default: FALSE');
  Writeln ('           LONG=FALSE         suppresses additional fileinfo, default: TRUE');
  Writeln ('           SHOWMEM=TRUE       shows free memory for directory list, default: FALSE');
  Writeln ('Tapetype : P5-15, P5-15, P5-30, P5-60, P5-90, P6-15, P6-35, P6-60, P6-90, P6-120');
  Exit;
 End;
 { Set options to default values }
 ErrLogfn := '';
 InfoLogfn := '';
 Wordy := True;
 Timeout := 15;
 TapeType := 'P6-120';
 DoTime := True;
 DoReset := False;
 DoErase := False;
 LongFlag := True;
 DoMem := False;
 { Determine user selected options }
 If ParamCount>3 Then Begin
  For Count := 4 To ParamCount Do Begin
   EPos := Pos('=',ParamStr(Count));
   If EPos>1 Then Begin
    Identifier := Upper(Copy (ParamStr(Count),1,EPos-1));
    Value := Upper(Copy (ParamStr(Count),EPos+1,Length(ParamStr(Count))-Length(Identifier)-1));
    If (Identifier='ERRLOG') Then ErrLogfn := Value;
    If (Identifier='INFOLOG') Then InfoLogfn := Value;
    If (Identifier='WORDY') And (Value='FALSE') Then Wordy := False;
    IF (Identifier='TIMEOUT') Then Val(Value,Timeout,Result);
    IF (Identifier='TAPE') Then TapeType := Value;
    IF (Identifier='TIMEDISP') AND (Value='FALSE') Then DoTime := False;
    IF (Identifier='RESET') AND (Value='TRUE') Then DoReset := True;
    IF (Identifier='ERASE') AND (Value='TRUE') Then DoErase := True;
    IF (Identifier='LONG') AND (Value='FALSE') Then LongFlag := False;
    IF (Identifier='SHOWMEM') AND (Value='TRUE') Then DoMem := True;
   End;
  End;
 End;
 { Test user options }
 If Timeout<1 Then Timeout := 1;
 { Open archiver object }
 PCode := Upper(ParamStr(1))+' ';
 Case PCode[1] Of
  'A':  New (A,Init(ParamStr(2),fWrite,InfoLogfn,ErrLogfn,DoReset,DoErase,DoMem));
  'X','L':  New (A,Init(ParamStr(2),fRead,InfoLogfn,ErrLogfn,DoReset,DoErase,DoMem));
  Else
   Exit;
 End;
 { Set options }
 A^.Timeout := Timeout;
 A^.Wordy := Wordy;
 A^.DoTime := DoTime;
 A^.SetTapeSize (TapeType);
 A^.LongItemFlag := LongFlag;
 { Action }
 Case PCode[1] Of
  'A': A^.AddFiles(ParamStr(3));
  'X': A^.ExtractFiles(ParamStr(3));
  'L': Begin
        A^.DisplayFlag := True;
        A^.ExtractFiles(ParamStr(3));
       End;
 End;
 { Close Archiver object }
 Dispose (A,Done);
End.

