{   High-Level Music Control Source File       }
{   PHRO!                                      }
{   Phred/OTM                                  }
{   achalfin@uceng.uc.edu                      }
{   DO NOT DISTRIBUTE THIS SOURCE FILE         }
Unit Music;

{ $DEFINE NoTune}
{ $DEFINE TEST}


Interface

Var
  SoundEnabled : Boolean;

Procedure InitializeMusic;
Procedure BeginMusic;
Procedure CloseMusic;

Implementation

Uses Crt, MSE_TP;

Procedure BeginMusic;

Begin
  If SoundEnabled
    Then StartMusic;
End;

Function SelectSoundCard : Integer;

Begin
  Writeln('Select Sound Card');
  Writeln;
  Writeln('  1. Gravis UltraSound');
  Writeln('  2. Sound Blaster Pro');
  Writeln('  3. Sound Blaster');
  Writeln('  4. No Sound');
  SelectSoundCard := (Ord(ReadKey) - Ord('0'));
End;

Function SelectIOAddr: Integer;

Begin
  Writeln;
  Writeln('Select IO Address');
  Writeln;
  Writeln('  1. 210h ');
  Writeln('  2. 220h ');
  Writeln('  3. 230h ');
  Writeln('  4. 240h ');
  Writeln('  5. 250h ');
  Writeln('  6. 260h ');
  SelectIOAddr := $200+((Ord(ReadKey)-Ord('0'))*$10);
End;

Function SelectIRQ : Integer;

Begin
  Writeln;
  Writeln('Select IRQ');
  Writeln;
  Writeln('  1. Irq 2');
  Writeln('  2. Irq 3');
  Writeln('  3. Irq 5');
  Writeln('  4. Irq 7');
  Writeln('  5. Irq 11');
  Writeln('  6. Irq 12');
  Case ReadKey of
    '1' : SelectIRQ := 2;
    '2' : SelectIRQ := 3;
    '3' : SelectIRQ := 5;
    '4' : SelectIRQ := 7;
    '5' : SelectIRQ := 11;
    '6' : SelectIRQ := 12;
  End;
End;

Function SelectDMA : Integer;

Begin
  Writeln;
  Writeln('Select DMA');
  Writeln;
  Writeln('  1. Dma 1');
  Writeln('  2. Dma 3');
  Writeln('  3. Dma 5');
  Case ReadKey of
    '1' : SelectDMA := 1;
    '2' : SelectDMA := 3;
    '3' : SelectDMA := 5;
  End;
End;


Procedure InitializeMusic;

Var
  ErrInit : Word;
  SoundCardName : String;
  IOAddr : Word;
  DMA : Byte;
  IRQ : Byte;
  Diskfile : File;
  EMSFlag : Word;
  GDMH : GdmHeader;
  MUSICChannels, ChannelCount, SampleRate : Word;

Begin
  SoundEnabled := False;
{$IFDEF NOTUNE}
  Exit;
{$ENDIF}
  
{$IFNDef Test}
  Case SelectSoundCard of
    1 : SoundCardName := 'GUS.MSE';
    2 : SoundCardName := 'SBPRO.MSE';
    3 : SoundCardName := 'SB1X.MSE';
    4 : Exit;
  End;
  If Not(EMSExist) and (SoundCardName <> 'GUS.MSE')
    Then Begin
      Writeln('Sorry, this demo requires about 400K EMS memory to play the music. Please configure ');
      Writeln('EMS memory and try again.');
      Halt(0);
    End;

  IOAddr := SelectIOAddr;
  IRQ := SelectIRQ;
  DMA := SelectDMA;
{$ELSE}
  SoundCardName := 'GUS.MSE';
  IOAddr := $210;
  DMA := 5;
  IRQ := 12;
{$ENDIF}
  ErrInit := LoadMSE(SoundCardName, 0, 44, 8128, IOAddr, IRQ, DMA);
  If ErrInit <> 0
    Then Begin
      Writeln('Error initializing music routines. Sound is not enabled.');
      Delay(1000);
      Exit;
    End;
  Assign(Diskfile, '4Morn.Gdm');
  {$I-}
  Reset(Diskfile, 1);
  {$I+}
  If IOResult <> 0
    Then Begin
      Writeln('Error loading module, Sound is not enabled.');
      Delay(1000);
      FreeMSE;
      Exit;
    End;
  EMSFlag := 1;  { Use EMS memory }
  ErrInit := LoadGDM(Diskfile, 0, EMSFlag, GDMH);
  If ErrInit <> 0
    Then Begin
      Writeln('Error reading module, Sound is not enabled.');
      Delay(1000);
      FreeMSE;
      Exit;
    End;
  MusicChannels := 0;            { Calculate the number of channels in song }
  For ChannelCount := 1 to 32 do
    Begin
      If GDMH.PanMap[ChannelCount] <> $FF
        Then MusicChannels := MusicChannels + 1;
    End;
  SampleRate := StartOutput(MusicChannels, 0);
  SoundEnabled := True;
End;

Procedure CloseMusic;

Var
  Temp : Byte;
  Count : Byte;

Begin
  If SoundEnabled
    Then Begin
      For Count := 63 downto 0 do
        Begin
          Temp := MusicVolume(Count);
          Delay(50);
        End;
      StopMusic;
      StopOutput;
      UnloadModule;
      FreeMSE;
    End;
End;

End.