{   Text Mode Routines Source File             }
{   PHRO!                                      }
{   Phred/OTM                                  }
{   achalfin@uceng.uc.edu                      }
{   DO NOT DISTRIBUTE THIS SOURCE FILE         }
Unit TEXT;

Interface

Procedure TextFade;
Procedure ReFadeText;

Implementation

Uses Crt;

Type
  RGBType = Record
    r, g, b : Byte;
  End;
  TextPalette = Array[0..255] of RGBType;

Var
  OrigPalette : TextPalette;
  FadePalette : TextPalette;
  DummyPalette : TextPalette;

Procedure FadeOut(Pal1, Pal2 : TextPalette; DelayVal : Word);

Var
  Count, Count2 : Integer;

Begin
  For Count := 63 downto 0 do
    Begin
      For Count2 := 0 to 255 do
        Begin
          If Pal1[Count2].r < Pal2[Count2].r
            Then Inc(Pal1[Count2].r);
          If Pal1[Count2].r > Pal2[Count2].r
            Then Dec(Pal1[Count2].r);
          If Pal1[Count2].g < Pal2[Count2].g
            Then Inc(Pal1[Count2].g);
          If Pal1[Count2].g > Pal2[Count2].g
            Then Dec(Pal1[Count2].g);
          If Pal1[Count2].b < Pal2[Count2].b
            Then Inc(Pal1[Count2].b);
          If Pal1[Count2].b > Pal2[Count2].b
            Then Dec(Pal1[Count2].b);
        End;
      For Count2 := 0 to 255 do
        Begin
          Port[$3c8] := Count2;
          Port[$3c9] := Pal1[Count2].r;
          Port[$3c9] := Pal1[Count2].g;
          Port[$3c9] := Pal1[Count2].b;
        End;
      Delay(DelayVal);
    End;
End;

Procedure TextFade;

Var
  Count : Integer;

Begin
  For Count := 0 to 255 do
    Begin
      Port[$3c7] := Count;
      OrigPalette[Count].r := Port[$3c9];
      OrigPalette[Count].g := Port[$3c9];
      OrigPalette[Count].b := Port[$3c9];
    End;
  Move(OrigPalette, FadePalette, Sizeof(FadePalette));
  FillChar(DummyPalette, Sizeof(DummyPalette), 0);
  FadeOut(FadePalette, DummyPalette, 50);
End;

Procedure ReFadeText;

Var
  Count : Integer;

Begin
  Asm
    Mov  ax,3
    Int  10h
  End;
  FillChar(DummyPalette, Sizeof(DummyPalette), 0);
  For Count := 0 to 255 do
    Begin
      Port[$3c8] := Count;
      Port[$3c9] := DummyPalette[Count].r;
      Port[$3c9] := DummyPalette[Count].g;
      Port[$3c9] := DummyPalette[Count].b;
    End;
  Writeln;
  Writeln;
  Writeln('You have just seen PHRO.');
  Writeln('  Code            : Phred');
  Writeln('  Music Rountines : Zilym');
  Writeln('  Music           : Stalker ');
  Writeln;
  Writeln;
  FadeOut(DummyPalette, OrigPalette, 50);
End;

End.