#include <stdio.h>
// This is a simple program to demonstrate one way to scroll a page
// up or down using mode X.

// Modified to create a outrun type road scroller??

// To compile it use large model and link with xlib06l.lib, one idea
// to make things speed up is to modify the page flip routine source
// and remove all loops (I believe there are two). This can make the
// difference between 30fps and 60fps!!

// Enjoy.

#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <alloc.h>
#include <dos.h>
#include <bios.h>
#include <time.h>
#include "xlib_all.h"

#define FARPTR(x) (MK_FP(FP_SEG(x),FP_OFF(x)))

void load_pallete(void);
void load_mapsprites(void);
void put_map(int);

char far * Sprite[1];     // Sprite table
int        counter;       // Global counter
char       buff[5000];    // Temporary buffer for loading sprites

char far *        // from xlib6
AllocatedSprite(int width, int height, int logical_width, char far * bitmap)
{
    char far * result;
    int size;
    result = farmalloc((width * height * 7) / 2 + 25);
    if (result == 0) {printf("\n out of memory \n");exit(0);}
    size = x_compile_bitmap_32(logical_width, bitmap, result);
    return farrealloc(result, size);
}

void load_pallete()     // load pallete from raw file
{
   FILE *k;
   int i;
   unsigned char r,g,b;
   k = fopen("mac.pal","rb");
   for (i=0; i<256; i++){
      r = fgetc(k);
      g = fgetc(k);
      b = fgetc(k);
      x_set_rgb(i,r,g,b);
   }
   x_set_rgb(0,0,0,0);
   fclose(k);
}

void load_mapsprites()
{
 FILE *k;
 int i,l;
 unsigned char c;
 k=fopen("tile.vsp","rb");
 for (l=0; l<=1; l++){      // loop for the number of sprites to load
    for (i=0; i<4; i++)
       fgetc(k);            // strip size header
    for (i=2;i<18;i++)      // make first line all 0's -- why? I dont know it just works better, expirimentation is great!!
       buff[i] = 0;
    for (i=18;i<274;i++)    // actually read spite data
       buff[i] = fgetc(k);
    buff[0] = 16;           // set up sizes for compilation
    buff[1] = 17;
    Sprite[l] = AllocatedSprite(buff[0], buff[1], 80,FARPTR(buff)); // compile it
 }
 fclose(k);
}

void put_map(int i)
{
   register int k,j,r;
   r = (16 - (i % 16))+16;  // compute offset of tiles to screen
   for (j=0;j<21;j++)
      for (k=0;k<16;k++)
	 x_put_cbitmap((j << 4),(k<<4)+r,HiddenPageOffs,Sprite[0]);
}

void put_road(int i)
{
   int k,j,c;
   k = 130;  // starting point
   c = 0;
   do {
      for (j=0;j<20;j++) { // modify this to use your own mapping ie. road layout or what ever
	 if ((i-c+j) % 20 == 0) x_put_cbitmap((j << 4),k,HiddenPageOffs,Sprite[1]);
	 else x_put_cbitmap((j << 4),k,HiddenPageOffs,Sprite[0]);
      }
      k += c; // modify this for elevation
      c++; // use mod function to modify tiling ie. if (i % 2 == 1) c++;
   } while (k < 280);
}

main()
{
   struct time begin,end;
   int i=0;
   load_mapsprites();                 // load sprite(s)
   free(buff);                        // free sprite buffer
   x_set_mode(1,320);                 // set X mode
   load_pallete();                    // load pallete
   x_set_tripplebuffer(798);          // set up triple buffer
   gettime(&begin);                   // get start time
   do {                               // loop
      put_road(i++);                     // draw a page
      x_page_flip(0,32);                 // look at page just drawn
      counter++;                         // inc global counter
   } while (!kbhit());                // until anykey hit
   gettime(&end);                     // get end time
   x_text_mode();                     // exit X mode
   printf("number of frames = %d\n",counter);   // figure it all out
   printf("begin time       = %d - %d - %d\n",begin.ti_min,begin.ti_sec,begin.ti_hund);
   printf("end time         = %d - %d - %d\n",end.ti_min,end.ti_sec,end.ti_hund);
   printf("frame rate       = %d\n",
      counter/(((end.ti_hour*360)+(end.ti_min*60)+(end.ti_sec)+(end.ti_hund/100))-
      ((begin.ti_hour*360)+(begin.ti_min*60)+(begin.ti_sec)+(begin.ti_hund/100))));
   return(0);
}