/* LCALLCMD.C --  Example source code on how to access renegade dat files
 * and how to use them with ANSI templates.  Command line version.
 * This is public domain, do whatever the hell you want to with it.  A 
 * greet or two would be appreciated though... :)
 * Coded by Darion and Paradigm
 * thimj@u.washington.edu                                               */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

typedef unsigned char boolean;                  /* a few typedef's that */
typedef unsigned char byte;                     /* really useful        */
typedef unsigned int  word;

void help(word);                                /* prototyping is       */
void read_data(void);                           /* wonderful            */
void check_mci(boolean *fErrors);

struct lcallers {
		long callernum;                 /* system caller number */
		byte name_length;               /* length of name field */
		byte name[36];                  /* user name of caller  */
		word number;                    /* user number          */
		byte city_length;               /* length of city field */
		byte citystate[30];             /* city/state of caller */
		byte baud_length;               /* length of baud field */
		byte baud[5];                   /* baud of caller       */
		byte time_length;               /* length of time field */
		byte timeon[8];                 /* time logged in       */
		word daynum;                    /* day of week logged in*/
		boolean wasnew;                 /* was a newuser?       */
	};


struct lcallers lcalldat;                       /* allocated one structure */

/* below are some arrays where we will put the data from the laston.dat file
 * we do this because the strings are stored in PASCAL format with the first
 * byte being the length of the record.  We convert this to the null
 * terminated C string type, and then parse our ansi and pull the data from
 * these structures                                                     */

byte last_caller[20][36];
byte call_from[20][30];
byte time_on[20][8];
byte baud_rate[20][6];
long call_num[20];

/* define the file pointers that are going to be used in this program
 * flTemplate == the ANSI template which holds the MCI codes
 * flOutput == the output ANSI, the one with the data in it
 * flData == laston.dat, the renegade data file                         */

FILE *flTemplate;
FILE *flOutput;
FILE *flData;

void main(int argc, char *argv[])
{
	unsigned char ch;               /* char used for reading files */
	boolean *fErrors = 0;           /* used to check for bad codes */
	byte data_path[41];
	byte template_path[41],output_path[41];

	if(argc < 2) help(0);           /* if they think they have a interface
									 * yell at em */

	/* these three if then statements below check to make sure all three
	 * files either A) Exist B) are capable of being created.  They each
	 * print an individual error message, then pass a custom errorlevel
	 * to the help() function, which prints a message, and exists with
	 * the passed errorlevel                                        */


	/* get configuration data */

	if((flData = fopen("laston.dat","rb")) == NULL) {
		fprintf(stderr,"\nError: %s not found\n",argv[2]);
		help(3);
	}

	if((flTemplate = fopen(argv[1],"r")) == NULL)
		{
		fprintf(stderr,"\nError opening Template File: %s\n",argv[1]);
		help(1);
		}

	if((flOutput = fopen(argv[2],"w+")) == NULL)
		{
		fprintf(stderr,"\nError creating file: %s\n",argv[2]);
		help(2);
		}

	read_data();                    /* read in the data */

	ch = fgetc(flTemplate);

	/* below we are in the loop which actually checks the template file
	 * for the codes which represent fields.  If we spot a character with
	 * a tilde (~) then we call a function called check_mci(), if not, we
	 * simply copy the character straight into the second file      */

	while(!feof(flTemplate)) {
		if(ch == '~') check_mci(fErrors);

		else fputc(ch,flOutput);
		ch = fgetc(flTemplate);
	}

	/* if there were any unrecognized codes, tell them WITHOUT printing the
	 * help screen */

	if(*fErrors == 1) {
		fprintf(stderr,"\nUnrecognized Codes Skipped\n");
		exit(4);
	}

}

void check_mci(boolean *fErrors)
{
	byte ch;                /* for reading in the chars after the tilde */
	byte chMciNum[3];       /* for holding the number after the A,B,C
				 * specifier.                               */

	word wNum;              /* for holding the converted number         */

/* Okay, big long explanation of what we do.  This function was called
 * because the main loop spotted a tilde (~) which usually marks the beginning
 * of a code which we must parse.  We grab the character right after the tilde
 * and do a 'switch' on it.  After determining the character we get the next
 * two characters.  Usually these will range from [01-20].  We put these chars
 * into chMciNum and then terminate chMciNum with a null.  We then call atoi()
 * to convert the string into an integer.  We then use this integer to grab
 * the data correctly.  If the converted number was 08, then we know we have
 * to copy the eight element of a certain array into the output file.  The
 * data itself is actually put into the arrays at the beginning of the program
 * If it goes thru all the switches, we change fErrors to 1 and the main loop
 * allows the user to know an unrecongnized code was found                  */

	ch = fgetc(flTemplate);
	switch(ch){
		case 'B': {
			chMciNum[0] = fgetc(flTemplate);
			chMciNum[1] = fgetc(flTemplate);
			chMciNum[2] = '\0';
			wNum = atoi(chMciNum);
			fputs(baud_rate[wNum - 1], flOutput);
			}
		break;

		case 'H': {
			chMciNum[0] = fgetc(flTemplate);
			chMciNum[1] = fgetc(flTemplate);
			chMciNum[2] = '\0';
			wNum = atoi(chMciNum);
			fputs(last_caller[wNum - 1], flOutput);
			}
		break;

		case 'C': {
			chMciNum[0] = fgetc(flTemplate);
			chMciNum[1] = fgetc(flTemplate);
			chMciNum[2] = '\0';
			wNum = atoi(chMciNum);
			fputs(call_from[wNum - 1], flOutput);
			}
		break;

		case 'N': {
			chMciNum[0] = fgetc(flTemplate);
			chMciNum[1] = fgetc(flTemplate);
			chMciNum[2] = '\0';
			wNum = atoi(chMciNum);
			fprintf(flOutput,"%d",call_num[wNum - 1]);
			}
		break;

		case 'T': {
			chMciNum[0] = fgetc(flTemplate);
			chMciNum[1] = fgetc(flTemplate);
			chMciNum[2] = '\0';
			wNum = atoi(chMciNum);
			fputs(time_on[wNum - 1], flOutput);
			}
		break;

		default: {
			fputc('~',flOutput);
			fputc(ch,flOutput);
			*fErrors = 1;
			}
	}

}


void read_data(void)
{
/* this is the most important part of the program.  Also perhaps the easiest
 * to understand.  We keep doing fread's until A) we hit an EOF, B) we go pass
 * the maximum amount of storage we have.  We start at 9 and go down to 0
 * because in the templates, we want ~N01 to be the 10th latest caller, and
 * we want ~N10 to be the latest.  So we are filling up our arrays in reverse
 * order.  Remember that arrays are indexed from 0 up, so that accounts for us
 * going to 0.  So we have  a structure that we defined at the top of our
 * program.  Now we read in one structure at a time, and copy the data we want
 * into our arrays.  Since pascal uses the first byte of its strings as the
 * length of the strings, we modified the structure to read in the byte into
 * a seperate field than the string.  We then use strncpy to copy from the
 * structure into our arrays.  We specify the maximum length of the string
 * because we still dont know how long the string is.  We then have to set an
 * index in our arrays to 0 to terminate the string correctly.  Here is where
 * the byte we read in as the length comes in handy.  We simply index our
 * arrays with that number and set that character to the NULL.
 * If you have any questions about this dont hesistate to contact me. */

	word x = 0;

	while((fread(&lcalldat, sizeof(lcalldat), 1, flData)) != 0) {
		if(x == 20 ) break;

		call_num[x] = lcalldat.callernum;

		strncpy(baud_rate[x],lcalldat.baud, 5);
		baud_rate[x][lcalldat.baud_length] = '\0';

		strncpy(call_from[x], lcalldat.citystate, 30);
		call_from[x][lcalldat.city_length] = '\0';

		strncpy(last_caller[x], lcalldat.name, 36);
		last_caller[x][lcalldat.name_length] = '\0';

		strncpy(time_on[x], lcalldat.timeon, 8);
		time_on[x++][lcalldat.time_length] = '\0';
		}

}

void help(word errorlevel)
{
	fprintf(stderr,"\n");
	fprintf(stderr,"LASTCALL -- Inserts RG Last Caller into ANSI Templates\n");
	fprintf(stderr,"By Darion (thimj@u.washington.edu)\n");
	fprintf(stderr,"\n");
	fprintf(stderr,"Usage: lastcall <input template> <output ansi>\n");
	fprintf(stderr,"Example: lcallcmd lcalltmp.ans lcallers.ans\n");

	exit(errorlevel);
}






