(* Version 3.5 Developmental Kit
Ŀ
                             
                           
                                                                             
 Description: Sample Procedures/Functions to read IMPULSE.IDF and other misc-
              ellaneous things.                                              
       Notes: Modifications WILL be required.  Expect to change things.      
              This code is a bit choppy.  Feel free to modify and distribute 
              your changes.                                                  

*)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit ImpDev;

Interface

{$I IMPREC.PAS}

Var
  Local,                      { Is Program running in LOCAL mode? }
  OutCom:boolean;             { Is the comport open and sending? }
  Driver:integer;             { FOSSIL=0, INTERNAL:=1, LOCAL:=2 }

{IDF Variables}
  ComDriver:string[8];        { driver in use.  FOSSIL or INTERNAL }
  ComPort:byte;               { comport number (0=Local)}
  IrqNumb:byte;               { irq number 0-7 (255 for none) }
  InOutBuffer:word;           { modem in/out buffer size }
  BPSrate:longint;            { baud rate}
  Version:string[3];          { impulse version number }
  BBSName:astr;               { bbs name }
  SYSName:astr;               { sysop name }
  UserName:astr;              { User's handle }
  RealName:astr;              { user's real name }
  UserPW:astr;                { user's password }
  SecurityLVL:integer;        { user's sl level }
  DownloadLVL:integer;        { user's dsl level }
  FilePts:integer;            { user's file points }
  PromptNum:byte;             { user's selected prompt }
  EmulationTyp:string[4];     { ANSI, AVT, or RIP }
  Uploads:integer;            { user's # of uploads }
  Downloads:integer;          { user's # of downloads }
  Upl_K:integer;              { # of KB uploaded }
  Dnl_K:integer;              { # of KB downloaded }
  CurrTime:string[5];         { current time }
  TimeLeft:integer;           { # of minutes user has left online }


Procedure Initialize; {Initialized com ports and other vars}
Procedure IDF_Read(Fn:String); {FN = Path/Filename}
Function String2Num(s:string):longint; {Converts string expression to # value}
Function Num2String(i:longint):string; {Converts longint to string expression}
Procedure ColorCodes(s:string); {Parses PIPE (|01, |B7) codes}

Implementation

Uses Crt, Dos, ImpCom;

{This should be one of the first things called after IDF_read.}

Procedure Initialize;
var anyerrors:word;
begin
  outcom:=false;
  local:=false;
  if (comport=0) then
  begin
    outcom:=false;
    local:=true;
    writeln('Initializing Local Mode.');
  end else
  begin
    driver:=0;
    local:=false;
    if (comdriver='LOCAL') then local:=true;
    if (com_installed) then imp_deinstall;
    if (comdriver='FOSSIL') then driver:=0 else
      driver:=1;
    if (driver=0) then imp_install(comport,anyerrors,true) else
      if (driver=1) then imp_install(comport,anyerrors,false);
    if (not local) then begin
      imp_set_parity(com_none,1);
      imp_set_speed(bpsrate);
    end;
  end; {else}
end; {initialize}

Procedure IDF_Read(Fn:String);
Var IDF:text;
    s:string;
begin
  assign(idf,fn);
  {$I-} reset(idf); {$I+}
  if (ioresult<>0) then
  begin
    colorcodes('|07"'+fn+'" not found.|CRAborting...');
    exit;
  end else
  begin
    readln(idf,s);
    comdriver:=copy(s,15,length(s));
    readln(idf,s);
    comport:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    irqnumb:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    inoutbuffer:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    bpsrate:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    version:=copy(s,15,length(s));
    readln(idf,s);
    bbsname:=copy(s,15,length(s));
    readln(idf,s);
    sysname:=copy(s,15,length(s));
    readln(idf,s);
    username:=copy(s,15,length(s));
    readln(idf,s);
    realname:=copy(s,15,length(s));
    readln(idf,s);
    userpw:=copy(s,15,length(s));
    readln(idf,s);
    securitylvl:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    downloadlvl:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    filepts:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    promptnum:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    emulationtyp:=copy(s,15,length(s));
    readln(idf,s);
    uploads:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    downloads:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    upl_k:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    dnl_k:=string2num(copy(s,15,length(s)));
    readln(idf,s);
    currtime:=copy(s,15,length(s));
    readln(idf,s);
    timeleft:=string2num(copy(s,15,length(s)));
    close(idf);
    writeln(fn+' Imported and Evaluated.');
  end;
end;

Function String2Num(s:string):longint;
var i:longint;
    j:integer;
begin
  Val(s,i,j);
  if (j<>0) then begin
    s:=copy(s,1,j-1);
    Val(s,i,j)
  end;
  String2Num:=i;
  if (s='') then String2Num:=0;
end;

Function Num2String(i:longint):string;
var c:string[16];
begin
  Str(i,c);
  Num2String:=c;
end;

{This Procedure will HAVE to be changed to suit your ansi emulator, and to
 send to the comport}

procedure ColorCodes(s:string);
var x:integer;
    a,first,second:string;
begin
  x:=1;
  while x <= length(s) do begin
  case s[x] of
    '|':begin
    x:=x + 1;
    first:=copy(s,x,1);
    second:=copy(s,x+1,1);
    a:=(upcase(first[1]))+(upcase(second[1]));
    if x <= length(s) then begin
    If
    a='B1' then textcolor(textattr+16) else if
    a='B2' then textcolor(textattr+32) else if
    a='B3' then textcolor(textattr+48) else if
    a='B4' then textcolor(textattr+64) else if
    a='B5' then textcolor(textattr+80) else if
    a='B6' then textcolor(textattr+96) else if
    a='B7' then textcolor(textattr+112) else if
    a='00' then textcolor(0) else if
    a='01' then textcolor(1) else If
    a='02' then textcolor(2) else if
    a='03' then textcolor(3) else if
    a='04' then textcolor(4) else if
    a='05' then textcolor(5) else if
    a='06' then textcolor(6) else if
    a='07' then textcolor(7) else if
    a='08' then textcolor(8) else if
    a='09' then textcolor(9) else if
    a='10' then textcolor(10) else if
    a='11' then textcolor(11) else if
    a='12' then textcolor(12) else if
    a='13' then textcolor(13) else if
    a='14' then textcolor(14) else if
    a='15' then textcolor(15) else if
    a='NL' then begin
                  writeln;
                  if (outcom) then begin imp_tx(^M); imp_tx(^J); end;
                end;
    end; {x <= length(s)}
    x:=x + 2;
    end else begin
    if (outcom) then imp_tx(s[x]);
    write(s[x]); {WriteAnsi should be replaced by your ansi driver calls}
    x:=x + 1;
    end; {'|'}
  end; {case}
  end; {while x <= length(s) do begin}
end;

End. {End of IMPDEV.PAS}