/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class ZIPTool {
    private ZIPTool() {
    }

    public static URL toUrl(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = ZIPTool.toURL(file);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
        return uRL;
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static boolean isZipped(File file) {
        try {
            return ZIPTool.isZipped(ZIPTool.toURL(file));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isZipped(URL uRL) {
        try {
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            if (dataInputStream.readByte() == 80 && dataInputStream.readByte() == 75 && dataInputStream.readByte() == 3 && dataInputStream.readByte() == 4) {
                return true;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static BufferedReader openPossiblyZipped(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        if (ZIPTool.isZipped(uRL)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
                ZipInputStream zipInputStream = new ZipInputStream(dataInputStream);
                zipInputStream.getNextEntry();
                bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
            }
            catch (ZipException zipException) {
                System.err.println("ZipException " + zipException);
                return null;
            }
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        return bufferedReader;
    }
}

