/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class JavePlayer
extends Panel
implements ItemListener,
WindowListener,
ActionListener,
MouseListener,
Runnable {
    protected JavePlate plate;
    protected JaveMovieFile movieFile;
    protected AudioClip audioClip;
    protected int audioStart;
    protected int currentFrameIndex;
    protected static final String TITLE = "Jave Player V1.2";
    public static final int SOUND_ONCE = 0;
    public static final int SOUND_LOOP = 1;
    public static final int SOUND_EVENT = 2;
    public static final int DEFAULT_DURATION = 66;
    public static final int DEFAULT_CONTROLS = 2;
    public static final boolean DEFAULT_LOOP = false;
    public static final boolean DEFAULT_AUTOSTART = false;
    public static final Color DEFAULT_BACKGROUND = Color.white;
    public static final Color DEFAULT_FOREGROUND = Color.black;
    public static final int DEFAULT_SOUND_START = 0;
    protected Button bPrev;
    protected Button bPlay;
    protected Button bPause;
    protected Button bStop;
    protected Button bNext;
    protected Button bZoomIn;
    protected Button bZoomOut;
    protected TextField tfTool;
    protected TextField tfAction;
    protected TextField tfFrame;
    protected Choice chSpeed;
    protected Checkbox cbReverse;
    protected Label lFps;
    protected boolean reverse = false;
    protected static final String[] STR_SPEEDS = new String[]{"Slowest (0.1x)", "Slower (0.2x)", "Slow (0.5x)", "Normal Speed (1x)", "Fast (1.3x)", "Faster (2x)", "Fastest (4x)", "As fast as possible"};
    protected static final double[] DURATION_MULTIPLICATOR = new double[]{10.0, 5.0, 2.0, 1.0, 0.75, 0.5, 0.25, 0.0};
    protected static final int DEFAULT_SPEED = 3;
    protected int sleepTime;
    protected double durationMultiplicator = 1.0;
    protected Thread thread;
    protected boolean pause;
    protected boolean shallStop;
    protected int defaultDuration;
    protected boolean loop;
    protected boolean autostart;
    protected static final String DEFAULT_NAME1 = "e:\\jave\\player\\demo\\tshilp.zip";
    protected static final String DEFAULT_NAME2 = "e:\\jave\\player\\demo\\king_lion.zip";
    protected static final String DEFAULT_NAME3 = "e:\\jave\\player\\demo\\mandel.zip";
    protected static final String DEFAULT_NAME = "e:\\test\\sw\\sw1.neuspec.jmov";

    public JavePlayer() {
        this(66, 2, false, false, DEFAULT_BACKGROUND, DEFAULT_FOREGROUND);
    }

    public JavePlayer(int n) {
        this(66, n, false, false, DEFAULT_BACKGROUND, DEFAULT_FOREGROUND);
    }

    public JavePlayer(int n, int n2, boolean bl, boolean bl2, Color color, Color color2) {
        this.defaultDuration = n;
        this.loop = bl;
        this.autostart = bl2;
        this.setLayout(new BorderLayout(2, 2));
        if (n2 != -1) {
            this.plate = new JavePlate();
            this.plate.setBackground(color);
            this.plate.setForeground(color2);
            this.plate.addMouseListener(this);
            this.add((Component)this.plate, "Center");
        }
        this.currentFrameIndex = 0;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                this.add(this.createControlBar(), "South");
                break;
            }
            default: {
                Panel panel = new Panel();
                panel.setLayout(new GridLayout(0, 1, 2, 2));
                panel.add(this.createStatusBar());
                panel.add(this.createControlBar());
                this.add((Component)panel, "South");
            }
        }
    }

    public void setAudioClip(AudioClip audioClip) {
        this.audioClip = audioClip;
    }

    public void setAudioStart(int n) {
        this.audioStart = n;
    }

    public void setPlateBackground(Color color) {
        if (this.plate != null) {
            this.plate.setBackground(color);
        }
    }

    public void setPlateForeground(Color color) {
        if (this.plate != null) {
            this.plate.setForeground(color);
        }
    }

    public void load(String string) {
        try {
            this.movieFile = new JaveMovieFile(string);
            this.movieFile.setDefaultDuration(this.defaultDuration);
            this.movieFile.load();
        }
        catch (Exception exception) {
            if (this.plate != null) {
                this.plate.setStatusMessage(exception.getMessage());
                this.plate.setContent(null);
            }
            return;
        }
        if (this.plate != null) {
            if (this.movieFile.getFrameCount() > 0) {
                this.plate.setContent(this.movieFile.getFrame(0));
            } else {
                this.plate.setContent(null);
            }
        }
        if (this.autostart) {
            this.doPlay();
        }
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.pause = false;
        int n = 0;
        long l2 = System.currentTimeMillis();
        while (!this.shallStop && (this.loop || !this.reverse && this.currentFrameIndex < this.movieFile.getFrameCount() - 1 || this.reverse && this.currentFrameIndex > 0)) {
            long l3 = (long)((double)this.sleepTime * this.durationMultiplicator) - (System.currentTimeMillis() - l);
            if (l3 > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (++n % 10 == 0) {
                long l4 = System.currentTimeMillis() - l2;
                l2 = System.currentTimeMillis();
                double d = 10000.0 / (double)l4;
                if (this.lFps != null) {
                    this.lFps.setText(String.valueOf((double)((int)(d * 10.0)) / 10.0) + " fps");
                }
            }
            l = System.currentTimeMillis();
            while (this.plate != null && !this.plate.isRepainted()) {
                Thread.currentThread();
                Thread.yield();
            }
            if (!this.pause && !this.shallStop) {
                this.doNext();
            }
            if (this.plate == null) continue;
            this.plate.getToolkit().sync();
        }
        this.thread = null;
    }

    public void setMovieFile(JaveMovieFile javeMovieFile) {
        this.doStop();
        this.movieFile = javeMovieFile;
        this.currentFrameIndex = -1;
        this.setFrame(0);
    }

    protected void setFrame(int n) {
        if (n == this.currentFrameIndex) {
            return;
        }
        this.currentFrameIndex = n;
        if (this.currentFrameIndex < 0 || this.currentFrameIndex >= this.movieFile.getFrameCount()) {
            if (this.plate != null && this.movieFile.getFrameCount() == 0) {
                this.plate.setStatusMessage("* Empty Movie *");
            }
            if (this.plate != null) {
                this.plate.setContent(null);
                this.plate.repaint();
            }
            this.tfFrame.setText("");
            this.tfTool.setText("");
            this.tfAction.setText("");
            return;
        }
        JaveMovieFrame javeMovieFrame = this.movieFile.getFrame(this.currentFrameIndex);
        this.sleepTime = javeMovieFrame.getDuration();
        if (this.plate != null) {
            this.plate.setContent(javeMovieFrame);
            this.plate.repaint();
        }
        if (this.tfFrame != null) {
            this.tfFrame.setText(this.currentFrameIndex + 1 + "/" + this.movieFile.getFrameCount());
        }
        if (this.tfTool != null) {
            this.tfTool.setText(javeMovieFrame.getTool());
        }
        if (this.tfAction != null) {
            this.tfAction.setText(javeMovieFrame.getAction());
        }
    }

    public void doPlay() {
        this.currentFrameIndex = this.reverse ? this.movieFile.getFrameCount() - 1 : 0;
        this.setFrame(this.currentFrameIndex);
        if (this.thread != null) {
            this.shallStop = true;
            try {
                this.thread.interrupt();
                while (this.thread != null || this.thread.isAlive()) {
                    Thread.yield();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.shallStop = false;
        if (this.audioClip != null) {
            JaveMovieFrame javeMovieFrame;
            if (this.audioStart == 0) {
                this.audioClip.play();
            } else if (this.audioStart == 1) {
                this.audioClip.loop();
            } else if (this.audioStart == 2 && (javeMovieFrame = this.movieFile.getFrame(this.currentFrameIndex)).isSoundTrigger()) {
                this.audioClip.play();
            }
        }
        this.thread.start();
    }

    public void doPause() {
        boolean bl = this.pause = !this.pause;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void doStop() {
        if (this.thread != null) {
            this.shallStop = true;
            try {
                this.thread.interrupt();
                while (this.thread != null && this.thread.isAlive()) {
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.audioClip != null) {
                this.audioClip.stop();
            }
        }
    }

    public void doPrev() {
        if (!this.reverse) {
            if (this.currentFrameIndex > 0) {
                this.setFrame(this.currentFrameIndex - 1);
            } else if (this.loop) {
                this.setFrame(this.movieFile.getFrameCount() - 1);
            }
        } else if (this.currentFrameIndex < this.movieFile.getFrameCount() - 1) {
            this.setFrame(this.currentFrameIndex + 1);
        } else if (this.loop) {
            this.setFrame(0);
        }
    }

    public void doNext() {
        if (this.reverse) {
            if (this.currentFrameIndex > 0) {
                this.setFrame(this.currentFrameIndex - 1);
            } else if (this.loop) {
                this.setFrame(this.movieFile.getFrameCount() - 1);
            }
        } else {
            JaveMovieFrame javeMovieFrame;
            if (this.currentFrameIndex < this.movieFile.getFrameCount() - 1) {
                this.setFrame(this.currentFrameIndex + 1);
            } else if (this.loop) {
                this.setFrame(0);
            }
            if (this.audioClip != null && this.audioStart == 2 && (javeMovieFrame = this.movieFile.getFrame(this.currentFrameIndex)).isSoundTrigger()) {
                this.audioClip.play();
            }
        }
    }

    public void doZoomIn() {
        this.plate.zoomIn();
    }

    public void doZoomOut() {
        this.plate.zoomOut();
    }

    protected Component createStatusBar() {
        Panel panel = new Panel();
        this.tfTool = new TextField(12);
        this.tfAction = new TextField(12);
        this.tfFrame = new TextField(10);
        panel.add(new Label("Frame:", 2));
        panel.add(this.tfFrame);
        panel.add(new Label("Tool:", 2));
        panel.add(this.tfTool);
        panel.add(new Label("Action:", 2));
        panel.add(this.tfAction);
        this.lFps = new Label("0.00 fps");
        panel.add(this.lFps);
        return panel;
    }

    protected Component createControlBar() {
        Panel panel = new Panel();
        this.bPrev = new Button("Prev");
        this.bPrev.addActionListener(this);
        this.bPlay = new Button("Play");
        this.bPlay.addActionListener(this);
        this.bPause = new Button("Pause");
        this.bPause.addActionListener(this);
        this.bStop = new Button("Stop");
        this.bStop.addActionListener(this);
        this.bNext = new Button("Next");
        this.bNext.addActionListener(this);
        this.cbReverse = new Checkbox("Reverse", false);
        this.cbReverse.addItemListener(this);
        this.reverse = false;
        this.bZoomIn = new Button("Zoom in");
        this.bZoomIn.addActionListener(this);
        this.bZoomOut = new Button("Zoom out");
        this.bZoomOut.addActionListener(this);
        this.chSpeed = new Choice();
        int n = 0;
        while (n < STR_SPEEDS.length) {
            this.chSpeed.add(STR_SPEEDS[n]);
            ++n;
        }
        this.chSpeed.select(3);
        this.chSpeed.addItemListener(this);
        this.durationMultiplicator = DURATION_MULTIPLICATOR[this.chSpeed.getSelectedIndex()];
        panel.add(this.bPrev);
        panel.add(this.bPlay);
        panel.add(this.bPause);
        panel.add(this.bStop);
        panel.add(this.bNext);
        panel.add(this.cbReverse);
        panel.add(this.chSpeed);
        panel.add(this.bZoomIn);
        panel.add(this.bZoomOut);
        return panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chSpeed) {
            this.durationMultiplicator = DURATION_MULTIPLICATOR[this.chSpeed.getSelectedIndex()];
        } else if (object == this.cbReverse) {
            this.reverse = this.cbReverse.getState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bNext) {
            this.doNext();
            return;
        }
        if (object == this.bPrev) {
            this.doPrev();
            return;
        }
        if (object == this.bStop) {
            this.doStop();
            return;
        }
        if (object == this.bPlay) {
            this.doPlay();
            return;
        }
        if (object == this.bPause) {
            this.doPause();
            return;
        }
        if (object == this.bZoomIn) {
            this.doZoomIn();
            return;
        }
        if (object == this.bZoomOut) {
            this.doZoomOut();
            return;
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.thread == null) {
            this.doPlay();
        } else {
            this.doPause();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            JavePlayer.createPlayerApplication(stringArray[0]);
        } else {
            JavePlayer.createPlayerApplication(DEFAULT_NAME2);
        }
    }

    protected static void createPlayerApplication(String string) {
        JavePlayer javePlayer = new JavePlayer();
        Frame frame = new Frame(TITLE);
        frame.setLayout(new GridLayout(1, 0, 0, 0));
        frame.add(javePlayer);
        frame.addWindowListener(javePlayer);
        frame.pack();
        ((Component)frame).setSize(frame.getSize().width, 500);
        frame.show();
        javePlayer.load(string);
    }
}

