/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.jave.Tool;
import de.jave.jave.algorithm.AsciiRepairRule;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class AsciiRepairAlgorithm
implements JaveConfigurationLoadable {
    protected static boolean initialized = false;
    protected static AsciiRepairRule[] rules;
    protected static int identical;
    protected static int identicalLeft;
    protected static int identicalRight;

    public static void init() {
        AsciiRepairAlgorithm.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new AsciiRepairAlgorithm());
        initialized = true;
    }

    public String getConfigurationFileName() {
        return "./config/repair.txt";
    }

    public void setDefaultConfiguration() {
        rules = new AsciiRepairRule[0];
    }

    public void loadConfiguration(File file) throws Exception {
        Vector<AsciiRepairRule> vector = new Vector<AsciiRepairRule>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        boolean bl = false;
        int n = 0;
        String string = bufferedReader.readLine();
        ++n;
        while (string != null && (string.length() < 1 || string.charAt(0) == '#')) {
            string = bufferedReader.readLine();
            ++n;
        }
        identical = Integer.parseInt(string);
        string = bufferedReader.readLine();
        ++n;
        while (string != null && (string.length() < 1 || string.charAt(0) == '#')) {
            string = bufferedReader.readLine();
            ++n;
        }
        identicalLeft = Integer.parseInt(string);
        string = bufferedReader.readLine();
        ++n;
        while (string != null && (string.length() < 1 || string.charAt(0) == '#')) {
            string = bufferedReader.readLine();
            ++n;
        }
        identicalRight = Integer.parseInt(string);
        while (string != null) {
            string = bufferedReader.readLine();
            ++n;
            while (string != null && (string.length() < 1 || string.charAt(0) == '#')) {
                string = bufferedReader.readLine();
                ++n;
            }
            if (string == null) break;
            String string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null && (string2.length() < 1 || string2.charAt(0) == '#')) {
                string2 = bufferedReader.readLine();
                ++n;
            }
            if (string2 == null) break;
            String string3 = bufferedReader.readLine();
            ++n;
            while (string3 != null && (string3.length() < 1 || string3.charAt(0) == '#')) {
                string3 = bufferedReader.readLine();
                ++n;
            }
            if (string3 == null) break;
            AsciiRepairRule asciiRepairRule = AsciiRepairRule.getFrom(string, string2, string3);
            if (asciiRepairRule == null) continue;
            vector.addElement(asciiRepairRule);
        }
        bufferedReader.close();
        rules = new AsciiRepairRule[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            AsciiRepairAlgorithm.rules[n2] = (AsciiRepairRule)vector.elementAt(n2);
            ++n2;
        }
        initialized = true;
    }

    public static CharacterPlate repairShaked(CharacterPlate characterPlate) {
        int n = characterPlate.getHeight();
        int n2 = 0;
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = characterPlate.getLine(n3).trim();
            if (stringArray[n3].length() > n2) {
                n2 = stringArray[n3].length();
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        int n4 = 0;
        while (n4 < n - 1) {
            String string = stringArray[n4];
            String string2 = stringArray[n4 + 1];
            if (string2.length() != 0) {
                int n5 = 0;
                int n6 = 0;
                int n7 = -string2.length();
                while (n7 <= string.length()) {
                    int n8 = AsciiRepairAlgorithm.rate(string, string2, n7);
                    if (n8 > n6) {
                        n6 = n8;
                        n5 = n7;
                    }
                    ++n7;
                }
                if (n5 < 0) {
                    String string3 = "";
                    while (n5 < 0) {
                        string3 = string3 + " ";
                        ++n5;
                    }
                    int n9 = 0;
                    while (n9 <= n4) {
                        stringArray[n9] = string3 + stringArray[n9];
                        ++n9;
                    }
                } else if (n5 > 0) {
                    while (n5 > 0) {
                        stringArray[n4 + 1] = " " + stringArray[n4 + 1];
                        --n5;
                    }
                }
            }
            ++n4;
        }
        return new CharacterPlate(stringArray);
    }

    protected static int rate(String string, String string2, int n) {
        int n2 = 0;
        n2 = n > 0 ? Tool.max(string.length(), string2.length() + n) : Tool.max(string.length(), string2.length() + n) - n;
        char[] cArray = new char[n2];
        char[] cArray2 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = 32;
            cArray2[n3] = 32;
            ++n3;
        }
        char[] cArray3 = string.toCharArray();
        char[] cArray4 = string2.toCharArray();
        if (n < 0) {
            System.arraycopy(cArray3, 0, cArray, -n, cArray3.length);
            System.arraycopy(cArray4, 0, cArray2, 0, cArray4.length);
        } else {
            System.arraycopy(cArray3, 0, cArray, 0, cArray3.length);
            System.arraycopy(cArray4, 0, cArray2, n, cArray4.length);
        }
        return AsciiRepairAlgorithm.rate(cArray, cArray2);
    }

    protected static int rate(char[] cArray, char[] cArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != ' ' && cArray[n2] == cArray2[n2]) {
                n += identical;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < cArray.length) {
            if (cArray[n3] != ' ' && cArray[n3] == cArray2[n3 - 1]) {
                n += identicalLeft;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < cArray.length - 1) {
            if (cArray[n4] != ' ' && cArray[n4] == cArray2[n4 + 1]) {
                n += identicalRight;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < rules.length) {
            n += rules[n5].rate(cArray, cArray2);
            ++n5;
        }
        return n;
    }

    static {
        identical = 0;
        identicalLeft = 0;
        identicalRight = 0;
    }
}

