/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.ImageLoader;
import de.jave.gui.GButton;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GSliderArrangement;
import de.jave.gui.VFlowLayout;
import de.jave.io.IOTools;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.MoveResizeRectangle;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkPainter;
import de.jave.util.Toolbox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class WatermarkTool
extends Tool
implements ActionListener,
ItemListener,
WatermarkPainter,
AdjustmentListener {
    protected Image image;
    protected Image image2;
    protected int imageWidth;
    protected int imageHeight;
    protected String currentDirectory;
    protected GButton gbLoad;
    protected GButton gbClose;
    protected Button bFit;
    protected TextField tfSize;
    protected TextField tfPosition;
    protected TextField tfImageName;
    protected GSliderArrangement slaBrightness;
    protected Checkbox cbNegative;
    protected double xPos;
    protected double yPos;
    protected double wPos;
    protected double hPos;
    protected int mode;
    protected MoveResizeRectangle imageRegion;
    protected boolean enabled;
    protected static final String LABEL = "Watermark";
    protected Point point1;

    public WatermarkTool(Plate plate, Jave jave) {
        super(plate, jave);
        plate.addWatermarkPainter(this);
    }

    public String getName() {
        return LABEL;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIconName() {
        return "watermark";
    }

    public Component createOptionsComponent() {
        this.bFit = new Button("Fit");
        this.bFit.addActionListener(this);
        this.tfSize = new TextField(10);
        this.tfSize.setEditable(false);
        this.tfPosition = new TextField(10);
        this.tfPosition.setEditable(false);
        this.slaBrightness = new GSliderArrangement("Brightness:", -100, 100, 50, 5, 100);
        this.slaBrightness.addAdjustmentListener(this);
        this.cbNegative = new Checkbox("Negative", false);
        this.cbNegative.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2, 2, 2));
        panel.add(new Label("Position:", 2));
        panel.add(this.tfPosition);
        panel.add(new Label("Size:", 2));
        panel.add(this.tfSize);
        panel.add(this.bFit);
        panel.add(this.cbNegative);
        this.tfImageName = new TextField(15);
        this.tfImageName.setEditable(false);
        this.gbLoad = JaveImages.createButton("open", "open_");
        this.gbLoad.addActionListener(this);
        this.gbClose = JaveImages.createButton("close", "close_");
        this.gbClose.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1, 0, 0));
        panel2.add(new Label("Image:", 2));
        panel2.add(this.tfImageName);
        panel2.add(this.gbLoad);
        panel2.add(this.gbClose);
        Panel panel3 = new Panel();
        panel3.setLayout(new VFlowLayout(0, 0));
        panel3.add(panel);
        panel3.add(this.slaBrightness);
        panel3.add(panel2);
        this.bFit.setEnabled(false);
        this.gbClose.setEnabled(false);
        this.cbNegative.setEnabled(false);
        this.slaBrightness.setEnabled(false);
        JaveGlobalRessources.tooltips.add((Component)this.gbLoad, "Load a GIF or JPG image as watermark");
        JaveGlobalRessources.tooltips.add((Component)this.gbClose, "Close current watermark");
        return panel3;
    }

    public void takeToHand() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.jave.toolBar.setWatermarkVisible(true);
    }

    public void putAside(boolean bl) {
    }

    public boolean containsScreenPoint(Point point) {
        return this.imageRegion != null && this.imageRegion.contains(point);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.enabled || this.image2 == null) {
            return;
        }
        int n7 = (int)(this.wPos * (double)n5);
        int n8 = (int)(this.hPos * (double)n6);
        Point point = this.plate.getScreenPointFor(this.xPos, this.yPos);
        int n9 = point.x;
        int n10 = point.y;
        this.imageRegion = new MoveResizeRectangle(n9, n10, n7, n8);
        graphics.drawImage(this.image2, n9, n10, n7, n8, this.plate);
    }

    protected void close() {
        GDialog gDialog = new GDialog((Frame)this.jave, "JavE", "Do you really want to close the watermark?", GDialog.YES_NO_CANCEL, 1);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == -1 || n == 1 || n == 2) {
            return;
        }
        this.image2 = null;
        this.imageRegion = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.image != null) {
            this.repaintAll();
        }
        this.image = null;
        this.tfImageName.setText("");
        this.bFit.setEnabled(false);
        this.gbClose.setEnabled(false);
        this.cbNegative.setEnabled(false);
        this.slaBrightness.setEnabled(false);
    }

    public void load() {
        FileDialog fileDialog = new FileDialog((Frame)this.jave, "Open image", 0);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        String string3 = string.toLowerCase();
        if (!(string3.endsWith(".gif") || string3.endsWith(".jpg") || string3.endsWith(".jpeg") || string3.endsWith(".bmp"))) {
            new GErrorDialog((Frame)this.jave, "JavE", "Error loading image", "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).").show();
            return;
        }
        String string4 = string2 + string;
        if (!this.setImage(ImageLoader.loadImage(string4, this.jave), string)) {
            new GErrorDialog((Frame)this.jave, "JavE", "Error loading image", "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).").show();
            return;
        }
        this.currentDirectory = string2;
    }

    public boolean setImage(Image image, String string) {
        this.image = image;
        this.tfImageName.setText(IOTools.getDisplayFilename(string, 20));
        this.imageWidth = -1;
        this.imageHeight = -1;
        if (this.image != null) {
            MediaTracker mediaTracker = new MediaTracker(this.jave);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.imageWidth = this.image.getWidth(this.jave);
            this.imageHeight = this.image.getHeight(this.jave);
        }
        if (this.imageWidth == -1 || this.imageHeight == -1) {
            return false;
        }
        this.bFit.setEnabled(true);
        this.gbClose.setEnabled(true);
        this.cbNegative.setEnabled(true);
        this.slaBrightness.setEnabled(true);
        this.wPos = this.plate.getDocumentWidth();
        if (this.wPos < 5.0) {
            this.wPos = 5.0;
        }
        this.hPos = (double)this.imageHeight * this.wPos / (double)this.imageWidth / 1.98;
        this.jave.toolBar.setWatermarkVisible(true);
        this.updateLabels();
        double d = this.slaBrightness.getDValue();
        boolean bl = this.cbNegative.getState();
        this.image2 = this.lighten(this.image, d, bl);
        this.repaintAll();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.gbLoad) {
            this.load();
        } else if (object == this.gbClose) {
            this.close();
        } else if (object == this.bFit) {
            this.fit();
        }
    }

    protected void fit() {
        if (this.image == null) {
            return;
        }
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.wPos = this.plate.getDocumentWidth();
        this.hPos = this.plate.getDocumentHeight();
        this.updateLabels();
        this.repaintAll();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.image == null) {
            return;
        }
        if (adjustmentEvent.getSource() == this.slaBrightness) {
            double d = this.slaBrightness.getDValue();
            boolean bl = this.cbNegative.getState();
            this.image2 = this.lighten(this.image, d, bl);
        }
        if (this.image2 != null) {
            this.repaintAll();
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.image2 == null || this.imageRegion == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolRegion);
        this.imageRegion.paint(graphics);
        graphics.setColor(JaveGlobalRessources.colorToolRegion);
        int n = this.imageRegion.x;
        int n2 = this.imageRegion.y;
        int n3 = this.imageRegion.width;
        int n4 = this.imageRegion.height;
        graphics.setFont(JaveGlobalRessources.FONT_SMALL);
        FontMetrics fontMetrics = this.jave.getFontMetrics(JaveGlobalRessources.FONT_SMALL);
        int n5 = fontMetrics.stringWidth(LABEL) + 10;
        int[] nArray = new int[]{n + n3 - n5 - 5, n + n3 - n5 + 5, n + n3 - 10, n + n3};
        int[] nArray2 = new int[]{n2 + n4, n2 + n4 + 20, n2 + n4 + 20, n2 + n4};
        graphics.setColor(JaveGlobalRessources.colorPlateBackground);
        graphics.fillPolygon(nArray, nArray2, 4);
        graphics.setColor(JaveGlobalRessources.colorToolRegion);
        graphics.drawPolygon(nArray, nArray2, 4);
        graphics.drawString(LABEL, n + n3 - n5 + 3, n2 + n4 + 13);
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
        super.mouseMoved(point, point2, mouseEvent);
        if (this.image2 == null || this.imageRegion == null) {
            return;
        }
        this.setCursor(this.imageRegion.getCursorFor(point));
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.image2 == null || this.imageRegion == null) {
            return;
        }
        this.mode = this.imageRegion.getPlace(point);
        this.point1 = point;
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.image2 == null || this.imageRegion == null || this.point1 == null) {
            return;
        }
        if (this.mode == 0) {
            return;
        }
        int n = point.x - this.point1.x;
        int n2 = point.y - this.point1.y;
        int n3 = this.plate.charWidth;
        int n4 = this.plate.charHeight;
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        this.point1 = point;
        if (this.mode == 1) {
            this.xPos += d;
            this.yPos += d2;
        } else if (this.mode == 2) {
            this.yPos += d2;
            this.hPos -= d2;
            if (Tool.shiftDown) {
                this.wPos = this.hPos / (double)this.imageHeight * (double)this.imageWidth * 1.98;
            }
        } else if (this.mode == 4) {
            this.hPos += d2;
            if (Tool.shiftDown) {
                this.wPos = this.hPos / (double)this.imageHeight * (double)this.imageWidth * 1.98;
            }
        } else if (this.mode == 5) {
            this.wPos += d;
            if (Tool.shiftDown) {
                this.hPos = (double)this.imageHeight * this.wPos / (double)this.imageWidth / 1.98;
            }
        } else if (this.mode == 3) {
            this.xPos += d;
            this.wPos -= d;
            if (Tool.shiftDown) {
                this.hPos = (double)this.imageHeight * this.wPos / (double)this.imageWidth / 1.98;
            }
        } else if (this.mode == 7) {
            this.yPos += d2;
            this.hPos -= d2;
            this.xPos += d;
            this.wPos -= d;
            if (Tool.shiftDown) {
                double d3 = this.wPos - this.hPos / (double)this.imageHeight * (double)this.imageWidth * 1.98;
                this.wPos -= d3;
                this.xPos += d3;
            }
        } else if (this.mode == 6) {
            this.yPos += d2;
            this.hPos -= d2;
            this.wPos += d;
            if (Tool.shiftDown) {
                this.wPos = this.hPos / (double)this.imageHeight * (double)this.imageWidth * 1.98;
            }
        } else if (this.mode == 8) {
            this.hPos += d2;
            this.wPos += d;
            if (Tool.shiftDown) {
                this.hPos = (double)this.imageHeight * this.wPos / (double)this.imageWidth / 1.98;
            }
        } else if (this.mode == 9) {
            this.hPos += d2;
            this.xPos += d;
            this.wPos -= d;
            if (Tool.shiftDown) {
                this.hPos = (double)this.imageHeight * this.wPos / (double)this.imageWidth / 1.98;
            }
        }
        if (this.wPos < 2.0) {
            this.wPos = 2.0;
        }
        if (this.hPos < 2.0) {
            this.hPos = 2.0;
        }
        this.updateLabels();
        this.repaintAll();
    }

    protected Image lighten(Image image, double d, boolean bl) {
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Internal Error: " + interruptedException.toString());
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Internal Error: Image fetch aborted or errored.");
        }
        double d2 = 1.0 - d;
        double d3 = d * 255.0;
        if (d < 0.0) {
            d2 = d + 1.0;
            d3 = 0.0;
        }
        if (!bl) {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = 0xFF000000 | (int)((double)(nArray[n] >> 16 & 0xFF) * d2 + d3) << 16 | (int)((double)(nArray[n] >> 8 & 0xFF) * d2 + d3) << 8 | (int)((double)(nArray[n] & 0xFF) * d2 + d3);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = 0xFF000000 | (int)((double)(255 - (nArray[n] >> 16 & 0xFF)) * d2 + d3) << 16 | (int)((double)(255 - (nArray[n] >> 8 & 0xFF)) * d2 + d3) << 8 | (int)((double)(255 - (nArray[n] & 0xFF)) * d2 + d3);
                ++n;
            }
        }
        return this.jave.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.image == null) {
            return;
        }
        if (itemEvent.getSource() == this.cbNegative) {
            double d = this.slaBrightness.getDValue();
            boolean bl = this.cbNegative.getState();
            this.image2 = this.lighten(this.image, d, bl);
        }
        if (this.image2 != null) {
            this.repaintAll();
        }
    }

    protected void updateLabels() {
        double d = Toolbox.round(this.xPos, 2);
        double d2 = Toolbox.round(this.yPos, 2);
        double d3 = Toolbox.round(this.wPos, 2);
        double d4 = Toolbox.round(this.hPos, 2);
        this.tfPosition.setText(d + "; " + d2);
        this.tfSize.setText(d3 + "; " + d4);
    }
}

