/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.BooleanPlate;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveGlobalRessources;
import de.jave.util.IntVector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;

public class VIViewer {
    protected static final int BLINK_RATE = 2;
    protected static final int LINE_PAUSE = 0;
    protected static final int CHAR_PAUSE = 0;
    protected static final int FILE_PAUSE = 1000;
    protected static final String DIRECTORY = "G:\\VT100\\";
    protected static final String[] FILENAMES = new String[]{"bambi.vt", "441.vt", "airraid.vt", "arrow.vt", "arrowvt.vt", "barney.vt", "beer.vt"};
    protected CharacterPlate plate = new CharacterPlate(80, 30);
    protected int cursorX;
    protected int cursorY;
    protected int savedCursorX;
    protected int savedCursorY;
    protected int windowHomeX;
    protected int windowHomeY;
    protected int windowEndX;
    protected int windowEndY;
    protected boolean bold = false;
    protected boolean lowIntensity = false;
    protected boolean underline = false;
    protected boolean blink = false;
    protected boolean reverseVideo = false;
    protected boolean invisibleText = false;
    protected boolean warning = false;
    protected BooleanPlate blinkPlate = new BooleanPlate(80, 30);
    protected int blinkCounter;
    protected boolean screenReversed = false;
    int parseIndex;
    int parseLength;
    char[] parseText;

    public VIViewer() {
        this.resetToInitialState();
    }

    public void resetToInitialState() {
        this.cursorX = 0;
        this.cursorY = 0;
        this.windowHomeX = 0;
        this.windowHomeY = 0;
        this.windowEndX = this.plate.getWidth() - 1;
        this.windowEndY = this.plate.getHeight() - 1;
        this.bold = false;
        this.lowIntensity = false;
        this.underline = false;
        this.blink = false;
        this.reverseVideo = false;
        this.invisibleText = false;
    }

    public void setScreenReversed(boolean bl) {
        this.screenReversed = bl;
        if (this.warning) {
            System.err.println("WARNING: setScreenReversed not supported");
        }
    }

    public void newLine() {
        this.cursorX = this.windowHomeX;
        ++this.cursorY;
        if (this.cursorY > this.windowEndY) {
            this.scroll();
            this.cursorY = this.windowEndY;
        }
    }

    public void scroll() {
        CharacterPlate characterPlate = this.plate.getCopy(this.windowHomeX, this.windowHomeY + 1, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY);
        this.plate.fill(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY + 1, ' ');
        characterPlate.pasteInto(this.plate, this.windowHomeX, this.windowHomeY);
        BooleanPlate booleanPlate = this.blinkPlate.getCopy(this.windowHomeX, this.windowHomeY + 1, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY);
        this.blinkPlate.fill(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY + 1, false);
        booleanPlate.pasteInto(this.blinkPlate, this.windowHomeX, this.windowHomeY);
    }

    public void RI() {
        CharacterPlate characterPlate = this.plate.getCopy(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY);
        this.plate.fill(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY + 1, ' ');
        characterPlate.pasteInto(this.plate, this.windowHomeX, this.windowHomeY + 1);
        BooleanPlate booleanPlate = this.blinkPlate.getCopy(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY);
        this.blinkPlate.fill(this.windowHomeX, this.windowHomeY, this.windowEndX - this.windowHomeX + 1, this.windowEndY - this.windowHomeY + 1, false);
        booleanPlate.pasteInto(this.blinkPlate, this.windowHomeX, this.windowHomeY + 1);
    }

    public void SETWIN(int n, int n2) {
        this.windowHomeY = n;
        this.windowEndY = n2;
        if (this.cursorY < this.windowHomeY) {
            this.cursorY = this.windowHomeY;
        } else if (this.cursorY > this.windowEndY) {
            this.cursorY = this.windowEndY;
        }
    }

    public void CUP(int n, int n2) {
        this.cursorX = n2;
        this.cursorY = n;
    }

    public void CUU(int n) {
        this.cursorY -= n;
    }

    public void CUD(int n) {
        this.cursorY += n;
    }

    public void CUF(int n) {
        this.cursorX += n;
    }

    public void CUB(int n) {
        this.cursorX -= n;
    }

    public void RM(int n) {
        this.SM(n);
    }

    public void setCharacterSet(int n, char c) {
        switch (c) {
            case 'A': {
                if (!this.warning) break;
                System.err.println("WARNING: setCharacterSet not supported");
                break;
            }
            case 'B': {
                if (!this.warning) break;
                System.err.println("WARNING: setCharacterSet not supported");
                break;
            }
            case '0': {
                if (!this.warning) break;
                System.err.println("WARNING: setCharacterSet not supported");
                break;
            }
            case '1': {
                if (!this.warning) break;
                System.err.println("WARNING: setCharacterSet not supported");
                break;
            }
            case '2': {
                if (!this.warning) break;
                System.err.println("WARNING: setCharacterSet not supported");
                break;
            }
            default: {
                if (!this.warning) break;
                System.err.println("Unknown Mode in setCharacterSet: " + n + "," + c);
            }
        }
    }

    public void setLetterHeight(char c) {
        switch (c) {
            case '3': {
                if (!this.warning) break;
                System.err.println("WARNING: setLetterHeight not supported");
                break;
            }
            case '4': {
                if (!this.warning) break;
                System.err.println("WARNING: setLetterHeight not supported");
                break;
            }
            case '5': {
                if (!this.warning) break;
                System.err.println("WARNING: setLetterHeight not supported");
                break;
            }
            case '6': {
                if (!this.warning) break;
                System.err.println("WARNING: setLetterHeight not supported");
                break;
            }
            default: {
                if (!this.warning) break;
                System.err.println("Unknown Mode in setLetterHeight: " + c);
            }
        }
    }

    public void SM(int n) {
        switch (n) {
            case 0: {
                this.plate = new CharacterPlate(40, 25);
                break;
            }
            case 1: {
                this.plate = new CharacterPlate(40, 25);
                break;
            }
            case 2: {
                this.plate = new CharacterPlate(80, 25);
                break;
            }
            case 3: {
                this.plate = new CharacterPlate(80, 25);
                break;
            }
            case 4: {
                System.err.println("Unable to use Mode in SM: " + n + " =320x200 color");
                this.plate = new CharacterPlate(40, 25);
                break;
            }
            case 5: {
                System.err.println("Unable to use Mode in SM: " + n + " =320x200 black & white");
                this.plate = new CharacterPlate(40, 25);
                break;
            }
            case 6: {
                System.err.println("Unable to use Mode in SM: " + n + " =640x200 black & white");
                this.plate = new CharacterPlate(40, 25);
                break;
            }
            case 7: {
                System.err.println("Unable to use Mode in SM: " + n + " =Wrap at end of line!!!");
                break;
            }
            default: {
                System.err.println("Unknown Mode in SM: " + n);
            }
        }
    }

    public void eraseScreen(int n) {
        if (n == 0) {
            this.plate.fill(this.cursorX, this.cursorY, this.plate.getWidth() - this.cursorX, 1, ' ');
            if (this.cursorY < this.plate.getHeight() - 1) {
                this.plate.fill(0, this.cursorY + 1, this.plate.getWidth(), this.plate.getHeight() - this.cursorY - 1, ' ');
            }
        } else if (n == 1) {
            this.plate.fill(0, this.cursorY, this.cursorX, 1, ' ');
            this.plate.fill(0, 0, this.plate.getWidth(), this.cursorY, ' ');
        } else if (n == 2) {
            this.plate.clear();
            this.cursorX = 0;
            this.cursorY = 0;
        } else if (this.warning) {
            System.err.println("WARNING: Unknown mode in eraseScreen:" + n);
        }
    }

    public void eraseLine(int n) {
        if (n == 0) {
            this.plate.fill(this.cursorX, this.cursorY, this.windowEndX - this.cursorX, 1, ' ');
            this.blinkPlate.fill(this.cursorX, this.cursorY, this.windowEndX - this.cursorX, 1, false);
        } else if (n == 1) {
            this.plate.fill(this.windowHomeX, this.cursorY, this.cursorX - this.windowHomeX + 1, 1, ' ');
            this.blinkPlate.fill(this.windowHomeX, this.cursorY, this.cursorX - this.windowHomeX + 1, 1, false);
        } else if (n == 2) {
            this.plate.fill(this.windowHomeX, this.cursorY, this.windowEndX - this.windowHomeX + 1, 1, ' ');
            this.blinkPlate.fill(this.windowHomeX, this.cursorY, this.windowEndX - this.windowHomeX + 1, 1, false);
        } else if (this.warning) {
            System.err.println("WARNING: Unknown mode in eraseLine:" + n);
        }
    }

    public void SCP() {
        this.savedCursorX = this.cursorX;
        this.savedCursorY = this.cursorY;
    }

    public void RCP() {
        this.cursorX = this.savedCursorX;
        this.cursorY = this.savedCursorY;
    }

    public void SGR(int n) {
        if (n >= 30 && n <= 39) {
            if (this.warning) {
                System.err.println("WARNING: Foreground color not supported");
            }
            return;
        }
        if (n >= 40 && n <= 47) {
            if (this.warning) {
                System.err.println("WARNING: Background color not supported");
            }
            return;
        }
        switch (n) {
            case 0: {
                this.bold = false;
                this.lowIntensity = false;
                this.underline = false;
                this.blink = false;
                this.reverseVideo = false;
                this.invisibleText = false;
                break;
            }
            case 1: {
                if (this.warning) {
                    System.err.println("WARNING: Mode bold not supported");
                }
                this.bold = true;
                break;
            }
            case 2: {
                if (this.warning) {
                    System.err.println("WARNING: Mode lowIntensity not supported");
                }
                this.lowIntensity = true;
                break;
            }
            case 4: {
                if (this.warning) {
                    System.err.println("WARNING: Mode underline not supported");
                }
                this.underline = true;
                break;
            }
            case 5: {
                this.blink = true;
                break;
            }
            case 7: {
                this.reverseVideo = true;
                break;
            }
            case 8: {
                if (this.warning) {
                    System.err.println("WARNING: Mode invisibleText not supported");
                }
                this.invisibleText = true;
                break;
            }
            default: {
                System.err.println("Unknown Mode in SGR: " + n);
            }
        }
    }

    public void SGR(IntVector intVector) {
        int n = 0;
        while (n < intVector.size()) {
            this.SGR(intVector.get(n));
            ++n;
        }
    }

    public void insertLine() {
        this.plate.insertLine(this.cursorY);
    }

    public void deleteLine() {
        this.plate.removeLine(this.cursorY);
    }

    public void shiftOut() {
    }

    public void shiftIn() {
    }

    public void lineFeed() {
        ++this.cursorY;
    }

    public void carriageReturn() {
        this.cursorX = 0;
    }

    public void horizontalTab() {
        this.cursorX = (this.cursorX / 6 + 1) * 6;
    }

    public void NULL() {
    }

    public void BELL() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void backSpace() {
        --this.cursorX;
        if (this.cursorX < 0) {
            this.cursorX = this.windowEndX;
            --this.cursorY;
        }
    }

    public void endOfTransmissionBlock() {
    }

    public void unitSeperator() {
    }

    public void writeChar(char c) {
        block16: {
            if (c < ' ') {
                switch (c) {
                    case '\u0000': {
                        this.NULL();
                        break;
                    }
                    case '\u0007': {
                        this.BELL();
                        break;
                    }
                    case '\b': {
                        this.backSpace();
                        break;
                    }
                    case '\t': {
                        this.horizontalTab();
                        break;
                    }
                    case '\r': {
                        this.carriageReturn();
                        break;
                    }
                    case '\u000e': {
                        this.shiftOut();
                        break;
                    }
                    case '\u000f': {
                        this.shiftIn();
                        break;
                    }
                    case '\f': {
                        this.lineFeed();
                        break;
                    }
                    case '\u001f': {
                        this.unitSeperator();
                        break;
                    }
                    case '\u0017': {
                        this.endOfTransmissionBlock();
                        break;
                    }
                    default: {
                        System.err.println("####>---> " + c);
                        this.writeChar(' ');
                    }
                }
                return;
            }
            try {
                this.plate.setForce(this.cursorX, this.cursorY, c);
                this.blinkPlate.set(this.cursorX, this.cursorY, this.blink);
            }
            catch (Exception exception) {
                if (!this.warning) break block16;
                System.err.println(this.cursorX + "," + this.cursorY + " is not on screen!");
            }
        }
        ++this.cursorX;
        if (this.cursorX > this.windowEndX) {
            ++this.cursorY;
            this.cursorX = this.windowHomeX;
        }
    }

    protected int parseNumber() {
        if (this.parseIndex >= this.parseLength || this.parseText[this.parseIndex] < '0' || this.parseText[this.parseIndex] > '9') {
            return -1;
        }
        int n = 0;
        do {
            n *= 10;
            n += this.parseText[this.parseIndex] - 48;
            ++this.parseIndex;
        } while (this.parseIndex < this.parseLength && this.parseText[this.parseIndex] >= '0' && this.parseText[this.parseIndex] <= '9');
        return n;
    }

    protected IntVector parseNumbers() {
        IntVector intVector = null;
        while (true) {
            int n;
            if ((n = this.parseNumber()) == -1 && this.parseIndex < this.parseLength && this.parseText[this.parseIndex] == ';') {
                ++this.parseIndex;
                continue;
            }
            if (n == -1) {
                return intVector;
            }
            if (intVector == null) {
                intVector = new IntVector(5);
            }
            intVector.add(n);
        }
    }

    public void execute(String string, int n) {
        this.parseIndex = 0;
        this.parseLength = string.length();
        this.parseText = string.toCharArray();
        while (this.parseIndex < this.parseLength) {
            char c;
            if ((c = this.parseText[this.parseIndex++]) == '\u001b') {
                if (this.parseIndex == this.parseLength) {
                    if (this.warning) {
                        System.err.println("Broken line after ESC!");
                    }
                    return;
                }
                if ((c = this.parseText[this.parseIndex++]) == '[') {
                    IntVector intVector = this.parseNumbers();
                    if (this.parseIndex == this.parseLength) {
                        if (this.warning) {
                            System.err.println("Broken line after ESC!");
                        }
                        return;
                    }
                    c = this.parseText[this.parseIndex++];
                    if (intVector == null || intVector.size() == 0) {
                        if (c == 's') {
                            this.SCP();
                        } else if (c == 'u') {
                            this.RCP();
                        } else if (c == 'K') {
                            this.eraseLine(0);
                        } else if (c == 'J') {
                            this.eraseScreen(0);
                        } else if (c == 'm') {
                            this.SGR(0);
                        } else if (c == 's') {
                            this.SCP();
                        } else if (c == 'M') {
                            this.deleteLine();
                        } else if (c == 'L') {
                            this.insertLine();
                        } else if (c == 'A') {
                            this.CUU(1);
                        } else if (c == 'B') {
                            this.CUD(1);
                        } else if (c == 'C') {
                            this.CUF(1);
                        } else if (c == 'D') {
                            this.CUB(1);
                        } else if (c == 'H') {
                            this.CUP(0, 0);
                        } else if (c == '?') {
                            intVector = this.parseNumbers();
                            if ((c = this.parseText[this.parseIndex++]) == 'l' || c == 'h') {
                                if (intVector.size() == 1) {
                                    switch (intVector.get(0)) {
                                        case 5: {
                                            this.setScreenReversed(c == 'h');
                                            break;
                                        }
                                        default: {
                                            System.err.println("IGNORED Screen-Mode-Command: ESC [ ?" + intVector + c);
                                            break;
                                        }
                                    }
                                } else {
                                    System.err.println("IGNORED Command: ESC [ ? " + intVector + c);
                                }
                            } else {
                                System.err.println("UNKNOWN Command: ESC [ " + intVector + c);
                            }
                        } else {
                            System.err.println("UNKNOWN Command:  ESC [ " + c);
                        }
                    } else if (intVector.size() == 1) {
                        if (c == 'K') {
                            this.eraseLine(intVector.get(0));
                        } else if (c == 'J') {
                            this.eraseScreen(intVector.get(0));
                        } else if (c == 'A') {
                            this.CUU(intVector.get(0));
                        } else if (c == 'B') {
                            this.CUD(intVector.get(0));
                        } else if (c == 'C') {
                            this.CUF(intVector.get(0));
                        } else if (c == 'D') {
                            this.CUB(intVector.get(0));
                        } else if (c == 'H') {
                            this.CUP(intVector.get(0), 0);
                        } else if (c == 'm') {
                            this.SGR(intVector.get(0));
                        } else {
                            System.err.println("UNKNOWN Command:    ESC [ " + intVector.get(0) + c);
                        }
                    } else if (intVector.size() == 2) {
                        if (c == 'H' || c == 'f') {
                            this.CUP(intVector.get(0), intVector.get(1));
                        } else if (c == 'r') {
                            this.SETWIN(intVector.get(0), intVector.get(1));
                        } else if (c == 'm') {
                            this.SGR(intVector);
                        } else {
                            System.err.println("UNKNOWN Command:   ESC [ " + intVector.get(0) + ";" + intVector.get(1) + c);
                        }
                    } else if (c == 'm') {
                        this.SGR(intVector);
                    } else {
                        System.err.println("UNKNOWN Command >2: ESC [ " + intVector.get(0) + "," + intVector.get(1) + "..." + c);
                    }
                } else if (c == 'M') {
                    this.RI();
                } else if (c == '(') {
                    c = this.parseText[this.parseIndex++];
                    this.setCharacterSet(0, c);
                } else if (c == ')') {
                    c = this.parseText[this.parseIndex++];
                    this.setCharacterSet(1, c);
                } else if (c == 'c') {
                    this.resetToInitialState();
                } else if (c == '#') {
                    c = this.parseText[this.parseIndex++];
                    this.setLetterHeight(c);
                } else {
                    System.err.println("UNKNOWN COMMAND:    ESC " + c);
                }
            } else {
                this.writeChar(c);
            }
            try {
                if (n <= 0) continue;
                Thread.currentThread();
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        ++this.blinkCounter;
        if (this.blinkCounter % 2 < 1) {
            return this.plate.toString();
        }
        if (this.blinkPlate.isEmpty()) {
            return this.plate.toString();
        }
        CharacterPlate characterPlate = this.plate.getClone();
        int n = 0;
        while (n < characterPlate.getHeight()) {
            int n2 = 0;
            while (n2 < characterPlate.getWidth()) {
                if (this.blinkPlate.isSet(n2, n)) {
                    characterPlate.setForce(n2, n, ' ');
                }
                ++n2;
            }
            ++n;
        }
        return characterPlate.toString();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        TextField textField = new TextField();
        TextArea textArea = new TextArea("", 20, 80);
        textArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        frame.add((Component)textArea, "Center");
        frame.add((Component)textField, "South");
        frame.pack();
        frame.setSize(640, 450);
        frame.show();
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            int n = 0;
            int n2 = 0;
            if (stringArray.length > 1) {
                try {
                    n2 = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Syntax error in command line parameter line_pause: " + stringArray[1]);
                }
                if (stringArray.length > 2) {
                    try {
                        n = Integer.parseInt(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Syntax error in command line parameter line_pause: " + stringArray[1]);
                    }
                }
            }
            VIViewer.playFile(string, n, n2, textArea, textField);
        } else {
            int n = 0;
            while (n < FILENAMES.length) {
                String string = DIRECTORY + FILENAMES[n];
                System.err.println(" __________________________________________________");
                System.err.println("| File No." + n + " Name:" + string);
                VIViewer.playFile(string, 0, 0, textArea, textField);
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public static void playFile(String string, int n, int n2, TextArea textArea, TextField textField) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            VIViewer vIViewer = new VIViewer();
            String string2 = null;
            int n3 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                vIViewer.execute(string2, n);
                vIViewer.newLine();
                textArea.setText(vIViewer.toString());
                if (vIViewer.screenReversed) {
                    textArea.setForeground(Color.black);
                    textArea.setBackground(Color.white);
                } else {
                    textArea.setForeground(Color.white);
                    textArea.setBackground(Color.black);
                }
                textField.setText("Frame: " + n3);
                ++n3;
                try {
                    if (n2 <= 0) continue;
                    Thread.currentThread();
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }
}

