/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class LineToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;

    public LineToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Line Generic";
    }

    public String getIconName() {
        return "line_generic";
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        this.point2 = point;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.point1 = null;
        this.point2 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.getMixMode());
            this.markPlate.convert();
            this.markPlate.pasteResultInto(this.plate.getContent());
            this.saveCurrentState("draw line");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.point1 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        graphics.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        this.markPlate.clear();
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(this.point2);
        this.markPlate.drawLine(point2d, point2d2);
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.point1 = null;
        this.point2 = null;
    }

    public void putAside(boolean bl) {
        this.point1 = null;
        this.point2 = null;
    }
}

