/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.BooleanPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.SelectionTool;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class FreehandSelectionTool
extends SelectionTool {
    protected Polygon polygon;

    public FreehandSelectionTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Freehand Selection";
    }

    public String getIconName() {
        return "freehand_selection";
    }

    protected String getUndoRedoActionName() {
        return "freehand selection";
    }

    public void paintCursorFeature(Graphics graphics) {
        Point point;
        Point point2;
        if (this.polygon == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorTool);
        int[] nArray = this.polygon.xpoints;
        int[] nArray2 = this.polygon.ypoints;
        int n = this.polygon.npoints;
        int n2 = this.plate.charWidth / 2;
        int n3 = this.plate.charHeight / 2;
        int n4 = 0;
        while (n4 < n - 1) {
            point2 = this.plate.getScreenPointFor(nArray[n4], nArray2[n4]);
            point = this.plate.getScreenPointFor(nArray[n4 + 1], nArray2[n4 + 1]);
            graphics.drawLine(point2.x + n2, point2.y + n3, point.x + n2, point.y + n3);
            ++n4;
        }
        point2 = this.plate.getScreenPointFor(nArray[0], nArray2[0]);
        point = this.plate.getScreenPointFor(nArray[n - 1], nArray2[n - 1]);
        GfxTools.drawBrokenLine(graphics, point2.x + n2, point2.y + n3, point.x + n2, point.y + n3);
    }

    protected void selectionMousePressedStarted(Point point) {
        if (point == null) {
            return;
        }
        this.location1 = point;
        this.polygon = new Polygon();
        this.polygon.addPoint(point.x, point.y);
    }

    protected void selectionMouseDragged(Point point) {
        if (this.polygon == null || point == null || point.equals(this.location2)) {
            return;
        }
        this.polygon.addPoint(point.x, point.y);
        this.repaintCursor();
    }

    protected void selectionMouseReleasedFinished(Point point) {
        int n;
        if (this.polygon == null || point == null) {
            return;
        }
        this.polygon.addPoint(point.x, point.y);
        this.markPlate = new PixelPlate(point.x - 10, point.y - 10, 20, 20);
        this.markPlate.setMode(1);
        this.markPlate.set(point.x, point.y);
        this.markPlate.setCharacter('O');
        Rectangle rectangle = this.polygon.getBounds();
        int n2 = 0;
        while (n2 < rectangle.height) {
            int n3 = 0;
            while (n3 < rectangle.width) {
                if (this.polygon.contains(rectangle.x + n3, rectangle.y + n2)) {
                    this.markPlate.set(rectangle.x + n3, rectangle.y + n2);
                }
                ++n3;
            }
            ++n2;
        }
        int[] nArray = this.polygon.xpoints;
        int[] nArray2 = this.polygon.ypoints;
        int n4 = this.polygon.npoints;
        int n5 = 0;
        while (n5 < n4) {
            this.markPlate.drawLine(nArray[n5], nArray2[n5], nArray[(n5 + 1) % n4], nArray2[(n5 + 1) % n4]);
            ++n5;
        }
        ++rectangle.width;
        ++rectangle.height;
        BooleanPlate booleanPlate = new BooleanPlate(rectangle.width, rectangle.height);
        int n6 = 0;
        while (n6 < rectangle.height) {
            n = 0;
            while (n < rectangle.width) {
                if (this.plate.getContent().contains(rectangle.x + n, rectangle.y + n6) && this.markPlate.isSet(rectangle.x + n, rectangle.y + n6)) {
                    booleanPlate.set(n, n6, true);
                }
                ++n;
            }
            ++n6;
        }
        this.markPlate = null;
        if (this.mode == 10) {
            this.plate.getSelection().set(rectangle, booleanPlate);
            this.jave.updateSelectionMenu();
            this.synchronizeToSelection();
            this.repaintAll();
            this.plate.saveCurrentState("select");
        } else if (this.mode == 11) {
            n = this.plate.getSelection().add(rectangle, booleanPlate) ? 1 : 0;
            if (n == 0) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                this.plate.saveCurrentState("modify selection");
            }
        } else if (this.mode == 12) {
            n = this.plate.getSelection().remove(rectangle, booleanPlate) ? 1 : 0;
            if (n == 0) {
                this.repaintCursor();
            } else {
                this.repaintAll();
                if (this.plate.hasSelection()) {
                    this.plate.saveCurrentState("modify selection");
                } else {
                    this.plate.saveCurrentState("drop selection");
                    this.jave.switchToTextTool();
                }
            }
        }
        this.location1 = null;
        this.polygon = null;
        this.mode = 1;
        this.repaintAll();
    }

    protected void selectionCanceled() {
        this.location1 = null;
        this.polygon = null;
        this.mode = 1;
        this.repaintCursor();
    }
}

