/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.DocumentListener;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Selection;
import de.jave.undo.UndoManager;
import de.jave.util.RelativeTimeClock;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class Document {
    protected boolean modified;
    protected UndoManager undoManager;
    protected RelativeTimeClock clock;
    protected String fileName;
    protected String stopgapName;
    protected CharacterPlate content;
    protected Point scrollOrigin;
    protected Selection selection;
    protected Point cursorLocation;
    protected static int docCounter = 0;
    protected int number;
    protected int colorScheme;
    protected boolean isMovieDocument = false;
    protected Vector documentListeners;

    protected Document() {
        this(JaveGlobalRessources.getInifile().getInt("Editor", "default_width", 71), JaveGlobalRessources.getInifile().getInt("Editor", "default_height", 30));
    }

    protected Document(int n, int n2) {
        this.content = new CharacterPlate(n, n2);
        this.selection = new Selection();
        this.cursorLocation = new Point(0, 0);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setStopgapName(String string) {
        this.stopgapName = string;
    }

    public boolean isMovieDocument() {
        return this.isMovieDocument;
    }

    public void setMovieDocument(boolean bl) {
        this.isMovieDocument = bl;
    }

    public CharacterPlate getContent() {
        return this.content;
    }

    public void setContent(CharacterPlate characterPlate) {
        this.content = characterPlate;
    }

    public Point getCursorLocation() {
        return this.cursorLocation;
    }

    public void setColorScheme(int n) {
        this.colorScheme = n;
    }

    public int getColorScheme() {
        return this.colorScheme;
    }

    public synchronized void setDocumentState(CompressedDocumentState compressedDocumentState) {
        this.content.setContent(compressedDocumentState.getContent());
        this.selection.set(compressedDocumentState.getSelectionLocation(), compressedDocumentState.getSelectionContent(), compressedDocumentState.getSelectionMask());
        this.scrollOrigin = compressedDocumentState.getScrollOrigin();
        this.colorScheme = compressedDocumentState.getColorScheme();
    }

    public void setRelativeTimeClock(RelativeTimeClock relativeTimeClock) {
        this.clock = relativeTimeClock;
    }

    public RelativeTimeClock getRelativeTimeClock() {
        return this.clock;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.isEmpty();
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setScrollOrigin(Point point) {
        this.scrollOrigin = point;
    }

    public int getWidth() {
        return this.content.getWidth();
    }

    public int getHeight() {
        return this.content.getHeight();
    }

    public Point getScrollOrigin() {
        if (this.scrollOrigin != null) {
            return this.scrollOrigin;
        }
        return new Point(0, 0);
    }

    public static Document createNew() {
        return Document.createNew(JaveGlobalRessources.getInifile().getInt("Editor", "default_width", 71), JaveGlobalRessources.getInifile().getInt("Editor", "default_height", 30));
    }

    public static Document createNew(int n, int n2) {
        Document document = new Document(n, n2);
        document.number = ++docCounter;
        document.modified = false;
        document.stopgapName = "Document" + document.number;
        document.colorScheme = JaveGlobalRessources.getColorScheme();
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Document load(String string) throws IOException {
        Document document = new Document();
        document.fileName = string;
        document.modified = false;
        document.colorScheme = JaveGlobalRessources.getColorScheme();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(string2);
            }
            document.content = new CharacterPlate(stringBuffer.toString());
            Object var6_6 = null;
            if (bufferedReader == null) return document;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return document;
    }

    public void save(String string) throws IOException {
        if (string == null) {
            throw new RuntimeException("No name specified  for Document.save()!");
        }
        this.saveInternal(string);
        this.fileName = string;
        this.setModified(false);
    }

    public void save() throws IOException {
        if (this.fileName == null) {
            throw new RuntimeException("No name specified  for Document.save()!");
        }
        this.saveInternal(this.fileName);
        this.setModified(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveInternal(String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            String[] stringArray = this.content.toStringArray();
            int n = 0;
            while (n < stringArray.length - 1) {
                bufferedWriter.write(stringArray[n]);
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.write(stringArray[stringArray.length - 1]);
            bufferedWriter.close();
            JaveGlobalRessources.getRecentFileList().add(new File(string));
            Object var6_6 = null;
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedWriter == null) throw throwable;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public String toString() {
        return this.getFrameTitle();
    }

    public boolean hasFileName() {
        return this.fileName != null;
    }

    public boolean isLogging() {
        return this.undoManager.isLogging();
    }

    public String getLogFileName() {
        String string = this.undoManager.getLogFileName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getFileName() {
        if (!this.hasFileName()) {
            return "";
        }
        return this.fileName;
    }

    public String getFrameTitle() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.fileName != null) {
            stringBuffer.append(this.fileName);
        } else {
            stringBuffer.append(this.stopgapName);
        }
        if (this.isModified()) {
            stringBuffer.append(" *");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getTitle() {
        if (this.fileName == null) {
            return this.stopgapName;
        }
        int n = this.fileName.lastIndexOf("/") + 1;
        if (n == 0) {
            n = this.fileName.lastIndexOf("\\") + 1;
        }
        if (n == 0) {
            return this.fileName;
        }
        return this.fileName.substring(n);
    }

    public synchronized void addDocumentListener(DocumentListener documentListener) {
        if (this.documentListeners == null) {
            this.documentListeners = new Vector(2, 2);
        }
        this.documentListeners.addElement(documentListener);
    }

    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        this.documentListeners.removeElement(documentListener);
    }

    public void documentClosing() {
        if (this.documentListeners != null) {
            int n = 0;
            while (n < this.documentListeners.size()) {
                ((DocumentListener)this.documentListeners.elementAt(n)).documentClosing();
                ++n;
            }
        }
    }

    public void documentHiding() {
        if (this.documentListeners != null) {
            int n = 0;
            while (n < this.documentListeners.size()) {
                ((DocumentListener)this.documentListeners.elementAt(n)).documentHiding();
                ++n;
            }
        }
    }

    public void documentShowing() {
        if (this.documentListeners != null) {
            int n = 0;
            while (n < this.documentListeners.size()) {
                ((DocumentListener)this.documentListeners.elementAt(n)).documentShowing();
                ++n;
            }
        }
    }

    public void documentChanged() {
        if (this.documentListeners != null) {
            int n = 0;
            while (n < this.documentListeners.size()) {
                ((DocumentListener)this.documentListeners.elementAt(n)).documentChanged();
                ++n;
            }
        }
    }
}

