/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.FilenameTextField;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GTextArea;
import de.jave.gui.GTree;
import de.jave.gui.GTreeEntry;
import de.jave.gui.GuiTools;
import de.jave.jave.Clipart;
import de.jave.jave.ClipartGroup;
import de.jave.jave.ClipartManager;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;

public class ClipartNewEntryDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener {
    protected static final String TITLE = "Clipart - New Clipart";
    protected Jave asciiPainter;
    protected TextArea taPreview;
    protected GTree tree;
    protected Button bOK;
    protected Button bClose;
    protected Button bNewFolder;
    protected TextField tfAuthor;
    protected TextField tfSize;
    protected TextField tfName;
    protected ClipartManager clipartManager;
    protected Clipart newClipart;

    public ClipartNewEntryDialog(Jave jave, String string) {
        super(jave, TITLE, true);
        ImageObserver imageObserver;
        this.asciiPainter = jave;
        this.addWindowListener(this);
        this.newClipart = new Clipart(string);
        this.clipartManager = new ClipartManager();
        String[] stringArray = this.clipartManager.getGroupNames();
        GTreeEntry gTreeEntry = new GTreeEntry("Clipart Library", -1);
        int n = 0;
        while (n < stringArray.length) {
            imageObserver = new GTreeEntry(stringArray[n], this, 0);
            gTreeEntry.add((GTreeEntry)imageObserver);
            ++n;
        }
        gTreeEntry.expandAll(false);
        this.tree = new GTree(gTreeEntry);
        this.tree.setSize(130, 220);
        this.tree.setLabelsEditable(false);
        this.tree.addItemListener(this);
        this.tree.addActionListener(this);
        this.bNewFolder = new Button("New Category");
        this.bNewFolder.addActionListener(this);
        imageObserver = new GBorderedPanel("Choose Category:");
        ((Container)imageObserver).setLayout(new BorderLayout(5, 5));
        ((Container)imageObserver).add(this.tree, "Center");
        ((Container)imageObserver).add(this.bNewFolder, "South");
        this.taPreview = new GTextArea("", 16, 45, 0);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Preview:", -1);
        gBorderedPanel.setLayout(new BorderLayout());
        gBorderedPanel.add((Component)this.taPreview, "Center");
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Additional Clipart Information:");
        gBorderedPanel2.setLayout(new GridLayout(0, 2, 4, 4));
        gBorderedPanel2.add(new Label("Clipart Name:", 2));
        this.tfName = new TextField("", 15);
        this.tfName.setEditable(true);
        gBorderedPanel2.add(this.tfName);
        gBorderedPanel2.add(new Label("Author:", 2));
        this.tfAuthor = new TextField("", 15);
        this.tfAuthor.setEditable(true);
        gBorderedPanel2.add(this.tfAuthor);
        gBorderedPanel2.add(new Label("Size:", 2));
        this.tfSize = new TextField("", 9);
        this.tfSize.setEditable(false);
        gBorderedPanel2.add(this.tfSize);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)gBorderedPanel2, "North");
        panel.add((Component)gBorderedPanel, "Center");
        Panel panel2 = new Panel();
        this.bOK = new Button("OK");
        this.bOK.addActionListener(this);
        panel2.add(this.bOK);
        this.bClose = new Button("Cancel");
        this.bClose.addActionListener(this);
        panel2.add(this.bClose);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)imageObserver, "Center");
        this.add((Component)panel, "East");
        this.add((Component)panel2, "South");
        this.pack();
        this.taPreview.setText(TextTools.toString(JaveAsciiPacker.decode(string)));
        this.tfSize.setText(this.newClipart.getWidth() + " x " + this.newClipart.getHeight());
        GuiTools.centerOnScreen(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            this.dispose();
        } else if (object == this.bOK) {
            GTreeEntry gTreeEntry = this.tree.getSelectedItem();
            if (gTreeEntry == null) {
                new GErrorDialog((Frame)this.asciiPainter, "JavE - Clipart library", "Please choose a propriate category for the clipart.").show();
                return;
            }
            if (gTreeEntry.getUserObject() != this) {
                new GErrorDialog((Frame)this.asciiPainter, "JavE - Clipart library", "Please choose a propriate category for the clipart.").show();
                return;
            }
            String string = this.tfName.getText();
            if (string.trim().length() == 0) {
                new GErrorDialog((Frame)this.asciiPainter, "JavE - Clipart library", "Please choose a propriate name for the clipart.").show();
                return;
            }
            String string2 = this.tfAuthor.getText();
            this.newClipart.setName(string);
            this.newClipart.setAuthor(string2);
            ClipartGroup clipartGroup = this.clipartManager.getGroup(gTreeEntry.toString());
            if (clipartGroup == null) {
                clipartGroup = new ClipartGroup(gTreeEntry.toString());
            }
            clipartGroup.add(this.newClipart);
            clipartGroup.save();
            this.asciiPainter.clipartsChanged();
            this.dispose();
        } else if (object == this.bNewFolder) {
            FilenameTextField filenameTextField = new FilenameTextField("new category");
            Panel panel = new Panel();
            panel.add(new Label("Name for new Category:", 2));
            panel.add(filenameTextField);
            GDialog gDialog = new GDialog((Frame)this.asciiPainter, "JavE - Clipart library", (Component)panel, GDialog.OK_CANCEL);
            gDialog.show();
            if (gDialog.getAnswer() != 0) {
                return;
            }
            String string = filenameTextField.getText().trim().toLowerCase();
            if (string.length() < 2) {
                new GErrorDialog((Frame)this.asciiPainter, "JavE - Clipart library", "You have not entered a valid folder name.").show();
                return;
            }
            if (this.clipartManager.hasGroupName(string)) {
                new GErrorDialog((Frame)this.asciiPainter, "JavE - Clipart library", "The category '" + string + "' already exists.").show();
                return;
            }
            GTreeEntry gTreeEntry = new GTreeEntry(string, this, 0);
            this.tree.add(this.tree.getRoot(), gTreeEntry);
            this.tree.select(gTreeEntry);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

