/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GTextArea;
import de.jave.gui.GTree;
import de.jave.gui.GTreeEntry;
import de.jave.gui.GuiTools;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Clipart;
import de.jave.jave.ClipartGroup;
import de.jave.jave.ClipartManager;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Tool;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;

public class ClipartDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener {
    protected static final String TITLE = "Clipart Editor";
    protected Jave parent;
    protected TextArea taPreview;
    protected GTree tree;
    protected Button bInsertAll;
    protected Button bInsert;
    protected Button bClose;
    protected TextField tfAuthor;
    protected TextField tfSize;
    protected ClipartManager clipartManager;
    protected ClipartGroup currentGroup;
    protected Clipart currentClipart;

    public ClipartDialog(Jave jave) {
        super(jave, TITLE, false);
        Object object;
        Object object2;
        ImageObserver imageObserver;
        this.parent = jave;
        this.addWindowListener(this);
        this.clipartManager = new ClipartManager();
        String[] stringArray = this.clipartManager.getGroupNames();
        GTreeEntry gTreeEntry = new GTreeEntry("Clipart Library", -1);
        int n = 0;
        while (n < stringArray.length) {
            imageObserver = new GTreeEntry(stringArray[n], 0);
            gTreeEntry.add((GTreeEntry)imageObserver);
            object2 = this.clipartManager.getGroup(stringArray[n]);
            object = ((ClipartGroup)object2).getClipartNames();
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                GTreeEntry gTreeEntry2 = new GTreeEntry(object[n2], object2, 1);
                ((GTreeEntry)imageObserver).add(gTreeEntry2);
                ++n2;
            }
            ++n;
        }
        gTreeEntry.expandAll(false);
        this.tree = new GTree(gTreeEntry);
        this.tree.setSize(130, 220);
        this.tree.setLabelsEditable(false);
        this.tree.addItemListener(this);
        this.tree.addActionListener(this);
        imageObserver = new Panel();
        ((Container)imageObserver).setLayout(new FlowLayout());
        ((Container)imageObserver).add(new Label("Author:", 2));
        this.tfAuthor = new TextField("", 15);
        this.tfAuthor.setEditable(false);
        ((Container)imageObserver).add(this.tfAuthor);
        ((Container)imageObserver).add(new Label("Size:", 2));
        this.tfSize = new TextField("", 9);
        this.tfSize.setEditable(false);
        ((Container)imageObserver).add(this.tfSize);
        this.taPreview = new GTextArea("", 16, 45, 0);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        object2 = new GBorderedPanel("Preview:", -1);
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)this.taPreview, "Center");
        object = new Panel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)imageObserver, "North");
        ((Container)object).add((Component)object2, "Center");
        Panel panel = new Panel();
        this.bInsert = new Button("Insert");
        this.bInsert.addActionListener(this);
        panel.add(this.bInsert);
        this.bInsertAll = new Button("Insert whole category");
        this.bInsertAll.addActionListener(this);
        panel.add(this.bInsertAll);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        panel.add(this.bClose);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.tree, "Center");
        this.add((Component)object, "East");
        this.add((Component)panel, "South");
        this.pack();
        this.taPreview.setText(TextTools.toString(JaveAsciiPacker.decode("A7 3  \\-/%0J|a|v|E%0 /-\\")));
        GuiTools.centerOnScreen(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        GTreeEntry gTreeEntry = (GTreeEntry)itemEvent.getItem();
        if (gTreeEntry == null) {
            return;
        }
        this.currentGroup = (ClipartGroup)gTreeEntry.getUserObject();
        if (this.currentGroup == null) {
            return;
        }
        this.currentClipart = this.currentGroup.getClipart(gTreeEntry.getTreeLabel());
        char[][] cArray = this.currentClipart.getContent();
        this.taPreview.setText(TextTools.toString(cArray));
        this.tfAuthor.setText(this.currentClipart.getAuthor());
        this.tfSize.setText(this.currentClipart.getWidth() + " x " + this.currentClipart.getHeight());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bInsert || object == this.tree) {
            String string = this.taPreview.getText();
            this.parent.pasteAsNewSelection(string);
            this.parent.toFront();
        } else if (object == this.bClose) {
            this.setVisible(false);
            this.parent.dialogClosed(this);
        } else if (object == this.bInsertAll) {
            Object object2;
            if (this.currentGroup == null) {
                return;
            }
            int n = 0;
            int n2 = 20;
            int n3 = 0;
            while (n3 < this.currentGroup.getClipartCount()) {
                object2 = this.currentGroup.getClipart(n3);
                n += ((Clipart)object2).getHeight() + 4;
                n2 = Tool.max(n2, ((Clipart)object2).getWidth(), ((Clipart)object2).getAuthor().length() + 8, ((Clipart)object2).getName().length() + 8);
                ++n3;
            }
            --n;
            object2 = new CharacterPlate(n2, n += 3);
            ((CharacterPlate)object2).paste("Clipart group: " + this.currentGroup.getName(), 0, 0);
            ((CharacterPlate)object2).paste("contains " + this.currentGroup.getClipartCount() + " cliparts", 0, 1);
            ((CharacterPlate)object2).paste("--------------------------", 0, 2);
            int n4 = 3;
            String[] stringArray = this.currentGroup.getClipartNames();
            int n5 = 0;
            while (n5 < this.currentGroup.getClipartCount()) {
                Clipart clipart = this.currentGroup.getClipart(stringArray[n5]);
                ((CharacterPlate)object2).paste("Name  :", 0, n4);
                ((CharacterPlate)object2).paste(clipart.getName(), 8, n4);
                ((CharacterPlate)object2).paste("Author:", 0, n4 + 1);
                ((CharacterPlate)object2).paste(clipart.getAuthor(), 8, n4 + 1);
                ((CharacterPlate)object2).paste("Size  : " + clipart.getWidth() + "x" + clipart.getHeight(), 0, n4 + 2);
                ((CharacterPlate)object2).paste(clipart.getContent(), 0, n4 + 3);
                n4 += clipart.getHeight() + 4;
                ++n5;
            }
            this.parent.pasteAsNewDocument((CharacterPlate)object2, this.currentGroup.getName());
            this.parent.toFront();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.parent.dialogClosed(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

