/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.util.Toolbox;

public class AscTrisBlock {
    protected int xPos;
    protected int yPos;
    protected char[][] pattern;
    protected static final char[][][] PATTERNS = new char[][][]{new char[][]{{'#', '#', ' '}, {' ', '#', '#'}}, new char[][]{{' ', '#', '#'}, {'#', '#', ' '}}, new char[][]{{' ', ' ', ' ', ' '}, {'#', '#', '#', '#'}, {' ', ' ', ' ', ' '}}, new char[][]{{' ', ' ', '#'}, {'#', '#', '#'}, {' ', ' ', ' '}}, new char[][]{{' ', ' ', ' '}, {'#', '#', '#'}, {' ', ' ', '#'}}, new char[][]{{'#', '#'}, {'#', '#'}}, new char[][]{{' ', '#', ' '}, {'#', '#', '#'}, {' ', ' ', ' '}}};
    protected static final char[] COLORS = new char[]{'#', 'O', '8', 'M', ':', '=', 'E', 'W', 'S', 'B', 'X', 'Z'};
    public static final String GRADIENT = " :=8OSXZBEW#M";

    public AscTrisBlock() {
        int n = Toolbox.random(0, PATTERNS.length - 1);
        this.pattern = PATTERNS[n];
        int n2 = Toolbox.random(0, COLORS.length - 1);
        char c = COLORS[n2];
        int n3 = 0;
        while (n3 < this.pattern.length) {
            int n4 = 0;
            while (n4 < this.pattern[0].length) {
                if (this.pattern[n3][n4] != ' ') {
                    this.pattern[n3][n4] = c;
                }
                ++n4;
            }
            ++n3;
        }
        int n5 = Toolbox.random(0, 3);
        int n6 = 0;
        while (n6 < n5) {
            this.rotateRight();
            ++n6;
        }
    }

    public void rotateRight() {
        int n = this.pattern[0].length;
        int n2 = this.pattern.length;
        char[][] cArray = new char[n][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                cArray[n4][n2 - n3 - 1] = this.pattern[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.pattern = cArray;
    }

    public void rotateLeft() {
        int n = this.pattern[0].length;
        int n2 = this.pattern.length;
        char[][] cArray = new char[n][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                cArray[n - n4 - 1][n3] = this.pattern[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.pattern = cArray;
    }

    public boolean isInside() {
        int n = 0;
        while (n < this.pattern.length * 2) {
            int n2 = 0;
            while (n2 < this.pattern[0].length * 3) {
                if (this.yPos + n < 0 && this.pattern[n / 2][n2 / 3] != ' ') {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public boolean fits(CharacterPlate characterPlate) {
        int n = characterPlate.getWidth();
        int n2 = characterPlate.getHeight();
        int n3 = 0;
        while (n3 < this.pattern.length * 2) {
            int n4 = 0;
            while (n4 < this.pattern[0].length * 3) {
                if (this.pattern[n3 / 2][n4 / 3] != ' ') {
                    if (this.yPos + n3 >= n2) {
                        return false;
                    }
                    if (this.xPos + n4 >= n) {
                        return false;
                    }
                    if (this.xPos + n4 < 0) {
                        return false;
                    }
                    if (this.yPos + n3 >= 0 && characterPlate.get(this.xPos + n4, this.yPos + n3) != ' ') {
                        return false;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public void pasteInto(CharacterPlate characterPlate) {
        int n = this.pattern.length;
        int n2 = this.pattern[0].length;
        int n3 = 0;
        while (n3 < n * 2) {
            int n4 = 0;
            while (n4 < n2 * 3) {
                if (this.yPos + n3 >= 0 && this.pattern[n3 / 2][n4 / 3] != ' ') {
                    characterPlate.setForce(this.xPos + n4, this.yPos + n3, this.pattern[n3 / 2][n4 / 3]);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void removeFrom(CharacterPlate characterPlate) {
        int n = 0;
        while (n < this.pattern.length * 2) {
            int n2 = 0;
            while (n2 < this.pattern[0].length * 3) {
                if (this.yPos + n >= 0 && this.pattern[n / 2][n2 / 3] != ' ') {
                    characterPlate.setForce(this.xPos + n2, this.yPos + n, ' ');
                }
                ++n2;
            }
            ++n;
        }
    }

    public void moveLeft() {
        this.xPos -= 3;
    }

    public void moveRight() {
        this.xPos += 3;
    }

    public void moveUp() {
        this.yPos -= 2;
    }

    public void moveDown() {
        this.yPos += 2;
    }
}

