/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public abstract class AbstractPencilTool
extends Tool {
    protected Point cursorLocation;
    protected char[][] brush;

    public AbstractPencilTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.cursorLocation == null || this.brush == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorTool);
        this.paintBrushBorder(graphics, this.brush, this.cursorLocation.x, this.cursorLocation.y);
    }

    protected final void paintBrushBorder(Graphics graphics, char[][] cArray, int n, int n2) {
        int n3 = cArray.length;
        int n4 = cArray[0].length;
        int n5 = (n4 - 1) / 2;
        int n6 = (n3 - 1) / 2;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                if (cArray[n8][n7] != ' ' && cArray[n8][n7] != '\u0000') {
                    Point point = this.getScreenPointFor(n - n5 + n7, n2 - n6 + n8);
                    if (n7 == 0 || cArray[n8][n7 - 1] == ' ' || cArray[n8][n7 - 1] == '\u0000') {
                        graphics.drawLine(point.x, point.y, point.x, point.y + this.plate.charHeight);
                    }
                    if (n8 == 0 || cArray[n8 - 1][n7] == ' ' || cArray[n8 - 1][n7] == '\u0000') {
                        graphics.drawLine(point.x, point.y, point.x + this.plate.charWidth, point.y);
                    }
                    if (n7 == n4 - 1 || cArray[n8][n7 + 1] == ' ' || cArray[n8][n7 + 1] == '\u0000') {
                        graphics.drawLine(point.x + this.plate.charWidth, point.y, point.x + this.plate.charWidth, point.y + this.plate.charHeight);
                    }
                    if (n8 == n3 - 1 || cArray[n8 + 1][n7] == ' ' || cArray[n8 + 1][n7] == '\u0000') {
                        graphics.drawLine(point.x, point.y + this.plate.charHeight, point.x + this.plate.charWidth, point.y + this.plate.charHeight);
                    }
                }
                ++n8;
            }
            ++n7;
        }
    }

    protected void paint(Point point) {
        if (point == null) {
            return;
        }
        this.paint(point.x, point.y);
    }

    protected abstract void paint(int var1, int var2);

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.cursorLocation = point2;
        this.paint(point2);
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        if (this.cursorLocation != null && this.cursorLocation.equals(point2)) {
            return;
        }
        if (this.cursorLocation == null) {
            this.paint(point2);
        } else {
            this.paintLineBresenham(this.cursorLocation.x, this.cursorLocation.y, point2.x, point2.y);
        }
        this.cursorLocation = point2;
        this.repaintCursor();
        this.showCoordinates(point2);
    }

    protected void paintLineBresenham(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = n3 - n;
        int n9 = n4 - n2;
        int n10 = 1;
        int n11 = 1;
        if (n8 < 0) {
            n10 = -1;
            n8 = -n8;
        }
        if (n9 < 0) {
            n11 = -1;
            n9 = -n9;
        }
        if (n9 <= n8) {
            int n12 = 2 * n8;
            int n13 = 2 * n9;
            while (true) {
                this.paint(n5, n6);
                if (n5 != n3) {
                    n5 += n10;
                    if ((n7 += n13) <= n8) continue;
                    n6 += n11;
                    n7 -= n12;
                    continue;
                }
                break;
            }
        } else {
            int n14 = 2 * n9;
            int n15 = 2 * n8;
            while (true) {
                this.paint(n5, n6);
                if (n6 == n4) break;
                n6 += n11;
                if ((n7 += n15) <= n9) continue;
                n5 += n10;
                n7 -= n14;
            }
        }
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
        super.mouseMoved(point, point2, mouseEvent);
        if (this.cursorLocation != null && this.cursorLocation.equals(point2)) {
            return;
        }
        this.cursorLocation = point2;
        this.repaintCursor();
    }

    protected abstract String getUndoRedoActionName();

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        this.plate.saveCurrentState(this.getUndoRedoActionName());
    }

    public void mouseExited(Point point, Point point2, MouseEvent mouseEvent) {
        super.mouseExited(point, point2, mouseEvent);
        this.cursorLocation = null;
        this.repaintCursor();
    }
}

