/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image;

import de.jave.image.GImage;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

public class ImageCanvas2
extends Canvas {
    public Image image;
    public GImage gImage;
    protected int widthLimit = -1;
    protected int heightLimit = -1;

    public ImageCanvas2(Image image) {
        this.image = image;
    }

    public ImageCanvas2(GImage gImage) {
        this.gImage = gImage;
    }

    public ImageCanvas2() {
        this.image = null;
    }

    public ImageCanvas2(String string) {
        this.setImage(string);
    }

    public void clear() {
        this.image = null;
        this.gImage = null;
        this.repaint();
    }

    public void setImage(URL uRL) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.image = toolkit.getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.invalidate();
        this.repaint();
    }

    public void setImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.image = toolkit.getImage(string);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.invalidate();
        this.repaint();
    }

    public void setImage(Image image) {
        this.gImage = null;
        this.image = image;
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
        this.repaint();
    }

    public void setImage(GImage gImage) {
        this.image = null;
        this.gImage = gImage;
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.doLayout();
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.image == null && this.gImage == null) {
            int n = 100;
            int n2 = 100;
            if (this.widthLimit != -1) {
                n = this.widthLimit;
            }
            if (this.heightLimit != -1) {
                n2 = this.heightLimit;
            }
            return new Dimension(n, n2);
        }
        if (this.image == null) {
            return new Dimension(this.gImage.getWidth() + 2, this.gImage.getHeight() + 2);
        }
        int n = this.image.getWidth(this) + 2;
        int n3 = this.image.getHeight(this) + 2;
        if (this.widthLimit > 0 && n > this.widthLimit) {
            n = this.widthLimit;
        }
        if (this.heightLimit > 0 && n3 > this.heightLimit) {
            n3 = this.heightLimit;
        }
        return new Dimension(n, n3);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Image getImage() {
        return this.image;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        if (this.image != null) {
            int n = this.image.getWidth(this);
            int n2 = this.image.getHeight(this);
            if (n > dimension.width - 2) {
                n = dimension.width - 2;
            }
            if (n2 > dimension.height - 2) {
                n2 = dimension.height - 2;
            }
            int n3 = 1 + (dimension.width - 2 - n) / 2;
            int n4 = 1 + (dimension.height - 2 - n2) / 2;
            ImageCanvas2.fillBorder(graphics, dimension, n3, n4, n, n2);
            ImageCanvas2.paint3dBorder(graphics, n3 - 1, n4 - 1, n + 1, n2 + 1);
            graphics.drawImage(this.image, n3, n4, n, n2, this);
        } else if (this.gImage != null) {
            int n = this.gImage.getWidth();
            int n5 = this.gImage.getHeight();
            int n6 = 1 + (dimension.width - 2 - n) / 2;
            int n7 = 1 + (dimension.height - 2 - n5) / 2;
            ImageCanvas2.fillBorder(graphics, dimension, n6, n7, n, n5);
            ImageCanvas2.paint3dBorder(graphics, n6 - 1, n7 - 1, n + 1, n5 + 1);
            Image image = this.createImage(n, n5);
            Graphics graphics2 = image.getGraphics();
            this.gImage.paint(graphics2, 0, 0);
            graphics.drawImage(image, n6, n7, this);
        } else {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            ImageCanvas2.paint3dBorder(graphics, 0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(1, 1, dimension.width - 2, dimension.height - 2);
            graphics.drawLine(dimension.width - 2, 1, 1, dimension.height - 2);
        }
    }

    protected static final void fillBorder(Graphics graphics, Dimension dimension, int n, int n2, int n3, int n4) {
        graphics.fillRect(0, 0, dimension.width, n2 - 1);
        graphics.fillRect(0, n2 + n4 + 1, dimension.width, dimension.height - n2 - n4 - 2);
        graphics.fillRect(0, n2 - 1, n - 1, n4 + 2);
        graphics.fillRect(n + n3 + 1, n2 - 1, dimension.width - n - n3 - 1, n4 + 2);
    }

    protected static final void paint3dBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
    }

    public int getHeightLimit() {
        return this.heightLimit;
    }

    public void setHeightLimit(int n) {
        this.heightLimit = n;
    }

    public int getWidthLimit() {
        return this.widthLimit;
    }

    public void setWidthLimit(int n) {
        this.widthLimit = n;
    }
}

