/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GuiTools;
import de.jave.gui.SystemExitWindowListener;
import de.jave.internet.InternetTools;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;

public class GHyperlink
extends Canvas
implements MouseListener {
    protected URL url;
    protected String label;
    protected boolean pressed;
    public static final Color COLOR_LINK = Color.blue;
    public static final Color COLOR_LINK_PRESSED = new Color(0, 0, 160);
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int alignment = 0;

    public GHyperlink() {
        this((URL)null, "", 0);
    }

    public GHyperlink(int n) {
        this((URL)null, "", n);
    }

    public GHyperlink(String string) {
        this(string, 0);
    }

    public GHyperlink(String string, int n) {
        this.alignment = n;
        this.setURL(string);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public void setURL(String string) {
        if (string == null || string.length() == 0) {
            this.url = null;
            this.label = "";
        } else {
            try {
                this.url = new URL(string);
                this.label = this.url.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                this.label = malformedURLException.toString();
            }
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
        this.repaint();
    }

    public void setURL(String string, String string2) {
        this.label = string2;
        if (string == null || string.length() == 0) {
            this.url = null;
        } else {
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.label = malformedURLException.toString();
            }
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
        this.repaint();
    }

    public GHyperlink(String string, String string2) {
        this(string, string2, 0);
    }

    public GHyperlink(String string, String string2, int n) {
        this.alignment = n;
        this.label = string2;
        this.setURL(string, string2);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public GHyperlink(URL uRL) {
        this(uRL, uRL.toExternalForm());
    }

    public GHyperlink(URL uRL, int n) {
        this(uRL, uRL.toExternalForm(), n);
    }

    public GHyperlink(URL uRL, String string) {
        this(uRL, string, 0);
    }

    public GHyperlink(URL uRL, String string, int n) {
        this.alignment = n;
        this.label = string;
        this.url = uRL;
        this.addMouseListener(this);
        this.pressed = false;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.label);
        return new Dimension(n + 3, 15);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension;
        if (this.label == null || this.label.length() == 0) {
            return;
        }
        if (this.pressed) {
            graphics.setColor(COLOR_LINK_PRESSED);
        } else {
            graphics.setColor(COLOR_LINK);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.label);
        int n2 = 0;
        if (this.alignment == 0) {
            n2 = 1;
        } else if (this.alignment == 2) {
            dimension = this.getSize();
            n2 = dimension.width - n;
        } else if (this.alignment == 1) {
            dimension = this.getSize();
            n2 = (dimension.width - n) / 2;
        }
        int n3 = 11;
        Dimension dimension2 = this.getSize();
        graphics.drawString(this.label, n2, n3 += (dimension2.height - 15 + 1) / 2);
        graphics.drawLine(n2, n3 + 1, n2 + n - 1, n3 + 1);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.url != null) {
            this.pressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
            Applet applet = GuiTools.getParentApplet(this);
            if (applet != null) {
                applet.getAppletContext().showDocument(this.url, "_blank");
            } else {
                try {
                    InternetTools.launchBrowser(this.url);
                }
                catch (SecurityException securityException) {
                    System.err.println(securityException);
                    return;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addWindowListener(SystemExitWindowListener.instance());
        frame.setLayout(new FlowLayout());
        frame.add(new GHyperlink("http://www.jave.de"));
        frame.add(new GHyperlink("mailto:markus@jave.de?subject=ups&body=was", "markus@jave.de"));
        frame.pack();
        frame.show();
    }
}

