/*
 * Decompiled with CFR 0.152.
 */
package de.jave.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntVector
implements Cloneable,
Serializable {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public IntVector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new int[n];
        this.capacityIncrement = n2;
    }

    public IntVector(int n) {
        this(n, 0);
    }

    public IntVector() {
        this(10);
    }

    public synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            int[] nArray = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized void ensureCapacity(int n) {
        this.ensureCapacityHelper(n);
    }

    private void ensureCapacityHelper(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new int[n3];
            System.arraycopy(nArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacityHelper(n);
        } else {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = 0;
                ++n2;
            }
        }
        this.elementCount = n;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < IntVector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                IntVector intVector = IntVector.this;
                synchronized (intVector) {
                    block4: {
                        if (this.count >= IntVector.this.elementCount) break block4;
                        Integer n = new Integer(IntVector.this.elementData[this.count++]);
                        return n;
                    }
                }
                throw new NoSuchElementException("IntVector Enumeration");
            }
        };
    }

    public boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public synchronized int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this.elementCount) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (n == this.elementData[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public synchronized int elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public synchronized void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = n;
    }

    public synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0;
    }

    public synchronized void insertElementAt(int n, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = n;
        ++this.elementCount;
    }

    public synchronized void addElement(int n) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = n;
    }

    public synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = 0;
            ++n;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            IntVector intVector = (IntVector)super.clone();
            intVector.elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, intVector.elementData, 0, this.elementCount);
            return intVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized int[] toArray() {
        int[] nArray = new int[this.elementCount];
        System.arraycopy(this.elementData, 0, nArray, 0, this.elementCount);
        return nArray;
    }

    public synchronized int[] toArray(int[] nArray) {
        if (nArray.length < this.elementCount) {
            nArray = new int[this.elementCount];
        }
        System.arraycopy(this.elementData, 0, nArray, 0, this.elementCount);
        if (nArray.length > this.elementCount) {
            nArray[this.elementCount] = 0;
        }
        return nArray;
    }

    public synchronized int get(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.elementData[n];
    }

    public synchronized int set(int n, int n2) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this.elementData[n];
        this.elementData[n] = n2;
        return n3;
    }

    public synchronized boolean add(int n) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = n;
        return true;
    }

    public void add(int n, int n2) {
        this.insertElementAt(n2, n);
    }

    public synchronized int remove(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementData[n];
        int n3 = this.elementCount - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n3);
        }
        this.elementData[--this.elementCount] = 0;
        return n2;
    }

    public void clear() {
        this.removeAllElements();
    }

    protected void removeRange(int n, int n2) {
        int n3 = this.elementCount - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.get(n));
            if (n < this.size() - 1) {
                stringBuffer.append(';');
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

