/*
 * Decompiled with CFR 0.152.
 */
package de.jave.util;

import de.jave.util.RecentFileList;
import de.jave.util.Toolbox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class Inifile {
    private Hashtable sections;
    private File file;
    private static final String RECENT_FILE_LIST = "Recent File List";
    protected RecentFileList recentFileList;

    public Inifile(String string) {
        String string2 = string;
        if (!string2.endsWith(".ini")) {
            string2 = string2 + ".ini";
        }
        this.file = new File(string2);
        this.sections = new Hashtable(30);
    }

    public static void main(String[] stringArray) {
        Inifile inifile = new Inifile("testinifile");
        inifile.load();
        RecentFileList recentFileList = inifile.getRecentFileList();
        recentFileList.print();
        inifile.put("Sektion1", "wert1", true);
        inifile.put("Sektion1", "wert2", 20);
        inifile.put("Sektion2", "value1", 'c');
        inifile.put("Sektion2", "value3", "Hallo Ihr da \"draussen\"!");
        inifile.put("Sektion2", "value2", 0x7FFFFFFEL);
        RecentFileList recentFileList2 = new RecentFileList();
        recentFileList2.add(new File("Hallo1.txt"));
        recentFileList2.add(new File("Hallo2.txt"));
        recentFileList2.add(new File("Hallo2.txt"));
        recentFileList2.add(new File("Hallo3.txt"));
        recentFileList2.add(new File("Hallo4.txt"));
        recentFileList2.add(new File("Hallo5.txt"));
        recentFileList2.add(new File("Hallo6.txt"));
        recentFileList2.add(new File("Hallo7.txt"));
        recentFileList2.delete(new File("Hallo4.txt"));
        inifile.put(recentFileList2);
        inifile.save();
    }

    public long getLong(String string, String string2) {
        return this.getLong(string, string2, -1L);
    }

    public long getLong(String string, String string2, long l) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return l;
        }
        long l2 = 0L;
        try {
            l2 = new Long(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no long: [" + string + "] " + string2 + " = " + string3);
            return l;
        }
        return l2;
    }

    public short getShort(String string, String string2) {
        return this.getShort(string, string2, (short)-1);
    }

    public short getShort(String string, String string2, short s) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return s;
        }
        short s2 = 0;
        try {
            s2 = new Short(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no short: [" + string + "] " + string2 + " = " + string3);
            return s;
        }
        return s2;
    }

    public float getFloat(String string, String string2) {
        return this.getFloat(string, string2, 0.0f);
    }

    public float getFloat(String string, String string2, float f) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return f;
        }
        float f2 = 0.0f;
        try {
            f2 = new Float(string3).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no float: [" + string + "] " + string2 + " = " + string3);
            return f;
        }
        return f2;
    }

    public double getDouble(String string, String string2) {
        return this.getDouble(string, string2, 0.0);
    }

    public double getDouble(String string, String string2, double d) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return d;
        }
        double d2 = 0.0;
        try {
            d2 = new Double(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no double: [" + string + "] " + string2 + " = " + string3);
            return d;
        }
        return d2;
    }

    public byte getByte(String string, String string2) {
        return this.getByte(string, string2, (byte)0);
    }

    public byte getByte(String string, String string2, byte by) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return by;
        }
        byte by2 = 0;
        try {
            by2 = new Byte(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no byte: [" + string + "] " + string2 + " = " + string3);
            return by;
        }
        return by2;
    }

    public int getInt(String string, String string2) {
        return this.getInt(string, string2, -1);
    }

    public int getInt(String string, String string2, int n) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("no integer: [" + string + "] " + string2 + " = " + string3);
            return n;
        }
        return n2;
    }

    public String getString(String string, String string2) {
        return this.getString(string, string2, "");
    }

    public String getString(String string, String string2, String string3) {
        String string4 = (String)this.getValue(string, string2);
        if (string4 == null) {
            return string3;
        }
        string4 = Toolbox.urlDecoder(string4);
        return string4;
    }

    public boolean getBool(String string, String string2) {
        return this.getBool(string, string2, false);
    }

    public boolean getBool(String string, String string2, boolean bl) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null || string3.length() < 1) {
            return bl;
        }
        if (string3.charAt(0) == '1') {
            return true;
        }
        if (string3.charAt(0) == '0') {
            return false;
        }
        return bl;
    }

    public char getChar(String string, String string2) {
        return this.getChar(string, string2, ' ');
    }

    public char getChar(String string, String string2, char c) {
        String string3 = (String)this.getValue(string, string2);
        if (string3 == null || string3.length() < 1) {
            return c;
        }
        return string3.charAt(0);
    }

    private Object getValue(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.sections.get(string);
        return hashtable == null ? null : hashtable.get(string2);
    }

    private Object getValue(String string, String string2, Object object) {
        Object object2 = this.getValue(string, string2);
        return object2 == null ? object : object2;
    }

    public void remove(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.sections.get(string);
        if (hashtable != null) {
            hashtable.remove(string2);
        }
    }

    public void remove(String string) {
        Hashtable hashtable = (Hashtable)this.sections.get(string);
        if (hashtable != null) {
            this.sections.remove(string);
        }
    }

    private void setValue(String string, String string2, Object object) {
        Hashtable<String, Object> hashtable = (Hashtable<String, Object>)this.sections.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>(10);
            hashtable.put(string2, object);
            this.sections.put(string, hashtable);
            return;
        }
        hashtable.put(string2, object);
    }

    public void put(String string, String string2, boolean bl) {
        if (bl) {
            this.setValue(string, string2, "1");
        } else {
            this.setValue(string, string2, "0");
        }
    }

    public void put(String string, String string2, char c) {
        this.setValue(string, string2, String.valueOf(c));
    }

    public void put(String string, String string2, byte by) {
        this.setValue(string, string2, String.valueOf(by));
    }

    public void put(String string, String string2, short s) {
        this.setValue(string, string2, String.valueOf(s));
    }

    public void put(String string, String string2, int n) {
        this.setValue(string, string2, String.valueOf(n));
    }

    public void put(String string, String string2, long l) {
        this.setValue(string, string2, String.valueOf(l));
    }

    public void put(String string, String string2, float f) {
        this.setValue(string, string2, String.valueOf(f));
    }

    public void put(String string, String string2, double d) {
        this.setValue(string, string2, String.valueOf(d));
    }

    public void put(String string, String string2, String string3) {
        String string4 = new String(string3);
        string4 = URLEncoder.encode(string4);
        this.setValue(string, string2, string4);
    }

    public void put(RecentFileList recentFileList) {
        File[] fileArray = recentFileList.getFiles();
        this.remove(RECENT_FILE_LIST);
        int n = 0;
        while (n < fileArray.length) {
            this.put(RECENT_FILE_LIST, "File" + (n + 1), fileArray[n].toString());
            ++n;
        }
        this.put(RECENT_FILE_LIST, "maxSize", recentFileList.getMaxSize());
        this.put(RECENT_FILE_LIST, "size", fileArray.length);
    }

    public RecentFileList getRecentFileList() {
        if (this.recentFileList != null) {
            return this.recentFileList;
        }
        this.recentFileList = new RecentFileList();
        int n = this.getInt(RECENT_FILE_LIST, "size");
        if (n == -1) {
            return this.recentFileList;
        }
        int n2 = this.getInt(RECENT_FILE_LIST, "maxSize");
        this.recentFileList.setMaxSize(n2);
        int n3 = n - 1;
        while (n3 >= 0) {
            this.recentFileList.add(new File(this.getString(RECENT_FILE_LIST, "File" + (n3 + 1))));
            --n3;
        }
        this.recentFileList.check();
        return this.recentFileList;
    }

    public void save() {
        Object object;
        if (this.recentFileList != null) {
            int n = this.recentFileList.getMaxSize();
            int n2 = this.recentFileList.getSize();
            object = this.recentFileList.getFiles();
            this.put(RECENT_FILE_LIST, "maxSize", n);
            this.put(RECENT_FILE_LIST, "size", n2);
            int n3 = n2 - 1;
            while (n3 >= 0) {
                this.put(RECENT_FILE_LIST, "File" + (n3 + 1), ((File)object[n3]).getAbsolutePath());
                --n3;
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file));
            Enumeration enumeration = this.sections.keys();
            while (enumeration.hasMoreElements()) {
                Object object2 = enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.sections.get(object2);
                object = hashtable.keys();
                if (object.hasMoreElements()) {
                    bufferedWriter.write("[" + object2 + "]");
                    bufferedWriter.newLine();
                }
                while (object.hasMoreElements()) {
                    object2 = object.nextElement();
                    bufferedWriter.write(object2 + "=" + hashtable.get(object2));
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in Inifile.save()");
        }
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            String string = "";
            boolean bl = false;
            while (!bl && string != null) {
                int n;
                int n2 = string.indexOf("[");
                int n3 = string.indexOf("]");
                while (n2 < 0 && n3 < 1 && string != null) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        bl = true;
                        continue;
                    }
                    n = string.indexOf(59);
                    if (n != -1) {
                        string = string.substring(0, n).trim();
                    }
                    n2 = string.indexOf("[");
                    n3 = string.indexOf("]");
                }
                if (bl) continue;
                String string2 = string.substring(n2 + 1, n3);
                Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
                string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                } else {
                    n = string.indexOf(59);
                    if (n != -1) {
                        string = string.substring(0, n).trim();
                    }
                }
                while (!bl && string.indexOf("[") == -1) {
                    n2 = string.indexOf("=");
                    if (n2 > -1) {
                        String string3 = string.substring(0, n2);
                        String string4 = string.substring(n2 + 1).trim();
                        hashtable.put(string3, string4);
                    }
                    if ((string = bufferedReader.readLine()) == null) {
                        bl = true;
                        continue;
                    }
                    n = string.indexOf(59);
                    if (n == -1) continue;
                    string = string.substring(0, n).trim();
                }
                this.sections.put(string2, hashtable);
            }
            bufferedReader.close();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException + " in Inifile.load()");
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in Inifile.load()");
        }
    }
}

