/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.gui.GChoice;
import de.jave.gui.GGridLayout;
import de.jave.gui.GSliderArrangement;
import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.algorithm.BrightnessOptions;
import de.jave.jave.algorithm.JaveAlgorithmOptionsPanel;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class BrightnessOptionsPanel
extends JaveAlgorithmOptionsPanel
implements AdjustmentListener,
ItemListener {
    protected GSliderArrangement slaNewBrightness;
    protected GChoice chTable;
    protected GChoice chAlgo;
    protected BrightnessOptions options;

    public BrightnessOptionsPanel(BrightnessOptions brightnessOptions) {
        this.options = brightnessOptions;
        brightnessOptions.setChar('X');
        this.slaNewBrightness = new GSliderArrangement("New brightness:", -20, 20, 0, 1, 20);
        this.slaNewBrightness.addAdjustmentListener(this);
        this.chTable = AsciiGreyscaleTable.createComponent();
        this.chTable.addItemListener(this);
        this.chAlgo = new GChoice(new String[]{"1 Pixel per character", "4 Pixels per character", "Random delete/set"});
        this.chAlgo.addItemListener(this);
        brightnessOptions.setGreyscaleTableName(this.chTable.getSelectedItem());
        this.setLayout(new GGridLayout(3, 0));
        this.add(this.slaNewBrightness);
        this.add(this.chTable);
        this.add(this.chAlgo);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        double d = this.slaNewBrightness.getDValue();
        this.options.setFactor(d);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chTable) {
            String string = this.chTable.getSelectedItem();
            this.options.setGreyscaleTableName(string);
        } else {
            int n = this.chAlgo.getSelectedIndex();
            this.options.setAlgorithm(n);
        }
    }
}

