/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.BooleanPlate;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.BrightnessOptions;
import de.jave.jave.algorithm.JaveAlgorithmOptions;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.util.Random;

public class Brightness
extends JaveOptionsAlgorithm {
    private static Brightness instance;
    protected BrightnessOptions options;

    private Brightness() {
    }

    public static synchronized Brightness getInstance() {
        if (instance == null) {
            instance = new Brightness();
        }
        return instance;
    }

    public void setOptions(JaveAlgorithmOptions javeAlgorithmOptions) {
        this.options = (BrightnessOptions)javeAlgorithmOptions;
    }

    public JaveAlgorithmOptions getOptions() {
        if (this.options == null) {
            this.options = new BrightnessOptions();
        }
        return this.options;
    }

    public String getActionName() {
        return "brightness";
    }

    public String getMenuItemLabel() {
        return "Brightness...";
    }

    public String getOptionsDialogTitle() {
        return "Brightness Tool";
    }

    public JaveSelection apply(JaveSelection javeSelection) {
        double d = this.options.getFactor();
        int n = this.options.getAlgorithm();
        String string = this.options.getGreyscaleTableName();
        char c = this.options.getChar();
        if (d == 0.0 || string == null) {
            return javeSelection;
        }
        int n2 = javeSelection.getWidth();
        int n3 = javeSelection.getHeight();
        CharacterPlate characterPlate = javeSelection.getContent();
        BooleanPlate booleanPlate = javeSelection.getMask();
        CharacterPlate characterPlate2 = new CharacterPlate(n2, n3);
        AsciiGreyscaleTable asciiGreyscaleTable = AsciiGreyscaleTable.getTable(string);
        switch (n) {
            case 0: {
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (booleanPlate == null || booleanPlate.isSet(n5, n4)) {
                            char c2 = characterPlate.get(n5, n4);
                            int n6 = asciiGreyscaleTable.getBrightnessForChar(c2);
                            characterPlate2.set(n5, n4, asciiGreyscaleTable.getCharForBrightness(n6 += (int)(d * 255.0)));
                        }
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 1: {
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = 0;
                    while (n8 < n2) {
                        if (booleanPlate == null || booleanPlate.isSet(n8, n7)) {
                            char c3 = characterPlate.get(n8, n7);
                            char[] cArray = asciiGreyscaleTable.getBrightness4ForChar(c3);
                            int n9 = 0;
                            while (n9 < 4) {
                                int n10 = cArray[n9] + (int)(d * 255.0);
                                if (n10 > 255) {
                                    n10 = 255;
                                } else if (n10 < 0) {
                                    n10 = 0;
                                }
                                cArray[n9] = (char)n10;
                                ++n9;
                            }
                            characterPlate2.set(n8, n7, asciiGreyscaleTable.getCharForBrightness(cArray));
                        }
                        ++n8;
                    }
                    ++n7;
                }
                break;
            }
            case 2: {
                Random random = new Random(n2 * n3, 100);
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = 0;
                    while (n12 < n2) {
                        if (booleanPlate == null || booleanPlate.isSet(n12, n11)) {
                            double d2 = (double)random.getRandom() / 100.0;
                            if (d > 0.0 && d2 > d) {
                                characterPlate2.set(n12, n11, characterPlate.get(n12, n11));
                            } else if (d < 0.0) {
                                if (d2 > -d) {
                                    characterPlate2.set(n12, n11, characterPlate.get(n12, n11));
                                } else {
                                    characterPlate2.set(n12, n11, c);
                                }
                            }
                        }
                        ++n12;
                    }
                    ++n11;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm id in Brightness!");
            }
        }
        javeSelection.setContent(characterPlate2);
        javeSelection.setMask(booleanPlate);
        return javeSelection;
    }
}

