/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.GeneralAlgorithm;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ScreenSaver
extends Window
implements MouseListener,
MouseMotionListener,
KeyListener,
Runnable {
    protected int mode = 2;
    protected int charWidth;
    protected int charHeight;
    protected int plateWidth;
    protected int plateHeight;
    protected boolean shallStop;
    private Dimension offDimension;
    private Image offImage;
    private Graphics offGraphics;
    protected PixelPlate pixelPlate1;
    protected PixelPlate pixelPlate2;
    protected boolean active = false;

    public ScreenSaver(Frame frame) {
        super(frame);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.charWidth = this.getFontMetrics(this.getFont()).stringWidth("#");
        this.charHeight = (int)Math.round(13.919999999999998);
        Dimension dimension = this.getPreferredSize();
        this.plateWidth = dimension.width / this.charWidth;
        this.plateHeight = dimension.height / this.charHeight;
        this.init();
        this.pack();
        this.show();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.shallStop = false;
        Thread thread = new Thread(this);
        thread.start();
        this.requestFocus();
    }

    public void run() {
        while (!this.shallStop) {
            this.step();
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.active = true;
        }
    }

    public void init() {
        this.pixelPlate1 = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        this.pixelPlate2 = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        this.pixelPlate1.setMode(this.mode);
        this.pixelPlate2.setMode(this.mode);
        int n = this.pixelPlate1.getVirtualWidth();
        int n2 = this.pixelPlate1.getVirtualHeight();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                if (Math.random() > 0.6) {
                    this.pixelPlate1.set(n4, n3);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void step() {
        int n = this.pixelPlate1.getVirtualWidth();
        int n2 = this.pixelPlate1.getVirtualHeight();
        this.pixelPlate2.clear();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.countNeighBours(n4, n3);
                double d = Math.random();
                if (d < 0.05) {
                    ++n5;
                }
                if (this.pixelPlate1.isSet(n4, n3)) {
                    if (n5 != 0 && n5 != 1 && n5 < 4) {
                        this.pixelPlate2.set(n4, n3);
                    }
                } else if (n5 == 3) {
                    this.pixelPlate2.set(n4, n3);
                }
                if (n5 > 1 && d < 0.001) {
                    this.pixelPlate2.set(n4, n3);
                }
                ++n4;
            }
            ++n3;
        }
        this.pixelPlate2.convert();
        PixelPlate pixelPlate = this.pixelPlate1;
        this.pixelPlate1 = this.pixelPlate2;
        this.pixelPlate2 = pixelPlate;
        this.repaint();
    }

    public int countNeighBours(int n, int n2) {
        int n3 = 0;
        if (this.pixelPlate1.isSet(n - 1, n2)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n, n2 + 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n - 1, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n - 1, n2 + 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2 + 1)) {
            ++n3;
        }
        return n3;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
            this.offDimension = new Dimension(dimension.width, dimension.height);
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(this.getForeground());
        CharacterPlate characterPlate = this.pixelPlate1.getResult();
        GeneralAlgorithm.replace(characterPlate, '\u0000', ' ');
        char[][] cArray = characterPlate.getContent();
        int n = 0;
        while (n < this.plateHeight) {
            this.offGraphics.drawString(new String(cArray[n]), 2, 2 + n * this.charHeight + this.charHeight * 3 / 4);
            ++n;
        }
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    public void quit() {
        if (!this.active) {
            return;
        }
        this.shallStop = true;
        this.dispose();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.quit();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.quit();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.quit();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.quit();
    }

    public Dimension getPreferredSize() {
        return this.getToolkit().getScreenSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.pack();
        frame.show();
        PixelPlate.init();
        ScreenSaver screenSaver = new ScreenSaver(frame);
    }
}

