/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GGridLayout2;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class LineToolAlgorithmic
extends Tool {
    protected Point point1;
    protected Point point2;
    protected Choice chMode;
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;

    public LineToolAlgorithmic(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Line Algorithmic";
    }

    public String getIconName() {
        return "line";
    }

    public boolean isMix() {
        if (this.cbMix == null) {
            return true;
        }
        return this.cbMix.getState();
    }

    public Component createOptionsComponent() {
        this.chMode = new Choice();
        int n = 0;
        while (n < LineAlgorithm.STR_STYLE.length) {
            this.chMode.addItem(LineAlgorithm.STR_STYLE[n]);
            ++n;
        }
        this.chMode.select(0);
        this.chMode.addItemListener(this);
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout2(0, 1, 2, 2));
        panel.add(this.chMode);
        panel.add(this.cbMix);
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        Tool.shiftDown = false;
    }

    public void putAside(boolean bl) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        this.markPlate.setMode(1);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            this.point2 = null;
            this.repaintCursor();
            return;
        }
        if (point.equals(this.point2)) {
            return;
        }
        this.point2 = point;
        Tool.shiftDown = mouseEvent.isShiftDown();
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || point == null || point2 == null) {
            return;
        }
        if (this.markPlate != null) {
            this.setMixMode(this.cbMix.getState());
            this.markPlate.pasteResultInto(this.plate.getContent());
            this.saveCurrentState("draw line");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.markPlate == null) {
            return;
        }
        if (n == 27) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
            return;
        }
        if (n == 38 && this.point1 != null) {
            --this.point1.y;
            this.repaintCursor();
            return;
        }
        if (n == 40 && this.point1 != null) {
            ++this.point1.y;
            this.repaintCursor();
            return;
        }
        if (n == 37 && this.point1 != null) {
            --this.point1.x;
            this.repaintCursor();
            return;
        }
        if (n == 39 && this.point1 != null) {
            ++this.point1.x;
            this.repaintCursor();
            return;
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.markPlate == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
        int n = this.chMode.getSelectedIndex();
        this.markPlate.clear();
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(this.point2);
        point2d.x -= 0.5;
        point2d.y -= 0.5;
        point2d2.x -= 0.5;
        point2d2.y -= 0.5;
        if (n != 7) {
            LineAlgorithm.drawLine(this.markPlate, point2d.x, point2d.y, point2d2.x, point2d2.y, n, Tool.shiftDown);
        } else {
            LineAlgorithm.drawLineBresenham(this.markPlate, (int)Math.round(point2d.x), (int)Math.round(point2d.y), (int)Math.round(point2d2.x), (int)Math.round(point2d2.y), this.getMouseChar());
        }
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, false);
    }
}

