/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveGlobalRessources;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.io.File;

public class ImageDia
extends Canvas
implements MouseListener {
    protected Image image;
    protected File file;
    protected String label;
    protected int width = 80;
    protected int height = 60;
    protected boolean selected;
    protected int fileWidth;
    protected int fileHeight;
    protected static final int DEFAULT_WIDTH = 110;
    protected static final int DEFAULT_HEIGHT = 120;
    transient ActionListener actionListener;
    protected double proportion = 1.0;

    public ImageDia(Image image, File file, String string) {
        this(image, file, string, 110, 120, -1, -1);
    }

    public ImageDia(Image image, File file, String string, int n, int n2) {
        this(image, file, string, 110, 120, n, n2);
    }

    public ImageDia(Image image, File file, String string, int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.image = image;
        this.file = file;
        this.label = string;
        this.selected = false;
        this.fileWidth = n3;
        this.fileHeight = n4;
        this.addMouseListener(this);
    }

    public void setProportion(double d) {
        this.proportion = d;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static Dimension getPreferredImageSize() {
        return new Dimension(102, 101);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public File getFile() {
        return this.file;
    }

    public void setSelected(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.selected = bl;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this);
    }

    public void paint(Graphics graphics, ImageObserver imageObserver) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        this.paintBackground(graphics, dimension);
        int n3 = dimension.width - 9;
        int n4 = dimension.height - 19;
        int n5 = dimension.width / 2 - 1;
        int n6 = (dimension.height - 13) / 2 + 1;
        if (this.image == null) {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n5 - n3 / 2, n6 - n4 / 2, n5 + n3 / 2, n6 + n4 / 2);
            graphics.drawLine(n5 - n3 / 2, n6 + n4 / 2, n5 + n3 / 2, n6 - n4 / 2);
        } else {
            n2 = (int)(this.proportion * (double)this.image.getWidth(imageObserver));
            n = this.image.getHeight(imageObserver);
            if (n2 <= n3 && n <= n4) {
                n3 = n2;
                n4 = n;
            } else {
                double d = (double)n3 / (double)n2;
                double d2 = (double)n4 / (double)n;
                double d3 = d < d2 ? d : d2;
                n3 = (int)((double)n2 * d3);
                n4 = (int)((double)n * d3);
            }
            graphics.drawImage(this.image, n5 - n3 / 2, n6 - n4 / 2, n3, n4, imageObserver);
        }
        n2 = n5 - n3 / 2 - 1;
        n = n6 - n4 / 2 - 1;
        int n7 = n2 + n3 + 2;
        int n8 = n + n4 + 2;
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n2, n, n7 - 1, n);
        graphics.drawLine(n2, n + 1, n2, n8 - 1);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n2 + 1, n8 - 1, n7 - 1, n8 - 1);
        graphics.drawLine(n7 - 1, n8 - 2, n7 - 1, n + 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n2 + 1, n + 1, n7 - 2, n + 1);
        graphics.drawLine(n2 + 1, n + 2, n2 + 1, n8 - 2);
        graphics.setColor(Color.black);
        graphics.setFont(JaveGlobalRessources.FONT_SMALL);
        FontMetrics fontMetrics = this.getFontMetrics(JaveGlobalRessources.FONT_SMALL);
        int n9 = fontMetrics.stringWidth(this.label);
        graphics.drawString(this.label, (this.width - n9) / 2, dimension.height - 5);
        String string = String.valueOf(this.fileWidth);
        n9 = fontMetrics.stringWidth(string);
        int n10 = fontMetrics.getAscent();
        graphics.setColor(SystemColor.control);
        graphics.fillRect((this.width - n9) / 2 - 1, 2, n9 + 2, n10);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawRect((this.width - n9) / 2 - 1, 2, n9 + 2, n10);
        graphics.setColor(SystemColor.controlText);
        graphics.drawString(string, (this.width - n9) / 2 + 1, n10);
        String string2 = String.valueOf(this.fileHeight);
        n9 = fontMetrics.stringWidth(string2);
        graphics.setColor(SystemColor.control);
        graphics.fillRect(2, n6 - n10 / 2, n9 + 2, n10);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawRect(2, n6 - n10 / 2, n9 + 2, n10);
        graphics.setColor(SystemColor.controlText);
        graphics.drawString(string2, 4, n6 - n10 / 2 - 2 + n10);
    }

    protected void paintBackground(Graphics graphics, Dimension dimension) {
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(1, 1, dimension.width - 1, 1);
        graphics.drawLine(1, 2, 1, dimension.height - 1);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 1, 0, dimension.height - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, dimension.height - 1, dimension.width - 2, 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 0);
        if (this.selected) {
            graphics.setColor(Color.blue);
            graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 4);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.setSelected(true);
            if (this.actionListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, "open");
                this.actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

