/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GGridLayout2;
import de.jave.image.ImageCanvas2;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Fonts;
import java.awt.AWTEventMulticaster;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GifExportOptionsPanel
extends GBorderedPanel
implements ItemListener {
    protected Choice chFont;
    protected Choice chScale;
    protected ImageCanvas2 gImage;
    protected ScrollPane scrollPane;
    protected Checkbox cbPixelView;
    protected int fontScale;
    protected static final CharacterPlate cpPreview = new CharacterPlate("ABCDEabcde\n12345.:#-+\n_,-'`-._");
    protected String fontName;
    protected Font fontFont;
    transient ActionListener actionListener;
    protected boolean pixelView;

    public GifExportOptionsPanel(boolean bl) {
        super("GIF output options");
        if (!Fonts.isInitialized()) {
            Fonts.init();
        }
        String[] stringArray = Fonts.getFontList();
        this.chFont = new Choice();
        int n = 0;
        while (n < stringArray.length) {
            this.chFont.add(stringArray[n]);
            ++n;
        }
        this.chFont.select(Fonts.getDefaultFontName());
        this.chScale = new Choice();
        int n2 = 1;
        while (n2 <= 17) {
            this.chScale.addItem(String.valueOf(n2));
            ++n2;
        }
        this.chScale.select(5);
        this.chScale.addItemListener(this);
        this.chFont.addItemListener(this);
        this.cbPixelView = new Checkbox("Pixel View", false);
        this.cbPixelView.addItemListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("Font:", 2));
        panel.add(this.chFont);
        panel.add(new Label("Size:", 2));
        panel.add(this.chScale);
        panel.add(this.cbPixelView);
        this.setLayout(new GGridLayout2(0, 1, 0, 0));
        this.add(panel);
        if (bl) {
            this.gImage = new ImageCanvas2();
            GBorderedPanel gBorderedPanel = new GBorderedPanel("Font Demo:", -1);
            this.scrollPane = new ScrollPane();
            this.scrollPane.setSize(200, 150);
            this.scrollPane.add(this.gImage);
            this.add(this.scrollPane);
        }
        this.itemStateChanged(null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fontScale = Integer.parseInt(this.chScale.getSelectedItem());
        this.fontName = this.chFont.getSelectedItem();
        this.fontFont = new Font(this.fontName, 0, this.fontScale);
        this.pixelView = this.cbPixelView.getState();
        if (this.gImage != null) {
            this.gImage.setImage(AsciiToThumbnailConverter.convert(cpPreview, this.fontScale, this.fontFont, Color.white, Color.black, this.pixelView));
            this.gImage.repaint();
            this.scrollPane.validate();
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "font changed"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public int getFontScale() {
        return this.fontScale;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Font getResultFont() {
        return this.fontFont;
    }

    public boolean getPixelView() {
        return this.pixelView;
    }
}

