/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.FreehandAlgorithm;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class FreehandToolAlgorithmic
extends Tool {
    protected Point location1;
    protected static final int LINES_ROUNDED = 0;
    protected static final int LINES_MIDDLE = 1;
    protected static final int CHARACTERS = 2;
    protected static final String[] MODE_STR = new String[]{"Line", "Middle", "Characters"};
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = true;
    protected Choice chMode;
    protected boolean upToDate = false;

    public FreehandToolAlgorithmic(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Freehand Algorithmic";
    }

    public String getIconName() {
        return "freehand";
    }

    public Component createOptionsComponent() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 0, 0, 0));
        this.chMode = new Choice();
        int n = 0;
        while (n < MODE_STR.length) {
            this.chMode.addItem(MODE_STR[n]);
            ++n;
        }
        this.chMode.select(0);
        this.chMode.addItemListener(this);
        panel.add(this.chMode);
        this.cbMix = new Checkbox("Mix", true);
        this.cbMix.addItemListener(this);
        panel.add(this.cbMix);
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.upToDate = false;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        this.markPlate.setMode(1);
        this.markPlate.set(point2.x, point2.y);
        int n = this.chMode.getSelectedIndex();
        if (n == 2) {
            this.markPlate.setCharacter(this.getMouseChar());
        } else {
            this.markPlate.setCharacter('#');
        }
        this.location1 = point2;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.cbMix.getState());
        if (!this.upToDate) {
            this.convert();
        }
        this.markPlate.pasteResultInto(this.plate.getContent());
        this.markPlate = null;
        this.saveCurrentState("freehand");
        this.repaintAll();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27) {
            this.markPlate = null;
            this.location1 = null;
            this.repaintCursor();
            return;
        }
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null || point2 == null || this.location1 == null) {
            return;
        }
        if (point2.equals(this.location1)) {
            return;
        }
        this.upToDate = false;
        LineAlgorithm.drawLineBresenham(this.markPlate, point2, this.location1, this.markPlate.getCharacter());
        this.location1 = point2;
        this.repaintCursor();
        this.showCoordinates(point2);
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.markPlate == null) {
            return;
        }
        this.convert();
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    protected void convert() {
        int n = this.chMode.getSelectedIndex();
        if (n == 2) {
            this.markPlate.convert();
        } else {
            FreehandAlgorithm.convertMarksToFreehandLine(this.markPlate, n);
        }
        this.upToDate = true;
    }
}

