/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.GeneralAlgorithm;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ColorScreenSaver
extends Window
implements MouseListener,
MouseMotionListener,
KeyListener,
Runnable {
    protected int mode = 2;
    protected int charWidth;
    protected int charHeight;
    protected int plateWidth;
    protected int plateHeight;
    protected boolean shallStop;
    private Dimension offDimension;
    private Image offImage;
    private Graphics offGraphics;
    protected PixelPlate pixelPlate1;
    protected PixelPlate pixelPlate2;
    protected boolean active = false;
    protected int[][] colors;
    protected static final Color[] COLORS = new Color[]{Color.white, Color.green, Color.red, Color.blue, Color.yellow, Color.magenta, Color.orange, Color.cyan, Color.pink};

    public ColorScreenSaver(Frame frame) {
        super(frame);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.charWidth = this.getFontMetrics(this.getFont()).stringWidth("#");
        this.charHeight = (int)Math.round(13.919999999999998);
        Dimension dimension = this.getPreferredSize();
        this.plateWidth = dimension.width / this.charWidth;
        this.plateHeight = dimension.height / this.charHeight;
        this.init();
        this.pack();
        this.show();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.shallStop = false;
        Thread thread = new Thread(this);
        thread.start();
        this.requestFocus();
    }

    public void run() {
        while (!this.shallStop) {
            this.step();
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.active = true;
        }
    }

    public void init() {
        int n;
        this.colors = new int[this.plateHeight][this.plateWidth];
        this.pixelPlate1 = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        this.pixelPlate2 = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        this.pixelPlate1.setMode(this.mode);
        this.pixelPlate2.setMode(this.mode);
        int n2 = this.pixelPlate1.getVirtualWidth();
        int n3 = this.pixelPlate1.getVirtualHeight();
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < n2) {
                if (Math.random() > 0.6) {
                    this.pixelPlate1.set(n, n4);
                }
                ++n;
            }
            ++n4;
        }
        n = 0;
        while (n < this.plateHeight) {
            int n5 = 0;
            while (n5 < this.plateWidth) {
                this.colors[n][n5] = (int)(Math.random() * 100.0);
                ++n5;
            }
            ++n;
        }
    }

    public void step() {
        int n = this.pixelPlate1.getVirtualWidth();
        int n2 = this.pixelPlate1.getVirtualHeight();
        int n3 = n / this.plateWidth;
        int n4 = n2 / this.plateHeight;
        this.pixelPlate2.clear();
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = this.countNeighBours(n6, n5);
                double d = Math.random();
                if (d < 0.05) {
                    ++n7;
                }
                if (this.pixelPlate1.isSet(n6, n5)) {
                    if (n7 != 0 && n7 != 1 && n7 < 4) {
                        this.pixelPlate2.set(n6, n5);
                    }
                } else if (n7 == 3) {
                    this.pixelPlate2.set(n6, n5);
                    int n8 = 0;
                    if (this.pixelPlate1.isSet(n6 - 1, n5)) {
                        n8 = this.colors[n5 / n4][(n6 - 1) / n3];
                    } else if (this.pixelPlate1.isSet(n6 + 1, n5)) {
                        n8 = this.colors[n5 / n4][(n6 + 1) / n3];
                    } else if (this.pixelPlate1.isSet(n6, n5 + 1)) {
                        n8 = this.colors[(n5 + 1) / n4][n6 / n3];
                    } else if (this.pixelPlate1.isSet(n6, n5 - 1)) {
                        n8 = this.colors[(n5 - 1) / n4][n6 / n3];
                    } else if (this.pixelPlate1.isSet(n6 - 1, n5 - 1)) {
                        n8 = this.colors[(n5 - 1) / n4][(n6 - 1) / n3];
                    } else if (this.pixelPlate1.isSet(n6 + 1, n5 - 1)) {
                        n8 = this.colors[(n5 - 1) / n4][(n6 + 1) / n3];
                    } else if (this.pixelPlate1.isSet(n6 - 1, n5 + 1)) {
                        n8 = this.colors[(n5 + 1) / n4][(n6 - 1) / n3];
                    } else if (this.pixelPlate1.isSet(n6 + 1, n5 + 1)) {
                        n8 = this.colors[(n5 + 1) / n4][(n6 + 1) / n3];
                    }
                    this.colors[n5 / n4][n6 / n3] = n8;
                }
                if (n7 > 1 && d < 0.001) {
                    this.pixelPlate2.set(n6, n5);
                    this.colors[n5 / n4][n6 / n3] = (int)(Math.random() * 100.0);
                }
                ++n6;
            }
            ++n5;
        }
        this.pixelPlate2.convert();
        PixelPlate pixelPlate = this.pixelPlate1;
        this.pixelPlate1 = this.pixelPlate2;
        this.pixelPlate2 = pixelPlate;
        this.repaint();
    }

    public int countNeighBours(int n, int n2) {
        int n3 = 0;
        if (this.pixelPlate1.isSet(n - 1, n2)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n, n2 + 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n - 1, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2 - 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n - 1, n2 + 1)) {
            ++n3;
        }
        if (this.pixelPlate1.isSet(n + 1, n2 + 1)) {
            ++n3;
        }
        return n3;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
            this.offDimension = new Dimension(dimension.width, dimension.height);
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(this.getForeground());
        CharacterPlate characterPlate = this.pixelPlate1.getResult();
        GeneralAlgorithm.replace(characterPlate, '\u0000', ' ');
        char[][] cArray = characterPlate.getContent();
        int n = 0;
        while (n < this.plateHeight) {
            int n2 = 0;
            while (n2 < this.plateWidth) {
                if (cArray[n][n2] != ' ') {
                    this.offGraphics.setColor(COLORS[this.colors[n][n2] % COLORS.length]);
                    this.offGraphics.drawString(String.valueOf(cArray[n][n2]), 2 + n2 * this.charWidth, 2 + n * this.charHeight + this.charHeight * 3 / 4);
                }
                ++n2;
            }
            ++n;
        }
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    public void quit() {
        if (!this.active) {
            return;
        }
        this.shallStop = true;
        this.dispose();
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.quit();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.quit();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.quit();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.quit();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.quit();
    }

    public Dimension getPreferredSize() {
        return this.getToolkit().getScreenSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.pack();
        frame.show();
        PixelPlate.init();
        ColorScreenSaver colorScreenSaver = new ColorScreenSaver(frame);
    }
}

