/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.jave.EraserTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Plate;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CloneTool
extends EraserTool {
    protected static int DEFAULT_SIZE = 3;
    protected int dx;
    protected int dy;
    protected Point cloneLocation;
    protected boolean positionLocked = false;
    protected static final boolean DEFAULT_MIX = true;
    protected Checkbox cbMix;

    public CloneTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public Component createOptionsComponent() {
        Panel panel = (Panel)super.createOptionsComponent();
        this.cbMix = new Checkbox("Mix", true);
        panel.add(this.cbMix);
        return panel;
    }

    public String getName() {
        return "Clone Tool";
    }

    public String getIconName() {
        return "clone_brush";
    }

    public String getUndoRedoActionName() {
        return "clone";
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.cursorLocation == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorTool);
        this.paintBrushBorder(graphics, this.brush, this.cursorLocation.x, this.cursorLocation.y);
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        int n = 0;
        int n2 = 0;
        if (!this.positionLocked && this.cloneLocation != null) {
            n = this.cloneLocation.x;
            n2 = this.cloneLocation.y;
        } else if (this.positionLocked) {
            n = this.cursorLocation.x - this.dx;
            n2 = this.cursorLocation.y - this.dy;
        } else {
            return;
        }
        this.paintBrushBorder(graphics, this.brush, n, n2);
        graphics.setColor(JaveGlobalRessources.colorTool);
        int n3 = this.brush.length;
        int n4 = this.brush[0].length;
        int n5 = (n4 - 1) / 2;
        int n6 = (n3 - 1) / 2;
        Point point = this.getScreenPointFor(this.cursorLocation.x - n5, this.cursorLocation.y - n6);
        graphics.setColor(JaveGlobalRessources.colorToolDarker);
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                int n10;
                char c = this.brush[n8][n7];
                if (c > '\u0000' && this.plate.isInside(n10 = n - n5 + n7, n9 = n2 - n6 + n8)) {
                    graphics.drawString(String.valueOf(this.plate.getChar(n10, n9)), point.x + n7 * this.plate.charWidth, point.y + n8 * this.plate.charHeight + this.plate.fontAscent);
                }
                ++n8;
            }
            ++n7;
        }
    }

    protected void paint(int n, int n2) {
        if (this.cursorLocation == null || this.cloneLocation == null) {
            return;
        }
        int n3 = this.brush.length;
        int n4 = this.brush[0].length;
        int n5 = (n4 - 1) / 2;
        int n6 = (n3 - 1) / 2;
        this.plate.setMix(this.cbMix.getState());
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                int n10;
                char c = this.brush[n8][n7];
                if (c > '\u0000' && this.plate.isInside((n10 = n - n5 + n7) - this.dx, (n9 = n2 - n6 + n8) - this.dy)) {
                    this.plate.setChar(n10, n9, this.plate.getChar(n10 - this.dx, n9 - this.dy));
                }
                ++n8;
            }
            ++n7;
        }
        this.plate.repaint(50L);
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() || mouseEvent.isMetaDown()) {
            this.positionLocked = false;
            this.cloneLocation = point2;
            this.dx = 0;
            this.dy = 0;
            this.repaintCursor();
            return;
        }
        this.cursorLocation = point2;
        if (this.cloneLocation == null) {
            this.explanationDialog();
            return;
        }
        if (!this.positionLocked) {
            this.positionLocked = true;
            this.dx = this.cursorLocation.x - this.cloneLocation.x;
            this.dy = this.cursorLocation.y - this.cloneLocation.y;
        }
        this.paint(point2);
    }

    protected void explanationDialog() {
        new GDialog((Frame)this.jave, "JavE - Clone Tool", "You must specify a clone source by right-clicking\nor clicking on the image with the shift key down\nbefore you can use the clone brush.", 3).show();
    }
}

