/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.ImageLoader;
import de.jave.gui.CharField;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GButton;
import de.jave.gui.GChoice;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GSliderArrangement;
import de.jave.gui.GuiTools;
import de.jave.gui.VFlowLayout;
import de.jave.image.GGreyscaleImage;
import de.jave.image.ImageCanvas2;
import de.jave.jave.Camel;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveImages;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class CamelDialog
extends Dialog
implements WindowListener,
ItemListener,
TextListener,
ActionListener,
AdjustmentListener {
    protected static final String TITLE = "Camelizer - Form current text to shape from image file";
    protected Jave jave;
    protected GSliderArrangement slaBrightness;
    protected boolean applied = false;
    protected Button bClose;
    protected Button bCancel;
    protected Checkbox cbNegative;
    protected GChoice chMode;
    protected CharField cfFillChar;
    protected GButton gbLoad;
    protected TextField tfImageName;
    protected ImageCanvas2 icPreview;
    protected ImageCanvas2 icSource;
    protected CharacterPlate sourcePlate;
    protected String currentDirectory;
    protected Camel camel;

    public CamelDialog(Jave jave) {
        super(jave, TITLE, true);
        this.jave = jave;
        this.currentDirectory = this.jave.documentManager.getCurrentDirectory();
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.tfImageName = new TextField(15);
        this.tfImageName.setEditable(false);
        this.gbLoad = JaveImages.createButton("open", "open_");
        this.gbLoad.addActionListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        panel.add(new Label("Image:", 2));
        panel.add(this.tfImageName);
        panel.add(this.gbLoad);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Shape image:");
        gBorderedPanel.setLayout(new BorderLayout());
        this.icSource = new ImageCanvas2();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.icSource);
        gBorderedPanel.add((Component)scrollPane, "Center");
        gBorderedPanel.add((Component)panel, "South");
        this.icPreview = new ImageCanvas2();
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Preview:");
        gBorderedPanel2.setLayout(new GridLayout());
        gBorderedPanel2.add(this.icPreview);
        this.cbNegative = new Checkbox("Negative Image", false);
        this.cbNegative.addItemListener(this);
        this.chMode = new GChoice("Mode:", Camel.STR_MODES);
        this.chMode.addItemListener(this);
        this.cfFillChar = new CharField(':');
        this.cfFillChar.addTextListener(this);
        Panel panel2 = new Panel();
        panel2.add(this.chMode);
        panel2.add(new Label("Fill character:", 2));
        panel2.add(this.cfFillChar);
        this.slaBrightness = new GSliderArrangement("Brightness:", -10, 10, 0, 1, 10);
        this.slaBrightness.addAdjustmentListener(this);
        GBorderedPanel gBorderedPanel3 = new GBorderedPanel("Options");
        gBorderedPanel3.setLayout(new VFlowLayout());
        gBorderedPanel3.add(panel2);
        gBorderedPanel3.add(this.slaBrightness);
        gBorderedPanel3.add(this.cbNegative);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 2));
        panel3.add(gBorderedPanel);
        panel3.add(gBorderedPanel2);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)panel3, "Center");
        panel4.add((Component)gBorderedPanel3, "South");
        Panel panel5 = new Panel();
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        panel5.add(this.bClose);
        this.bCancel = new Button("Cancel");
        this.bCancel.addActionListener(this);
        panel5.add(this.bCancel);
        this.add((Component)panel4, "Center");
        this.add((Component)panel5, "South");
        this.pack();
        GuiTools.centerToFrame(this);
    }

    public void setSourceText(CharacterPlate characterPlate) {
        this.sourcePlate = characterPlate;
        if (this.camel != null) {
            this.camel.setSourceText(characterPlate.toString());
        } else {
            this.camel = new Camel(characterPlate.toString());
        }
        this.convert();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.convert();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.convert();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.convert();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            if (this.applied) {
                this.jave.plate.saveCurrentState("camelize");
            }
            this.applied = false;
            this.setVisible(false);
            return;
        }
        if (object == this.bCancel) {
            if (this.applied) {
                this.jave.setContentOfInterest(this.sourcePlate);
                this.applied = false;
            }
            this.setVisible(false);
        } else if (object == this.gbLoad) {
            FileDialog fileDialog = new FileDialog((Frame)this.jave, "Open Image as shape for this text", 0);
            if (this.currentDirectory != null) {
                fileDialog.setDirectory(this.currentDirectory);
            }
            fileDialog.show();
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            if (string == null) {
                return;
            }
            String string3 = string2 + string;
            Image image = null;
            try {
                image = ImageLoader.loadImage(string3, this);
            }
            catch (RuntimeException runtimeException) {
                new GErrorDialog((Frame)this.jave, "Camelizer", "Unknown error loading image", "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).", runtimeException).show();
                return;
            }
            GGreyscaleImage gGreyscaleImage = Camel.loadImage(image, this);
            this.camel.setRawImage(gGreyscaleImage);
            this.icSource.setImage(gGreyscaleImage);
            this.currentDirectory = string2;
            this.tfImageName.setText(string);
            this.convert();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    protected void convert() {
        if (this.camel == null || !this.camel.checkReady()) {
            return;
        }
        CharacterPlate characterPlate = this.camel.camelize(this.chMode.getSelectedIndex(), this.cbNegative.getState(), this.slaBrightness.getDValue(), this.cfFillChar.getChar());
        this.icPreview.setImage(this.camel.getPreviewImage());
        this.jave.setContentOfInterest(characterPlate);
        this.applied = true;
    }
}

