/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GChoice;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Line2d;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkPainter;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class AuxiliaryLinesTool
extends Tool
implements ActionListener,
ItemListener,
WatermarkPainter {
    protected Vector lines;
    protected Line2d newLine;
    protected Point2d lastPoint;
    protected Object selectedObject;
    protected Object popupObject;
    protected Button bClear;
    protected GChoice chMode;
    protected static final String[] MODE_STR = new String[]{"Draw lines", "Edit lines"};
    protected static final int MODE_CREATE = 0;
    protected static final int MODE_MOVE = 1;
    protected int mode;
    protected MenuItem miDelete;
    protected boolean enabled = false;
    protected PopupMenu popup;
    protected Point point1;

    public AuxiliaryLinesTool(Plate plate, Jave jave) {
        super(plate, jave);
        plate.addWatermarkPainter(this);
        this.lines = new Vector(15);
        this.mode = 0;
        plate.add(this.createPopupMenu());
    }

    protected PopupMenu createPopupMenu() {
        this.popup = new PopupMenu();
        this.miDelete = new MenuItem("Delete");
        this.miDelete.addActionListener(this);
        this.popup.add(this.miDelete);
        return this.popup;
    }

    public String getName() {
        return "Auxiliary Lines";
    }

    public String getIconName() {
        return "auxlines";
    }

    public Component createOptionsComponent() {
        this.bClear = new Button("Clear");
        this.bClear.addActionListener(this);
        this.chMode = new GChoice("Mode:", MODE_STR);
        this.chMode.addItemListener(this);
        Panel panel = new Panel();
        panel.add(this.bClear);
        panel.add(this.chMode);
        return panel;
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.jave.toolBar.setAuxiliaryLinesVisible(true);
    }

    public void putAside(boolean bl) {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.enabled) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        boolean bl = this.isActiveTool();
        int n7 = this.lines.size() - 1;
        while (n7 >= 0) {
            Line2d line2d = (Line2d)this.lines.elementAt(n7);
            Point point = this.plate.getScreenPointFor(line2d.p0);
            Point point2 = this.plate.getScreenPointFor(line2d.p1);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            if (bl) {
                graphics.drawRect(point.x - 2, point.y - 2, 4, 4);
                graphics.drawRect(point2.x - 2, point2.y - 2, 4, 4);
            }
            --n7;
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        Point point;
        Object object;
        if (this.mode == 0 && this.newLine != null) {
            object = this.plate.getScreenPointFor(this.newLine.p0);
            point = this.plate.getScreenPointFor(this.newLine.p1);
            graphics.setColor(JaveGlobalRessources.colorToolHelping);
            graphics.drawLine(((Point)object).x, ((Point)object).y, point.x, point.y);
        }
        object = this.selectedObject;
        if (this.selectedObject == null) {
            object = this.popupObject;
        }
        if (this.mode == 1 && object != null) {
            if (object instanceof Point2d) {
                point = this.plate.getScreenPointFor((Point2d)object);
                graphics.setColor(Color.red);
                graphics.drawRect(point.x - 2, point.y - 2, 4, 4);
            } else {
                point = this.plate.getScreenPointFor(((Line2d)object).p0);
                Point point2 = this.plate.getScreenPointFor(((Line2d)object).p1);
                graphics.setColor(Color.red);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                graphics.drawRect(point.x - 2, point.y - 2, 4, 4);
                graphics.drawRect(point2.x - 2, point2.y - 2, 4, 4);
            }
        }
    }

    public Point2d getPointAt(Point2d point2d) {
        int n = this.lines.size() - 1;
        while (n >= 0) {
            Line2d line2d = (Line2d)this.lines.elementAt(n);
            if (line2d.p0.getDistance(point2d) <= 0.5) {
                return line2d.p0;
            }
            if (line2d.p1.getDistance(point2d) <= 0.5) {
                return line2d.p1;
            }
            --n;
        }
        return null;
    }

    public Line2d getLineAt(Point2d point2d) {
        int n = this.lines.size() - 1;
        while (n >= 0) {
            Line2d line2d = (Line2d)this.lines.elementAt(n);
            if (point2d.getDistanceTo(line2d.p0, line2d.p1) <= 0.5 && point2d.getDistance(line2d.p0) <= line2d.length() + 0.5 && point2d.getDistance(line2d.p1) <= line2d.length() + 0.5) {
                return line2d;
            }
            --n;
        }
        return null;
    }

    public Object getObjectAt(Point2d point2d) {
        Object object = this.getPointAt(point2d);
        if (object == null) {
            object = this.getLineAt(point2d);
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClear) {
            this.lines.removeAllElements();
            this.repaintAll();
            return;
        }
        if (object == this.miDelete && this.popupObject != null) {
            this.lines.removeElement(this.popupObject);
            this.popupObject = null;
            this.selectedObject = null;
            this.repaintAll();
            return;
        }
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
        super.mouseMoved(point, point2, mouseEvent);
        if (this.mode == 1) {
            Point2d point2d = this.plate.getRealLocationForScreenPoint(point);
            Object object = this.getObjectAt(point2d);
            if (this.selectedObject == object) {
                return;
            }
            this.selectedObject = object;
            if (this.selectedObject != null) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.setCursor(JaveGlobalRessources.cursorSelection);
            }
            this.repaintCursor();
        }
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.popupObject != null) {
            this.popupObject = null;
            this.repaintCursor();
            return;
        }
        if (this.mode == 0 && this.newLine == null) {
            Point2d point2d = this.plate.getRealLocationForScreenPoint(point);
            this.newLine = new Line2d(point2d, point2d);
            return;
        }
        if (mouseEvent.isMetaDown() && this.selectedObject != null && this.selectedObject instanceof Line2d) {
            this.popupObject = this.selectedObject;
            this.selectedObject = null;
            this.setCursor(JaveGlobalRessources.cursorSelection);
            this.popup.show(this.plate, point.x, point.y);
            return;
        }
        if (this.mode == 1) {
            Point2d point2d;
            this.lastPoint = point2d = this.plate.getRealLocationForScreenPoint(point);
            return;
        }
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.mode == 0 && this.newLine != null) {
            if (this.newLine.length() > 2.0) {
                this.lines.addElement(this.newLine);
                if (!this.enabled) {
                    this.jave.toolBar.setAuxiliaryLinesVisible(true);
                }
                this.repaintAll();
            } else {
                this.repaintCursor();
            }
            this.newLine = null;
            return;
        }
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.mode == 0 && this.newLine != null) {
            Point2d point2d;
            this.newLine.p1 = point2d = this.plate.getRealLocationForScreenPoint(point);
            this.repaintCursor();
            return;
        }
        if (this.mode == 1 && this.selectedObject != null) {
            if (this.selectedObject instanceof Point2d) {
                Point2d point2d = this.plate.getRealLocationForScreenPoint(point);
                ((Point2d)this.selectedObject).moveTo(point2d);
                this.repaintAll();
                return;
            }
            Point2d point2d = this.plate.getRealLocationForScreenPoint(point);
            double d = point2d.x - this.lastPoint.x;
            double d2 = point2d.y - this.lastPoint.y;
            ((Line2d)this.selectedObject).translate(d, d2);
            this.lastPoint = point2d;
            this.repaintAll();
            return;
        }
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27 && this.newLine != null) {
            this.newLine = null;
            this.repaintCursor();
            return;
        }
        if (n == 127 && this.selectedObject != null) {
            this.lines.removeElement(this.selectedObject);
            this.popupObject = null;
            this.selectedObject = null;
            this.setCursor(JaveGlobalRessources.cursorSelection);
            this.repaintAll();
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.mode = this.chMode.getSelectedIndex();
        if (this.mode == 1) {
            this.setCursor(JaveGlobalRessources.cursorSelection);
        } else {
            this.setCursor(JaveGlobalRessources.cursorSelection);
        }
        this.plate.requestFocus();
    }
}

