/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GChoice;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.text.TextTools;
import de.jave.util.Toolbox;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Vector;

public class AsciiGreyscaleTable
implements JaveConfigurationLoadable {
    protected static String[] tableNames;
    protected static Hashtable hashTable;
    protected static String defaultTableName;
    protected static boolean initialized;
    protected char[] greyscales;
    protected char[][] greyscales4;
    protected boolean[] ignores;
    protected boolean[] defaultIgnores;
    protected boolean[] ignores4;
    protected boolean[] defaultIgnores4;
    protected char[] characters;
    protected char[][] characters4;

    protected AsciiGreyscaleTable() {
    }

    public String getConfigurationFileName() {
        return "./config/greyscaletables/";
    }

    public void setDefaultConfiguration() {
        hashTable = null;
        tableNames = new String[0];
        defaultTableName = null;
    }

    public static GChoice createComponent() {
        GChoice gChoice = new GChoice("Font table:", tableNames);
        gChoice.select(defaultTableName);
        return gChoice;
    }

    public static final boolean isInitialized() {
        return initialized;
    }

    public static void init() {
        AsciiGreyscaleTable.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new AsciiGreyscaleTable());
    }

    public void loadConfiguration(File file) throws Exception {
        if (!file.isDirectory()) {
            throw new Exception("There is no folder '" + file + "' containing cofiguration files.");
        }
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].toLowerCase().endsWith(".jgt")) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            throw new Exception("There are no configuration files in folder '" + file + "'.");
        }
        tableNames = new String[n];
        hashTable = new Hashtable(n * 2 + 1);
        defaultTableName = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (stringArray[n4].toLowerCase().endsWith(".jgt")) {
                AsciiGreyscaleTable.tableNames[n3] = stringArray[n4].substring(0, stringArray[n4].length() - 4);
                if (stringArray[n4].charAt(0) == '_') {
                    AsciiGreyscaleTable.tableNames[n3] = tableNames[n3].substring(1);
                    AsciiGreyscaleTable.tableNames[n3] = TextTools.firstLetterUp(tableNames[n3]);
                    defaultTableName = tableNames[n3];
                } else {
                    AsciiGreyscaleTable.tableNames[n3] = TextTools.firstLetterUp(tableNames[n3]);
                }
                File file2 = new File(file, stringArray[n4]);
                AsciiGreyscaleTable asciiGreyscaleTable = AsciiGreyscaleTable.load(file2);
                hashTable.put(tableNames[n3], asciiGreyscaleTable);
                ++n3;
            }
            ++n4;
        }
        Toolbox.quickSort(tableNames);
        if (defaultTableName == null) {
            defaultTableName = tableNames[0];
        }
        initialized = true;
    }

    public char getCharForBrightness(int n) {
        if (n > 255) {
            return this.characters[255];
        }
        if (n < 0) {
            return this.characters[0];
        }
        return this.characters[n];
    }

    public int getBrightnessForChar(char c) {
        if (c < ' ') {
            return this.greyscales[0];
        }
        if (c > '~') {
            return this.greyscales[94];
        }
        return this.greyscales[c - 32];
    }

    public char[] getBrightness4ForChar(char c) {
        int n = c - 32;
        if (c < ' ') {
            n = 0;
        }
        if (c > '~') {
            n = 94;
        }
        return new char[]{this.greyscales4[n][0], this.greyscales4[n][1], this.greyscales4[n][2], this.greyscales4[n][3]};
    }

    public char getCharForBrightness(char[] cArray) {
        return this.getCharForBrightness(cArray[0], cArray[1], cArray[2], cArray[3]);
    }

    public char getCharForBrightness(int n, int n2, int n3, int n4) {
        return AsciiGreyscaleTable.findNearestMaxQuick(n, n2, n3, n4, this.characters4, this.ignores4);
    }

    protected static final char findNearestMaxQuick(int n, int n2, int n3, int n4, char[][] cArray, boolean[] blArray) {
        int n5;
        int n6;
        int n7 = (cArray.length + 1) / 2;
        if (n <= 0 && n2 <= 0 && n3 <= 0 && n4 <= 0 && !blArray[cArray[0][4] - 32]) {
            return cArray[0][4];
        }
        if (n >= 255 && n2 >= 255 && n3 >= 255 && n4 >= 255 && !blArray[cArray[cArray.length - 1][4] - 32]) {
            return cArray[cArray.length - 1][4];
        }
        int n8 = n7;
        boolean bl = false;
        while (n7 > 1 && !bl && n8 >= 0 && n8 < cArray.length) {
            n7 = (n7 + 1) / 2;
            if (cArray[n8][0] < n) {
                n8 += n7;
                continue;
            }
            if (cArray[n8][0] > n) {
                n8 -= n7;
                continue;
            }
            bl = true;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n8 >= cArray.length) {
            n8 = cArray.length - 1;
        }
        if (blArray[cArray[n8][4] - 32]) {
            n6 = 1;
            while (true) {
                if (n8 + (n5 = (n6 + 1) / 2 * (2 * (n6 % 2) - 1)) < cArray.length && n8 + n5 >= 0 && !blArray[cArray[n8 + n5][4] - 32]) {
                    n8 += n5;
                    break;
                }
                ++n6;
            }
        }
        n6 = (n6 = cArray[n8][0] - n) > 0 ? n6 : -n6;
        n5 = cArray[n8][1] - n2;
        n5 = n5 > 0 ? n5 : -n5;
        n6 = n6 > n5 ? n6 : n5;
        n5 = cArray[n8][2] - n3;
        n5 = n5 > 0 ? n5 : -n5;
        n6 = n6 > n5 ? n6 : n5;
        n5 = cArray[n8][3] - n4;
        n5 = n5 > 0 ? n5 : -n5;
        int n9 = n6 = n6 > n5 ? n6 : n5;
        int n10 = n8;
        int n11 = n + n6;
        int n12 = n8 + 1;
        while (n12 < cArray.length) {
            n6 = cArray[n12][0] - n;
            int n13 = n6 = n6 > 0 ? n6 : -n6;
            if (n6 > n11) break;
            n5 = cArray[n12][1] - n2;
            n5 = n5 > 0 ? n5 : -n5;
            n6 = n6 > n5 ? n6 : n5;
            n5 = cArray[n12][2] - n3;
            n5 = n5 > 0 ? n5 : -n5;
            n6 = n6 > n5 ? n6 : n5;
            n5 = cArray[n12][3] - n4;
            n5 = n5 > 0 ? n5 : -n5;
            int n14 = n6 = n6 > n5 ? n6 : n5;
            if (n6 < n9 && !blArray[cArray[n12][4] - 32]) {
                n9 = n6;
                n8 = n12;
                n11 = n + n6;
            }
            ++n12;
        }
        int n15 = n - n9;
        n12 = n10 - 1;
        while (n12 >= 0) {
            n6 = cArray[n12][0] - n;
            int n16 = n6 = n6 > 0 ? n6 : -n6;
            if (n6 < n15) break;
            n5 = cArray[n12][1] - n2;
            n5 = n5 > 0 ? n5 : -n5;
            n6 = n6 > n5 ? n6 : n5;
            n5 = cArray[n12][2] - n3;
            n5 = n5 > 0 ? n5 : -n5;
            n6 = n6 > n5 ? n6 : n5;
            n5 = cArray[n12][3] - n4;
            n5 = n5 > 0 ? n5 : -n5;
            int n17 = n6 = n6 > n5 ? n6 : n5;
            if (n6 < n9 && !blArray[cArray[n12][4] - 32]) {
                n9 = n6;
                n8 = n12;
                n15 = n - n6;
            }
            --n12;
        }
        return cArray[n8][4];
    }

    public void setDoNotUse(String string) {
        System.arraycopy(this.defaultIgnores, 0, this.ignores, 0, 95);
        if (string == null) {
            return;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            int n2 = string.charAt(n) - 32;
            if (n2 >= 0 && n2 <= 94) {
                this.ignores[n2] = true;
            }
            --n;
        }
        this.buildCharactersForBrightness();
    }

    protected void buildCharactersForBrightness() {
        int n;
        int n2;
        int n3;
        this.characters = new char[256];
        int n4 = 0;
        while (n4 < 95) {
            if (!this.ignores[n4]) {
                this.characters[this.greyscales[n4]] = (char)(32 + n4);
            }
            ++n4;
        }
        if (this.characters[255] == '\u0000' || this.characters[0] == '\u0000') {
            n3 = 0;
            n2 = 0;
            n = 0;
            while (n < 95) {
                if (!this.ignores[n]) {
                    if (this.greyscales[n] < this.greyscales[n3]) {
                        n3 = n;
                    }
                    if (this.greyscales[n] > this.greyscales[n2]) {
                        n2 = n;
                    }
                }
                ++n;
            }
            this.characters[255] = (char)(n2 + 32);
            this.characters[0] = (char)(n3 + 32);
        }
        n3 = 0;
        n2 = 0;
        while (n2 < 255) {
            if (this.characters[n2] == '\u0000') {
                int n5;
                if (n3 <= n2) {
                    n3 = n2 + 1;
                    while (this.characters[n3] == '\u0000') {
                        ++n3;
                    }
                }
                this.characters[n2] = (n = n2 - this.greyscales[this.characters[n2 - 1] - 32]) < (n5 = this.greyscales[this.characters[n3] - 32] - n2) ? this.characters[n2 - 1] : this.characters[n3];
            }
            ++n2;
        }
    }

    public void setDoNotUse4(String string) {
        System.arraycopy(this.defaultIgnores4, 0, this.ignores4, 0, 95);
        if (string == null) {
            return;
        }
        int n = string.length() - 1;
        while (n >= 0) {
            int n2 = string.charAt(n) - 32;
            if (n2 >= 0 && n2 <= 94) {
                this.ignores4[n2] = true;
            }
            --n;
        }
    }

    protected static AsciiGreyscaleTable load(File file) throws Exception {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            Object object;
            AsciiGreyscaleTable asciiGreyscaleTable = new AsciiGreyscaleTable();
            asciiGreyscaleTable.greyscales = new char[95];
            asciiGreyscaleTable.greyscales4 = new char[95][4];
            asciiGreyscaleTable.defaultIgnores = new boolean[95];
            asciiGreyscaleTable.defaultIgnores4 = new boolean[95];
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            int n5 = 0;
            while (n5 < 95) {
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new Exception("Configuration file '" + file + "' is truncated.");
                }
                object = null;
                if (string.endsWith("##")) {
                    asciiGreyscaleTable.defaultIgnores[n5] = true;
                    asciiGreyscaleTable.defaultIgnores4[n5] = true;
                    object = string.substring(2, string.length() - 2);
                } else if (string.endsWith(" #")) {
                    asciiGreyscaleTable.defaultIgnores[n5] = false;
                    asciiGreyscaleTable.defaultIgnores4[n5] = true;
                    object = string.substring(2, string.length() - 2);
                } else if (string.endsWith("#")) {
                    asciiGreyscaleTable.defaultIgnores[n5] = true;
                    asciiGreyscaleTable.defaultIgnores4[n5] = false;
                    object = string.substring(2, string.length() - 1);
                } else {
                    asciiGreyscaleTable.defaultIgnores[n5] = false;
                    asciiGreyscaleTable.defaultIgnores4[n5] = false;
                    object = string.substring(2);
                }
                try {
                    n4 = ((String)object).indexOf(32);
                    n3 = ((String)object).indexOf(32, n4 + 1);
                    n2 = ((String)object).indexOf(32, n3 + 1);
                    n = ((String)object).indexOf(32, n2 + 1);
                    asciiGreyscaleTable.greyscales[n5] = (char)Integer.parseInt(((String)object).substring(0, n4));
                    asciiGreyscaleTable.greyscales4[n5][0] = (char)Integer.parseInt(((String)object).substring(n4 + 1, n3));
                    asciiGreyscaleTable.greyscales4[n5][1] = (char)Integer.parseInt(((String)object).substring(n3 + 1, n2));
                    asciiGreyscaleTable.greyscales4[n5][2] = (char)Integer.parseInt(((String)object).substring(n2 + 1, n));
                    asciiGreyscaleTable.greyscales4[n5][3] = (char)Integer.parseInt(((String)object).substring(n + 1));
                }
                catch (Exception exception) {
                    throw new Exception("Syntax error in configuration file '" + file + "': " + string);
                }
                ++n5;
            }
            object = new Vector<String>(100);
            while ((string = bufferedReader.readLine()) != null) {
                ((Vector)object).addElement(string);
            }
            n4 = ((Vector)object).size();
            asciiGreyscaleTable.characters4 = new char[n4][5];
            n3 = 0;
            while (n3 < n4) {
                string = (String)((Vector)object).elementAt(n3);
                try {
                    n2 = string.indexOf(32);
                    n = string.indexOf(32, n2 + 1);
                    int n6 = string.indexOf(32, n + 1);
                    int n7 = string.indexOf(32, n6 + 1);
                    asciiGreyscaleTable.characters4[n3][0] = (char)Integer.parseInt(string.substring(0, n2));
                    asciiGreyscaleTable.characters4[n3][1] = (char)Integer.parseInt(string.substring(n2 + 1, n));
                    asciiGreyscaleTable.characters4[n3][2] = (char)Integer.parseInt(string.substring(n + 1, n6));
                    asciiGreyscaleTable.characters4[n3][3] = (char)Integer.parseInt(string.substring(n6 + 1, n7));
                    asciiGreyscaleTable.characters4[n3][4] = string.charAt(n7 + 1);
                }
                catch (Exception exception) {
                    throw new Exception("Syntax error in configuration file '" + file + "': " + string);
                }
                ++n3;
            }
            bufferedReader.close();
            asciiGreyscaleTable.ignores = new boolean[95];
            asciiGreyscaleTable.ignores4 = new boolean[95];
            System.arraycopy(asciiGreyscaleTable.defaultIgnores, 0, asciiGreyscaleTable.ignores, 0, 95);
            System.arraycopy(asciiGreyscaleTable.defaultIgnores4, 0, asciiGreyscaleTable.ignores4, 0, 95);
            asciiGreyscaleTable.buildCharactersForBrightness();
            return asciiGreyscaleTable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Error loading configuration file '" + file + "'.");
        }
    }

    public static AsciiGreyscaleTable getDefaultTable() {
        return AsciiGreyscaleTable.getTable(defaultTableName);
    }

    public static AsciiGreyscaleTable getTable(int n) {
        return AsciiGreyscaleTable.getTable(tableNames[n]);
    }

    public static AsciiGreyscaleTable getTable(String string) {
        return (AsciiGreyscaleTable)hashTable.get(string);
    }

    public void print() {
        int n = 0;
        while (n < 95) {
            System.out.print((char)(n + 32) + ": " + this.greyscales[n] + " " + this.greyscales4[n][0] + " " + this.greyscales4[n][1] + " " + this.greyscales4[n][2] + " " + this.greyscales4[n][3]);
            if (this.ignores[n]) {
                System.out.println(" <ignored>");
            } else {
                System.out.println();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 256) {
            System.out.println(n2 + ": " + this.characters[n2]);
            ++n2;
        }
    }

    static {
        initialized = false;
    }
}

