/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.CharacterPlate;
import de.jave.jave.PixelPlate;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Image2AsciiAlgorithmPixelPlate
extends Image2AsciiAlgorithm
implements ItemListener {
    protected Choice chStyle;
    protected static final String[] STR_STYLE = new String[]{"3by2", "2by2", "lines", "dot", "thick 8", "thick and thin"};
    protected static final int[] MODE = new int[]{13, 4, 0, 2, 6, 5};
    protected static final int[] WIDTH = new int[]{2, 2, 3, 1, 3, 3};
    protected static final int[] HEIGHT = new int[]{3, 2, 4, 2, 4, 4};

    public String getAlgorithmName() {
        return "B/W";
    }

    public Component getAdjustmentComponent() {
        this.chStyle = new Choice();
        int n = 0;
        while (n < STR_STYLE.length) {
            this.chStyle.add(STR_STYLE[n]);
            ++n;
        }
        this.chStyle.addItemListener(this);
        Panel panel = new Panel();
        panel.add(new Label("Style:", 2));
        panel.add(this.chStyle);
        return panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    public int getVerticalPixelsPerChar() {
        int n = this.chStyle.getSelectedIndex();
        return HEIGHT[n];
    }

    public int getHorizontalPixelsPerChar() {
        int n = this.chStyle.getSelectedIndex();
        return WIDTH[n];
    }

    public boolean requiresBWImage() {
        return true;
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        int n = valueRaster.getWidth();
        int n2 = valueRaster.getHeight();
        int n3 = this.chStyle.getSelectedIndex();
        if (!PixelPlate.isInitialized()) {
            PixelPlate.init();
        }
        PixelPlate pixelPlate = new PixelPlate(0, 0, n / WIDTH[n3], n2 / HEIGHT[n3]);
        pixelPlate.setMode(MODE[n3]);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                if (valueRaster.getValueAt(n5, n4) == 0) {
                    pixelPlate.set(n5, n4);
                }
                ++n5;
            }
            this.progress(0.3 + 0.7 * (double)n4 / (double)n2);
            ++n4;
        }
        CharacterPlate characterPlate = pixelPlate.getResult();
        characterPlate.replace('\u0000', ' ');
        return characterPlate;
    }
}

