/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GGreyscaleImage;
import de.jave.image.GImage;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2Texter;
import de.jave.jave.CharacterPlate;

public class ConversionThread
extends Thread {
    public boolean shallStop;
    protected GGreyscaleImage image;
    protected Image2AsciiAlgorithm algorithm;
    protected int resultWidth;
    protected double shapeFactor;
    protected boolean normalize;
    protected boolean invert;
    protected int highlight;
    protected int shadow;
    protected double gamma;
    protected double sharpen;
    protected int ditherMethode;
    protected int rotate;
    protected Image2Texter image2texter;

    public ConversionThread(GGreyscaleImage gGreyscaleImage, int n, double d, boolean bl, boolean bl2, int n2, int n3, double d2, double d3, int n4, int n5, Image2AsciiAlgorithm image2AsciiAlgorithm, Image2Texter image2Texter) {
        this.image = gGreyscaleImage;
        this.resultWidth = n;
        this.shapeFactor = d;
        this.normalize = bl;
        this.invert = bl2;
        this.shadow = n3;
        this.highlight = n2;
        this.gamma = d2;
        this.sharpen = d3;
        this.ditherMethode = n4;
        this.algorithm = image2AsciiAlgorithm;
        this.rotate = n5;
        this.image2texter = image2Texter;
        this.shallStop = false;
        this.setPriority(4);
    }

    public void breakConversion() {
        this.shallStop = true;
        this.algorithm.shallStop = true;
    }

    public void run() {
        this.algorithm.shallStop = false;
        this.algorithm.progress(0.0);
        if (this.shallStop || this.image == null || this.resultWidth == 0) {
            return;
        }
        Thread.yield();
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        Thread.yield();
        int n3 = 0;
        int n4 = 0;
        double d = this.shapeFactor * 0.52;
        if (this.rotate == 1 || this.rotate == 2) {
            n3 = this.resultWidth;
            n4 = (int)((double)n3 / (double)n2 * (double)n * d);
            if (n3 < 1) {
                n3 = 1;
            }
            if (n4 < 1) {
                n4 = 1;
            }
            n3 *= this.algorithm.getHorizontalPixelsPerChar();
            n4 *= this.algorithm.getVerticalPixelsPerChar();
        } else {
            n4 = this.resultWidth;
            n3 = (int)((double)this.resultWidth / (double)n * (double)n2 * d);
            if (n3 < 1) {
                n3 = 1;
            }
            if (n4 < 1) {
                n4 = 1;
            }
            n3 *= this.algorithm.getVerticalPixelsPerChar();
            n4 *= this.algorithm.getHorizontalPixelsPerChar();
        }
        Thread.yield();
        if (this.shallStop) {
            return;
        }
        this.image = this.image.scale(n4, n3);
        Thread.yield();
        this.algorithm.progress(0.1);
        if (this.shallStop) {
            return;
        }
        Thread.yield();
        if (this.rotate != 0) {
            this.image = (GGreyscaleImage)this.image.rotate(this.rotate);
        }
        if (this.shallStop) {
            return;
        }
        this.algorithm.progress(0.5);
        this.image = this.image.convert(this.normalize, this.invert, this.gamma, this.highlight, this.shadow);
        if (this.shallStop) {
            return;
        }
        this.algorithm.progress(0.2);
        if (this.sharpen > 0.0) {
            this.image = this.image.sharpen(this.sharpen);
            this.algorithm.progress(0.25);
        }
        Thread.yield();
        if (this.shallStop) {
            return;
        }
        GImage gImage = this.image;
        if (this.ditherMethode != -1) {
            gImage = this.image.dither(this.ditherMethode);
        }
        this.algorithm.progress(0.3);
        Thread.yield();
        if (this.shallStop) {
            return;
        }
        CharacterPlate characterPlate = this.algorithm.convert(gImage);
        this.image2texter.setResult(characterPlate);
        if (!this.shallStop) {
            this.algorithm.progress(1.0);
        }
    }
}

