/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image;

import de.jave.image.GBlackWhiteImage;
import de.jave.image.GImage;
import java.awt.Color;
import java.awt.Graphics;

public class GGreyscaleImage
extends GImage {
    protected int[][] pixels;
    protected int minValue;
    protected int maxValue;
    public static final int DITHER_THRESHOLD = 0;
    public static final int DITHER_RANDOM = 1;
    public static final int DITHER_FLOYD = 2;
    public static final int DITHER_JARVIS = 3;
    public static final int DITHER_STUCKI = 4;
    public static final int DITHER_STEVENSON = 5;
    public static final int DITHER_HALFTONING = 6;
    public static final int DITHER_BAYER8 = 7;
    public static final int DITHER_BAYER4 = 8;
    public static final int DITHER_DEFAULT = 0;
    public static final String[] STR_DITHER_METHODES = new String[]{"Threshold", "Random", "Floyd-Steinberg", "Jarvis-Judice-Ninke", "Stucki", "Stevenson-Arce", "Halftoning", "Bayer 8", "Bayer 4"};
    protected boolean minMaxValid;
    protected static final int[] INV_MASK = new int[]{-256, -65281, -16711681, 0xFFFFFF};
    public static final int[][] MATRIX_UNSHARPEN = new int[][]{{1, 2, 1}, {2, 3, 2}, {1, 2, 1}};
    public static final int[][] MATRIX_SHARPEN_MOST = new int[][]{{-1, -2, -1}, {-2, 13, -2}, {-1, -2, -1}};
    public static final int[][] MATRIX_SHARPEN_MORE = new int[][]{{-1, -1, -1}, {-1, 9, -1}, {-1, -1, -1}};
    public static final int[][] MATRIX_SHARPEN_BIG = new int[][]{{-1, -1, -1, -1, -1}, {-1, 2, 2, 2, -1}, {-1, 2, 8, 2, -1}, {-1, 2, 2, 2, -1}, {-1, -1, -1, -1, -1}};
    public static final int[][] MATRIX_LAPLACE = new int[][]{{1, 0, 1}, {0, -4, 0}, {1, 0, 1}};
    public static final int[][] MATRIX_OUTLINE = new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, -23, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1}};
    protected static final int[][] HALFTONE_MATRIX = new int[][]{{19, 25, 23, 17, 14, 8, 10, 16}, {21, 31, 29, 27, 12, 2, 4, 6}, {28, 30, 32, 22, 5, 3, 1, 11}, {18, 24, 26, 20, 15, 9, 7, 13}, {14, 8, 10, 16, 19, 25, 23, 17}, {12, 2, 4, 6, 21, 31, 29, 27}, {5, 3, 1, 11, 28, 30, 32, 22}, {15, 9, 7, 13, 18, 24, 26, 20}};
    protected static final int[][] BAYER_MATRIX8 = new int[][]{{0, 32, 8, 40, 2, 34, 10, 42}, {48, 16, 56, 24, 50, 18, 58, 26}, {12, 44, 4, 36, 14, 46, 6, 38}, {60, 28, 52, 20, 62, 30, 54, 22}, {3, 35, 11, 43, 1, 33, 9, 41}, {51, 19, 59, 27, 59, 17, 57, 25}, {15, 47, 7, 39, 13, 45, 5, 37}, {63, 31, 55, 23, 61, 29, 53, 21}};
    protected static final int[][] BAYER_MATRIX4 = new int[][]{{0, 8, 2, 10}, {12, 4, 14, 6}, {3, 11, 1, 9}, {15, 7, 13, 5}};
    protected static Color[] greyscaleColors = null;

    public GGreyscaleImage(int n, int n2) {
        this.pixels = new int[n2][(n + 3) / 4];
        this.minValue = 0;
        this.maxValue = 0;
        this.minMaxValid = true;
        this.height = n2;
        this.width = n;
    }

    public GGreyscaleImage(int[][] nArray) {
        this.height = nArray[0].length;
        this.width = nArray.length;
        this.minValue = 255;
        this.maxValue = 0;
        this.pixels = new int[this.height][(this.width + 3) / 4];
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.set(n2, n, nArray[n2][n]);
                if (nArray[n2][n] < this.minValue) {
                    this.minValue = nArray[n2][n];
                }
                if (nArray[n2][n] > this.maxValue) {
                    this.maxValue = nArray[n2][n];
                }
                ++n2;
            }
            ++n;
        }
        this.minMaxValid = true;
    }

    public GGreyscaleImage(int[] nArray, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.minValue = 255;
        this.maxValue = 0;
        this.pixels = new int[n2][(n + 3) / 4];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray[n3 * n + n4];
                int n6 = (299 * (n5 >> 16 & 0xFF) + 587 * (n5 >> 8 & 0xFF) + 114 * (n5 & 0xFF)) / 1000;
                this.set(n4, n3, n6);
                if (n6 < this.minValue) {
                    this.minValue = n6;
                }
                if (n6 > this.maxValue) {
                    this.maxValue = n6;
                }
                ++n4;
            }
            ++n3;
        }
        this.minMaxValid = true;
    }

    public final void set(int n, int n2, int n3) {
        this.minMaxValid = false;
        int[] nArray = this.pixels[n2];
        int n4 = n / 4;
        nArray[n4] = nArray[n4] & INV_MASK[n % 4];
        int[] nArray2 = this.pixels[n2];
        int n5 = n / 4;
        nArray2[n5] = nArray2[n5] | n3 << 8 * (n % 4);
    }

    public final int get(int n, int n2) {
        return this.pixels[n2][n / 4] >> 8 * (n % 4) & 0xFF;
    }

    public int getNormalizingFactor() {
        return 1;
    }

    public int getMaxPossibleValue() {
        return 255;
    }

    public GGreyscaleImage convert(boolean bl, boolean bl2, double d, double d2, double d3) {
        if (this.pixels == null) {
            return null;
        }
        int n = 0;
        int n2 = 255;
        if (bl) {
            n = this.getMinValue();
            n2 = this.getMaxValue();
        }
        double d4 = 1.0 / d;
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(this.width, this.height);
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                double d5 = (double)(this.get(n4, n3) - n) / (double)(n2 - n);
                if (bl2) {
                    d5 = 1.0 - d5;
                }
                d5 = Math.min(d5 * 100.0 / d2, 1.0);
                d5 = Math.max((d5 - d3 / 100.0) * (100.0 / (100.0 - d3)), 0.0);
                d5 = Math.pow(d5, d4);
                gGreyscaleImage.set(n4, n3, (int)(255.0 * d5));
                ++n4;
            }
            ++n3;
        }
        return gGreyscaleImage;
    }

    public GGreyscaleImage scaleX(int n) {
        double d = (double)n / (double)this.width;
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(n, this.height);
        if (d >= 1.0) {
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = 0;
                while (n3 < n) {
                    gGreyscaleImage.set(n3, n2, this.getValueAt((double)n3 / d, n2));
                    ++n3;
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < this.height) {
                int n5 = 0;
                while (n5 < n) {
                    gGreyscaleImage.set(n5, n4, this.getValueAt((double)n5 / d, ((double)n5 + 1.0) / d, n4));
                    ++n5;
                }
                ++n4;
            }
        }
        return gGreyscaleImage;
    }

    public GGreyscaleImage scaleY(int n) {
        double d = (double)n / (double)this.height;
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(this.width, n);
        if (d >= 1.0) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < this.width) {
                    gGreyscaleImage.set(n3, n2, this.getValueAt(n3, (double)n2 / d));
                    ++n3;
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < this.width) {
                    gGreyscaleImage.set(n5, n4, this.getValueAt(n5, (double)n4 / d, ((double)n4 + 1.0) / d));
                    ++n5;
                }
                ++n4;
            }
        }
        return gGreyscaleImage;
    }

    public int getMinValue() {
        if (!this.minMaxValid) {
            this.determineValues();
        }
        return this.minValue;
    }

    public int getMaxValue() {
        if (!this.minMaxValid) {
            this.determineValues();
        }
        return this.maxValue;
    }

    protected void determineValues() {
        this.minValue = this.get(0, 0);
        this.maxValue = this.get(0, 0);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = this.get(n2, n);
                if (n3 > this.maxValue) {
                    this.maxValue = n3;
                }
                if (n3 < this.minValue) {
                    this.minValue = n3;
                }
                ++n2;
            }
            ++n;
        }
        this.minMaxValid = true;
    }

    public GBlackWhiteImage dither() {
        return this.dither(0);
    }

    public GBlackWhiteImage dither(int n) {
        switch (n) {
            case 0: {
                return this.ditherThreshold();
            }
            case 1: {
                return this.ditherRandom();
            }
            case 2: {
                return this.ditherFloydSteinberg();
            }
            case 3: {
                return this.ditherJarvisJudiceNinke();
            }
            case 4: {
                return this.ditherStucki();
            }
            case 5: {
                return this.ditherStevensonArce();
            }
            case 6: {
                return this.ditherHalftone();
            }
            case 7: {
                return this.ditherBayer8();
            }
            case 8: {
                return this.ditherBayer4();
            }
        }
        throw new IllegalArgumentException("No such dither methode: " + n);
    }

    public GBlackWhiteImage ditherJarvisJudiceNinke() {
        this.seed();
        int n = 128;
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = this.getMaxValue();
        int n3 = this.getMinValue();
        if (n2 == n3) {
            ++n2;
        }
        double d = 255.0 / (double)(n2 - n3);
        int[][] nArray = new int[this.width + 4][3];
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = n4 % 3;
            int n6 = (n4 + 1) % 3;
            int n7 = (n4 + 2) % 3;
            int n8 = 0;
            while (n8 < this.width) {
                double d2 = 0.0;
                d2 += 0.020833333333333332 * (double)nArray[n8][n5];
                d2 += 0.0625 * (double)nArray[n8 + 1][n5];
                d2 += 0.10416666666666667 * (double)nArray[n8 + 2][n5];
                d2 += 0.0625 * (double)nArray[n8 + 3][n5];
                d2 += 0.020833333333333332 * (double)nArray[n8 + 4][n5];
                d2 += 0.0625 * (double)nArray[n8][n6];
                d2 += 0.10416666666666667 * (double)nArray[n8 + 1][n6];
                d2 += 0.14583333333333334 * (double)nArray[n8 + 2][n6];
                d2 += 0.10416666666666667 * (double)nArray[n8 + 3][n6];
                d2 += 0.0625 * (double)nArray[n8 + 4][n6];
                d2 += 0.10416666666666667 * (double)nArray[n8][n7];
                int n9 = (int)((double)(this.get(n8, n4) - n3) * d - (d2 += 0.14583333333333334 * (double)nArray[n8 + 1][n7]));
                if (n9 >= (n = 96 + GImage.random(65))) {
                    gBlackWhiteImage.set(n8, n4, 1);
                } else {
                    gBlackWhiteImage.set(n8, n4, 0);
                }
                nArray[n8 + 2][n7] = gBlackWhiteImage.get(n8, n4) - this.get(n8, n4);
                ++n8;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherStucki() {
        this.seed();
        int n = 128;
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = this.getMaxValue();
        int n3 = this.getMinValue();
        if (n2 == n3) {
            ++n2;
        }
        double d = 255.0 / (double)(n2 - n3);
        int[][] nArray = new int[this.width + 4][3];
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = n4 % 3;
            int n6 = (n4 + 1) % 3;
            int n7 = (n4 + 2) % 3;
            int n8 = 0;
            while (n8 < this.width) {
                double d2 = 0.0;
                d2 += 0.023809523809523808 * (double)nArray[n8][n5];
                d2 += 0.047619047619047616 * (double)nArray[n8 + 1][n5];
                d2 += 0.09523809523809523 * (double)nArray[n8 + 2][n5];
                d2 += 0.047619047619047616 * (double)nArray[n8 + 3][n5];
                d2 += 0.023809523809523808 * (double)nArray[n8 + 4][n5];
                d2 += 0.047619047619047616 * (double)nArray[n8][n6];
                d2 += 0.09523809523809523 * (double)nArray[n8 + 1][n6];
                d2 += 0.19047619047619047 * (double)nArray[n8 + 2][n6];
                d2 += 0.09523809523809523 * (double)nArray[n8 + 3][n6];
                d2 += 0.047619047619047616 * (double)nArray[n8 + 4][n6];
                d2 += 0.09523809523809523 * (double)nArray[n8][n7];
                int n9 = (int)((double)(this.get(n8, n4) - n3) * d - (d2 += 0.19047619047619047 * (double)nArray[n8 + 1][n7]));
                if (n9 >= (n = 96 + GImage.random(65))) {
                    gBlackWhiteImage.set(n8, n4, 1);
                } else {
                    gBlackWhiteImage.set(n8, n4, 0);
                }
                nArray[n8 + 2][n7] = gBlackWhiteImage.get(n8, n4) - this.get(n8, n4);
                ++n8;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherStevensonArce() {
        this.seed();
        int n = 128;
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = this.getMaxValue();
        int n3 = this.getMinValue();
        if (n2 == n3) {
            ++n2;
        }
        double d = 255.0 / (double)(n2 - n3);
        int[][] nArray = new int[this.width + 6][4];
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = n4 % 4;
            int n6 = (n4 + 1) % 4;
            int n7 = (n4 + 2) % 4;
            int n8 = (n4 + 3) % 4;
            int n9 = 0;
            while (n9 < this.width) {
                double d2 = 0.0;
                d2 += 0.025 * (double)nArray[n9][n5];
                d2 += 0.06 * (double)nArray[n9 + 2][n5];
                d2 += 0.06 * (double)nArray[n9 + 4][n5];
                d2 += 0.025 * (double)nArray[n9 + 6][n5];
                d2 += 0.06 * (double)nArray[n9 + 1][n6];
                d2 += 0.13 * (double)nArray[n9 + 3][n6];
                d2 += 0.06 * (double)nArray[n9 + 5][n6];
                d2 += 0.08 * (double)nArray[n9][n7];
                d2 += 0.15 * (double)nArray[n9 + 2][n7];
                d2 += 0.13 * (double)nArray[n9 + 4][n7];
                d2 += 0.06 * (double)nArray[n9 + 6][n7];
                int n10 = (int)((double)(this.get(n9, n4) - n3) * d - (d2 += 0.16 * (double)nArray[n9 + 1][n8]));
                if (n10 >= (n = 96 + GImage.random(65))) {
                    gBlackWhiteImage.set(n9, n4, 1);
                } else {
                    gBlackWhiteImage.set(n9, n4, 0);
                }
                nArray[n9 + 3][n8] = gBlackWhiteImage.get(n9, n4) - this.get(n9, n4);
                ++n9;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherFloydSteinberg() {
        this.seed();
        int n = 128;
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = this.getMaxValue();
        int n3 = this.getMinValue();
        if (n2 == n3) {
            ++n2;
        }
        double d = 255.0 / (double)(n2 - n3);
        int[][] nArray = new int[this.width + 4][3];
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = n4 % 3;
            int n6 = (n4 + 1) % 3;
            int n7 = (n4 + 2) % 3;
            int n8 = 0;
            while (n8 < this.width) {
                double d2 = 0.0;
                d2 += 0.0625 * (double)nArray[n8 + 1][n6];
                d2 += 0.3125 * (double)nArray[n8 + 2][n6];
                d2 += 0.1875 * (double)nArray[n8 + 3][n6];
                int n9 = (int)((double)(this.get(n8, n4) - n3) * d - (d2 += 0.4375 * (double)nArray[n8 + 1][n7]));
                if (n9 >= (n = 96 + GImage.random(65))) {
                    gBlackWhiteImage.set(n8, n4, 1);
                } else {
                    gBlackWhiteImage.set(n8, n4, 0);
                }
                nArray[n8 + 2][n7] = gBlackWhiteImage.get(n8, n4) - this.get(n8, n4);
                ++n8;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherRandom() {
        this.seed();
        int n = 128;
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = this.getMaxValue();
        int n3 = this.getMinValue();
        if (n2 == n3) {
            ++n2;
        }
        double d = 255.0 / (double)(n2 - n3);
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = 0;
            while (n5 < this.width) {
                int n6 = (int)((double)(this.get(n5, n4) - n3) * d);
                if (n6 >= (n = 96 + GImage.random(129))) {
                    gBlackWhiteImage.set(n5, n4, 1);
                } else {
                    gBlackWhiteImage.set(n5, n4, 0);
                }
                ++n5;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherThreshold() {
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n = this.getMaxValue();
        int n2 = this.getMinValue();
        int n3 = (n + n2) / 2;
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = 0;
            while (n5 < this.width) {
                if (this.get(n5, n4) >= n3) {
                    gBlackWhiteImage.set(n5, n4, 1);
                } else {
                    gBlackWhiteImage.set(n5, n4, 0);
                }
                ++n5;
            }
            ++n4;
        }
        return gBlackWhiteImage;
    }

    protected GImage createGImage(int n, int n2) {
        return new GGreyscaleImage(n, n2);
    }

    public GImage getClone() {
        int n = (this.width + 3) / 4;
        int[][] nArray = new int[this.height][n];
        int n2 = 0;
        while (n2 < this.height) {
            System.arraycopy(this.pixels[n2], 0, nArray[n2], 0, n);
            ++n2;
        }
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(0, 0);
        gGreyscaleImage.pixels = nArray;
        gGreyscaleImage.minValue = this.minValue;
        gGreyscaleImage.maxValue = this.maxValue;
        gGreyscaleImage.minMaxValid = this.minMaxValid;
        gGreyscaleImage.width = this.width;
        gGreyscaleImage.height = this.height;
        return gGreyscaleImage;
    }

    public GGreyscaleImage sharpenMore() {
        return this.convolve(MATRIX_SHARPEN_MORE, 1.0, 0.0);
    }

    public GGreyscaleImage sharpenBig() {
        return this.convolve(MATRIX_SHARPEN_BIG, 8.0, 0.0);
    }

    public GGreyscaleImage filterLaplace() {
        return this.convolve(MATRIX_LAPLACE, 1.0, 0.0);
    }

    public GGreyscaleImage filterOutline() {
        return this.convolve(MATRIX_OUTLINE, 1.0, 0.0);
    }

    public GGreyscaleImage filterOutline(double d) {
        if (d == 0.0) {
            return this;
        }
        return this.convolve(MATRIX_OUTLINE, 1.0, 1.0 - d);
    }

    public GGreyscaleImage sharpen() {
        return this.convolve(MATRIX_SHARPEN_MOST, 1.0, 0.0);
    }

    public GGreyscaleImage sharpen(double d) {
        if (d == 0.0) {
            return this;
        }
        return this.convolve(MATRIX_SHARPEN_MOST, 1.0, 1.0 - d);
    }

    public GGreyscaleImage unsharpen(double d) {
        return this.convolve(MATRIX_UNSHARPEN, 15.0, 1.0 - d);
    }

    public void brighten(double d) {
        if (d == 0.0) {
            return;
        }
        double d2 = 1.0;
        if ((d += 1.0) < 0.1) {
            d = 0.1;
        }
        d2 = 1.0 / d;
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = (int)Math.pow(this.get(n2, n), d2);
                if (n3 > 255) {
                    n3 = 255;
                }
                this.set(n2, n, n3);
                ++n2;
            }
            ++n;
        }
    }

    public GBlackWhiteImage threshold(int n) {
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (this.get(n3, n2) >= n) {
                    gBlackWhiteImage.set(n3, n2, 1);
                }
                ++n3;
            }
            ++n2;
        }
        return gBlackWhiteImage;
    }

    public int countPixels(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if (this.get(n4, n3) == n) {
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        return n2;
    }

    public int countPixelsWithMaxValue(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if (this.get(n4, n3) <= n) {
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        return n2;
    }

    public GBlackWhiteImage threshold() {
        int n = this.getMaxValue();
        int n2 = this.getMinValue();
        return this.threshold((n + n2) / 2);
    }

    public GBlackWhiteImage threshold(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < this.height) {
            n4 = 0;
            while (n4 < this.width) {
                if (this.get(n4, n5) > n2) {
                    this.set(n4, n5, 255);
                } else if (this.get(n4, n5) < n) {
                    this.set(n4, n5, 0);
                } else {
                    this.set(n4, n5, 127);
                }
                ++n4;
            }
            ++n5;
        }
        n4 = 0;
        while (n4 == 0) {
            n4 = 1;
            int n6 = 0;
            while (n6 < this.height) {
                n3 = 0;
                while (n3 < this.width) {
                    if (this.get(n3, n6) < n) {
                        if (n3 > 0 && this.get(n3 - 1, n6) == 127) {
                            this.set(n3 - 1, n6, 64);
                            n4 = 0;
                        }
                        if (n6 > 0 && this.get(n3, n6 - 1) == 127) {
                            this.set(n3, n6 - 1, 64);
                            n4 = 0;
                        }
                        if (n3 + 1 < this.width && this.get(n3 + 1, n6) == 127) {
                            this.set(n3 + 1, n6, 64);
                            n4 = 0;
                        }
                        if (n6 + 1 < this.height && this.get(n3, n6 + 1) == 127) {
                            this.set(n3, n6 + 1, 64);
                            n4 = 0;
                        }
                    }
                    ++n3;
                }
                ++n6;
            }
        }
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        n3 = 0;
        while (n3 < this.height) {
            int n7 = 0;
            while (n7 < this.width) {
                if (this.get(n7, n3) == 255) {
                    gBlackWhiteImage.set(n7, n3, 1);
                } else if (this.get(n7, n3) == 127) {
                    this.set(n7, n3, 255);
                }
                ++n7;
            }
            ++n3;
        }
        this.minValue = 0;
        this.maxValue = 255;
        this.minMaxValid = true;
        return gBlackWhiteImage;
    }

    public GGreyscaleImage convolve(int[][] nArray, double d, double d2) {
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(this.width, this.height);
        int n = nArray.length;
        int n2 = nArray[0].length;
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = 0;
            while (n6 < this.width) {
                int n7;
                int n8 = 0;
                int n9 = -n3;
                while (n9 <= n3) {
                    n7 = -n4;
                    while (n7 <= n4) {
                        int n10 = n6 + n9;
                        if (n10 < 0) {
                            n10 = 0;
                        } else if (n10 >= this.width) {
                            n10 = this.width - 1;
                        }
                        int n11 = n5 + n7;
                        if (n11 < 0) {
                            n11 = 0;
                        } else if (n11 >= this.height) {
                            n11 = this.height - 1;
                        }
                        int n12 = this.get(n10, n11);
                        int n13 = nArray[n3 + n9][n4 + n7];
                        n8 += n12 * n13;
                        ++n7;
                    }
                    ++n9;
                }
                n7 = (int)(d2 * (double)this.get(n6, n5) + (1.0 - d2) * (double)n8 / d);
                if (n7 > 255) {
                    gGreyscaleImage.set(n6, n5, 255);
                } else if (n7 < 0) {
                    gGreyscaleImage.set(n6, n5, 0);
                } else {
                    gGreyscaleImage.set(n6, n5, n7);
                }
                ++n6;
            }
            ++n5;
        }
        return gGreyscaleImage;
    }

    public GBlackWhiteImage ditherHalftone() {
        int n = this.getMinValue();
        int n2 = this.getMaxValue();
        if (n2 == n) {
            ++n2;
        }
        double d = 32.0 / (double)(n2 - n);
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if ((double)(this.get(n4, n3) - n) * d >= (double)HALFTONE_MATRIX[n4 % 8][n3 % 8]) {
                    gBlackWhiteImage.set(n4, n3, 1);
                } else {
                    gBlackWhiteImage.set(n4, n3, 0);
                }
                ++n4;
            }
            ++n3;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherBayer8() {
        int n = this.getMinValue();
        int n2 = this.getMaxValue();
        if (n2 == n) {
            ++n2;
        }
        double d = 63.0 / (double)(n2 - n);
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if ((double)(this.get(n4, n3) - n) * d >= (double)BAYER_MATRIX8[n4 % 8][n3 % 8]) {
                    gBlackWhiteImage.set(n4, n3, 1);
                } else {
                    gBlackWhiteImage.set(n4, n3, 0);
                }
                ++n4;
            }
            ++n3;
        }
        return gBlackWhiteImage;
    }

    public GBlackWhiteImage ditherBayer4() {
        int n = this.getMinValue();
        int n2 = this.getMaxValue();
        if (n2 == n) {
            ++n2;
        }
        double d = 15.0 / (double)(n2 - n);
        GBlackWhiteImage gBlackWhiteImage = new GBlackWhiteImage(this.width, this.height);
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                if ((double)(this.get(n4, n3) - n) * d >= (double)BAYER_MATRIX4[n4 % 4][n3 % 4]) {
                    gBlackWhiteImage.set(n4, n3, 1);
                } else {
                    gBlackWhiteImage.set(n4, n3, 0);
                }
                ++n4;
            }
            ++n3;
        }
        return gBlackWhiteImage;
    }

    public GGreyscaleImage scale(int n, int n2) {
        double d = (double)n / (double)this.width;
        double d2 = (double)n2 / (double)this.height;
        if (d >= d2) {
            GGreyscaleImage gGreyscaleImage = this.scaleX(n);
            return gGreyscaleImage.scaleY(n2);
        }
        GGreyscaleImage gGreyscaleImage = this.scaleY(n2);
        return gGreyscaleImage.scaleX(n);
    }

    public GGreyscaleImage scaleX(double d) {
        int n = (int)((double)this.width * d);
        return this.scaleX(n);
    }

    public GGreyscaleImage scaleY(double d) {
        int n = (int)((double)this.height * d);
        return this.scaleY(n);
    }

    public GGreyscaleImage scale(double d, double d2) {
        int n = (int)((double)this.width * d);
        int n2 = (int)((double)this.height * d2);
        if (d >= d2) {
            GGreyscaleImage gGreyscaleImage = this.scaleX(n);
            return gGreyscaleImage.scaleY(n2);
        }
        GGreyscaleImage gGreyscaleImage = this.scaleY(n2);
        return gGreyscaleImage.scaleX(n);
    }

    public int getValueAt(double d, double d2, int n) {
        int n2 = 0;
        int n3 = this.height - 1;
        if (n > n3 || n < n2) {
            return 0;
        }
        double d3 = 0.0;
        double d4 = this.width;
        if (d2 < d3 || d > d4) {
            return 0;
        }
        if (d < d3) {
            d = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        double d5 = 0.0;
        int n4 = (int)Math.ceil(d);
        int n5 = (int)Math.floor(d2);
        int n6 = n4;
        while (n6 < n5) {
            d5 += (double)this.get(n6, n);
            ++n6;
        }
        if ((double)n4 > d) {
            d5 += ((double)n4 - d) * (double)this.get((int)Math.floor(d), n);
        }
        if ((double)n5 < d2) {
            d5 += (d2 - (double)n5) * (double)this.get(n5, n);
        }
        return (int)(d5 / (d2 - d));
    }

    public int getValueAt(int n, double d, double d2) {
        int n2 = 0;
        int n3 = this.width - 1;
        if (n > n3 || n < n2) {
            return 0;
        }
        double d3 = 0.0;
        double d4 = this.height;
        if (d2 < d3 || d > d4) {
            return 0;
        }
        if (d < d3) {
            d = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        double d5 = 0.0;
        int n4 = (int)Math.ceil(d);
        int n5 = (int)Math.floor(d2);
        int n6 = n4;
        while (n6 < n5) {
            d5 += (double)this.get(n, n6);
            ++n6;
        }
        if ((double)n4 > d) {
            d5 += ((double)n4 - d) * (double)this.get(n, (int)Math.floor(d));
        }
        if ((double)n5 < d2) {
            d5 += (d2 - (double)n5) * (double)this.get(n, n5);
        }
        return (int)(d5 / (d2 - d));
    }

    public int getValueAt(double d, int n) {
        int n2;
        double d2;
        if (d > (double)(this.width - 1)) {
            d = this.width - 1;
        }
        if ((d2 = d - (double)(n2 = (int)d)) == 0.0) {
            return this.get(n2, n);
        }
        return (int)((double)this.get(n2, n) * (1.0 - d2) + (double)this.get(n2 + 1, n) * d2);
    }

    public int getValueAt(int n, double d) {
        int n2;
        double d2;
        if (d > (double)(this.getHeight() - 1)) {
            d = this.getHeight() - 1;
        }
        if ((d2 = d - (double)(n2 = (int)d)) == 0.0) {
            return this.get(n, n2);
        }
        return (int)((double)this.get(n, n2) * (1.0 - d2) + (double)this.get(n, n2 + 1) * d2);
    }

    public int getValueAt(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            return 0;
        }
        if (d >= (double)this.width || d2 >= (double)this.height) {
            return 0;
        }
        if (d > (double)(this.width - 1)) {
            d = this.width - 1;
        }
        if (d2 > (double)(this.height - 1)) {
            d2 = this.height - 1;
        }
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        if (d3 == 0.0 && d4 == 0.0) {
            return this.get(n, n2);
        }
        if (d3 == 0.0) {
            return (int)((double)this.get(n, n2) * (1.0 - d4) + (double)this.get(n, n2 + 1) * d4);
        }
        if (d4 == 0.0) {
            return (int)((double)this.get(n, n2) * (1.0 - d3) + (double)this.get(n + 1, n2) * d3);
        }
        return (int)((1.0 - d4) * ((double)this.get(n, n2) * (1.0 - d3) + (double)this.get(n + 1, n2) * d3) + d4 * ((double)this.get(n, n2 + 1) * (1.0 - d3) + (double)this.get(n + 1, n2 + 1) * d3));
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        if (this.pixels == null) {
            return;
        }
        if (greyscaleColors == null) {
            greyscaleColors = new Color[256];
            n3 = 0;
            while (n3 < 256) {
                GGreyscaleImage.greyscaleColors[n3] = new Color(n3, n3, n3);
                ++n3;
            }
        }
        n3 = this.getMaxValue();
        graphics.setColor(greyscaleColors[n3]);
        graphics.fillRect(n, n, this.width, this.height);
        int n4 = this.height - 1;
        while (n4 >= 0) {
            int n5 = this.width - 1;
            while (n5 >= 0) {
                int n6 = this.get(n5, n4);
                if (n6 != n3) {
                    graphics.setColor(greyscaleColors[n6]);
                    graphics.drawLine(n + n5, n2 + n4, n + n5, n2 + n4);
                }
                --n5;
            }
            --n4;
        }
    }
}

