/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class SmallFrameTitleBar
extends Canvas
implements MouseListener,
MouseMotionListener {
    protected Point lastP;
    protected static final Font FONT = new Font("Dialog", 1, 10);
    protected String title;

    public SmallFrameTitleBar(String string) {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setFont(FONT);
        this.title = string;
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 14);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(0, 0, dimension.width - 2, 0);
        graphics.drawLine(0, 1, 0, dimension.height - 1);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(1, 1, dimension.width - 3, 1);
        graphics.drawLine(1, 2, 1, dimension.height - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(SystemColor.activeCaption);
        graphics.fillRect(2, 2, dimension.width - 4, dimension.height - 3);
        graphics.setColor(SystemColor.window);
        graphics.drawLine(2, dimension.height - 1, dimension.width - 3, dimension.height - 1);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = dimension.width - 3;
        String string = this.title;
        if (fontMetrics.stringWidth(string) + 4 > n) {
            while (string.length() > 3 && fontMetrics.stringWidth(string + "...") + 4 > n) {
                string = string.substring(0, string.length() - 1);
            }
            string = string + "...";
        }
        graphics.setColor(SystemColor.activeCaptionText);
        graphics.drawString(string, 4, 11);
    }

    protected void moveWindow(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        Container container = this.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        if (container == null) {
            return;
        }
        Point point = container.getLocationOnScreen();
        container.setLocation(point.x + n, point.y + n2);
    }

    protected Window getParentWindow() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastP = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Window window = this.getParentWindow();
        if (window == null) {
            this.lastP = null;
            return;
        }
        Point point2 = window.getLocationOnScreen();
        this.lastP = new Point(point.x + point2.x, point.y + point2.y);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastP == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Window window = this.getParentWindow();
        if (window == null) {
            this.lastP = null;
            return;
        }
        Point point2 = window.getLocationOnScreen();
        Point point3 = new Point(point.x + point2.x, point.y + point2.y);
        this.moveWindow(point3.x - this.lastP.x, point3.y - this.lastP.y);
        this.lastP = point3;
    }
}

