/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GTreeCanvas;
import de.jave.gui.GTreeEntry;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class GTree
extends ScrollPane
implements ItemSelectable {
    protected GTreeCanvas canvas;
    protected GTreeEntry selectedEntry;
    transient ItemListener itemListener;
    transient ActionListener actionListener;
    protected boolean labelsEditable;

    public GTree(GTreeEntry gTreeEntry) {
        super(0);
        this.canvas = new GTreeCanvas(this, gTreeEntry);
        this.add(this.canvas);
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setUnitIncrement(16);
        Adjustable adjustable2 = this.getHAdjustable();
        adjustable2.setUnitIncrement(5);
        this.labelsEditable = true;
        this.setSize(200, 400);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void select(GTreeEntry gTreeEntry) {
        if (gTreeEntry == this.selectedEntry) {
            return;
        }
        if (this.selectedEntry != null) {
            this.selectedEntry.select(false);
        }
        if (gTreeEntry == null) {
            return;
        }
        gTreeEntry.select(true);
        this.selectedEntry = gTreeEntry;
        this.canvas.selectionOrLabelChanged = true;
        this.repaint();
        this.ensureVisible(this.selectedEntry);
        this.processItemEvent(new ItemEvent(this, 701, this.selectedEntry, 1));
    }

    public void ensureVisible(GTreeEntry gTreeEntry) {
        Vector vector = new Vector();
        this.canvas.root.getVisibleTreeEntries(vector);
        int n = vector.indexOf(gTreeEntry);
        if (n == -1) {
            return;
        }
        this.ensureVisible(n);
    }

    public void ensureVisible(int n) {
        int n2 = n * 16;
        Point point = this.getScrollPosition();
        Dimension dimension = this.getViewportSize();
        if (n2 < point.y) {
            this.setScrollPosition(point.x, n2);
        } else if (n2 > point.y + dimension.height - 16) {
            this.setScrollPosition(point.x, n2 - dimension.height + 16);
        }
    }

    public Vector getVisibleEntries() {
        return this.canvas.getVisibleEntries();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.selectedEntry == null) {
            return null;
        }
        Object[] objectArray = new Object[]{this.selectedEntry};
        return objectArray;
    }

    public GTreeEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public GTreeEntry getSelectedItem() {
        return this.selectedEntry;
    }

    public void debug() {
        System.err.println("Tree{ labelsEditable=" + this.labelsEditable);
        this.canvas.getRoot().debug(" ");
        System.err.println("}");
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public GTreeEntry getRoot() {
        return this.canvas.getRoot();
    }

    public void add(GTreeEntry gTreeEntry, GTreeEntry gTreeEntry2) {
        gTreeEntry.add(gTreeEntry2);
        this.canvas.visibleEntriesModified = true;
        this.canvas.selectionOrLabelChanged = true;
        this.canvas.invalidate();
        super.validate();
        this.canvas.repaint();
    }

    public void removeAll(GTreeEntry gTreeEntry) {
        gTreeEntry.removeAll();
        this.canvas.visibleEntriesModified = true;
        this.canvas.selectionOrLabelChanged = true;
        this.canvas.invalidate();
        super.validate();
        this.canvas.repaint();
    }

    public void repaintAll() {
        this.canvas.visibleEntriesModified = true;
        this.canvas.selectionOrLabelChanged = true;
        this.canvas.invalidate();
        super.validate();
        this.canvas.repaint();
    }

    public void edit(final GTreeEntry gTreeEntry) {
        if (gTreeEntry.getBounds() == null) {
            new Thread(){

                public void run() {
                    while (gTreeEntry.getBounds() == null) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    GTree.this.ensureVisible(gTreeEntry);
                    GTree.this.select(gTreeEntry);
                    GTree.this.canvas.edit(gTreeEntry);
                }
            }.start();
            return;
        }
        this.ensureVisible(gTreeEntry);
        this.select(gTreeEntry);
        this.canvas.edit(gTreeEntry);
    }

    public void setRoot(GTreeEntry gTreeEntry) {
        this.canvas.setRoot(gTreeEntry);
        this.repaintAll();
    }

    public void repaint() {
        if (this.canvas.visibleEntriesModified) {
            this.doLayout();
        }
        this.canvas.repaint();
    }

    public void repaint(long l) {
        this.canvas.repaint(l);
    }

    public void setLabel(GTreeEntry gTreeEntry, String string) {
        gTreeEntry.setTreeLabel(string);
        this.canvas.selectionOrLabelChanged = true;
        this.repaint();
    }

    public void toggleTreeExpansion(GTreeEntry gTreeEntry) {
        this.canvas.visibleEntriesModified = true;
        gTreeEntry.toggleTreeExpansion();
        this.repaint();
    }

    public void setTreeExpanded(GTreeEntry gTreeEntry, boolean bl) {
        this.canvas.visibleEntriesModified = true;
        gTreeEntry.setTreeExpanded(bl);
        this.repaint();
    }

    public boolean isLabelsEditable() {
        return this.labelsEditable;
    }

    public void setLabelsEditable(boolean bl) {
        this.labelsEditable = bl;
    }
}

