/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.StatusDisplay;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;

public class GTextArea
extends TextArea
implements KeyListener,
MouseListener {
    private boolean searching;
    private String search;
    private String text;
    private StatusDisplay status;
    private int direction;
    private static final int FORWARDS = 1;
    private static final int BACKWARDS = 2;
    private boolean hardEditable = true;

    public boolean isFocusTraversable() {
        return this.hardEditable;
    }

    public GTextArea() {
        this.init();
    }

    public GTextArea(String string) {
        super(string);
        this.init();
    }

    public GTextArea(String string, int n) {
        super(string, 0, 0, n);
        this.init();
    }

    public GTextArea(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public GTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.init();
    }

    public GTextArea(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
        this.init();
    }

    private void init() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.searching = false;
        this.search = "";
    }

    public synchronized void setEditable(boolean bl) {
        this.hardEditable = bl;
        if (this.searching) {
            this.stopSearch();
        } else {
            super.setEditable(bl);
        }
    }

    public void setStatusDisplay(StatusDisplay statusDisplay) {
        this.status = statusDisplay;
    }

    private void fontSizeUp() {
        Font font = this.getFont();
        int n = font.getSize() + 1;
        if (n > 30) {
            return;
        }
        Font font2 = new Font(font.getName(), font.getStyle(), n);
        String string = this.getText();
        this.setFont(font2);
        this.repaint();
    }

    private void fontSizeDown() {
        Font font = this.getFont();
        int n = font.getSize() - 1;
        if (n < 4) {
            return;
        }
        Font font2 = new Font(font.getName(), font.getStyle(), n);
        this.setFont(font2);
        this.repaint();
    }

    public void trim() {
        int n;
        String string = this.getText();
        if (string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("\n") && !string2.equals("\r")) {
                n = string2.length() - 1;
                while (n >= 0 && string2.charAt(n) <= ' ') {
                    --n;
                }
                string2 = string2.substring(0, n + 1);
            }
            stringBuffer.append(string2);
        }
        string = stringBuffer.toString();
        int n2 = 0;
        n = string.charAt(0);
        while (n2 < string.length() - 1 && (n == 10 || n == 13)) {
            n = string.charAt(++n2);
        }
        int n3 = string.length() - 1;
        n = string.charAt(n3);
        while (n3 > n2 && (n == 10 || n == 13)) {
            n = string.charAt(--n3);
        }
        this.setText(string.substring(n2, n3 + 1));
    }

    private void stopSearch() {
        this.searching = false;
        super.setEditable(this.hardEditable);
    }

    private void startSearch() {
        this.text = this.getText().toLowerCase();
        this.searching = true;
        this.search = "";
        super.setEditable(false);
    }

    private void findNext(String string) {
        int n;
        int n2 = this.getCaretPosition();
        if (this.getSelectionEnd() - this.getSelectionStart() == string.length()) {
            ++n2;
        }
        if ((n = this.text.indexOf(string, n2)) == -1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.search = string;
        if (this.status != null) {
            this.status.showStatus(this.search);
        }
        this.setSelectionStart(n);
        this.setSelectionEnd(n + this.search.length());
    }

    private void findPrev(String string) {
        int n;
        int n2 = this.getCaretPosition();
        if (this.getSelectionEnd() - this.getSelectionStart() == string.length()) {
            --n2;
        }
        if ((n = this.text.lastIndexOf(string, n2)) == -1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.search = string;
        if (this.status != null) {
            this.status.showStatus(this.search);
        }
        this.setSelectionStart(n);
        this.setSelectionEnd(n + this.search.length());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            if (keyEvent.getKeyChar() == '9') {
                this.fontSizeUp();
            } else if (keyEvent.getKeyChar() == '8') {
                this.fontSizeDown();
            }
        }
        if (!this.searching) {
            return;
        }
        if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 27) {
            this.stopSearch();
            return;
        }
        if (keyEvent.getKeyCode() == 8) {
            if (this.search.length() <= 1) {
                this.stopSearch();
                keyEvent.consume();
                return;
            }
            this.search = this.search.substring(0, this.search.length() - 1);
            if (this.direction == 2) {
                this.findPrev(this.search);
            } else {
                this.findNext(this.search);
            }
            keyEvent.consume();
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            if (keyEvent.getKeyChar() == '\u0001') {
                this.stopSearch();
                this.selectAll();
                keyEvent.consume();
            } else if (keyEvent.getKeyChar() == '\u0012') {
                this.direction = 2;
                if (this.searching) {
                    this.findPrev(this.search);
                } else {
                    this.startSearch();
                }
                keyEvent.consume();
            } else if (keyEvent.getKeyChar() == '\u0013') {
                this.direction = 1;
                if (this.searching) {
                    this.findNext(this.search);
                } else {
                    this.startSearch();
                }
                keyEvent.consume();
            } else {
                this.stopSearch();
            }
            return;
        }
        if (!this.searching) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            keyEvent.consume();
            return;
        }
        if (!Character.isJavaIdentifierPart(c) && " @|<>!\"\u00a7$%&/()=?`\u00b4*+^\u00b0~#\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc-+[]{}\u00b5,.;:'\u00b2\u00b3\\\u00df".indexOf(c) == -1) {
            this.stopSearch();
            keyEvent.consume();
            return;
        }
        c = Character.toLowerCase(c);
        if (this.direction == 2) {
            this.findPrev(this.search + c);
        } else {
            this.findNext(this.search + c);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.stopSearch();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        GTextArea gTextArea = new GTextArea("Hallo lieber Tester");
        frame.add(gTextArea);
        frame.pack();
        frame.show();
    }
}

